/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.comment;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.CommentAware;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.comment.ButtonComment;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommentCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CommentCellEditor.class);
    protected JTable table;
    protected AbstractTuttiTableModel<AbstractTuttiBeanUIModel> tableModel;
    protected Integer rowIndex;
    protected Integer columnIndex;
    protected final ButtonComment editorButton;

    public static TableCellEditor newEditor(TuttiUI ui) {
        return new CommentCellEditor(((AbstractTuttiUIHandler)ui.getHandler()).getContext());
    }

    public CommentCellEditor(TuttiUIContext context) {
        this.editorButton = new ButtonComment(context, null);
        this.editorButton.setBorder(new LineBorder(Color.BLACK));
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                CommentCellEditor.this.editorButton.setSelected(false);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                CommentCellEditor.this.editorButton.setSelected(false);
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.tableModel = (AbstractTuttiTableModel)table.getModel();
        this.rowIndex = row;
        this.columnIndex = column;
        CommentAware model = (CommentAware)((Object)this.tableModel.getEntry(row));
        this.editorButton.init(model);
        return this.editorButton;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        CommentAware model = this.editorButton.getBean();
        Preconditions.checkNotNull((Object)model, (Object)"No model found in editor.");
        String result = model.getComment();
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor value: " + result));
        }
        return result;
    }

    @Override
    public boolean stopCellEditing() {
        boolean b = super.stopCellEditing();
        if (b) {
            this.editorButton.setBean(null);
        }
        return b;
    }

    @Override
    public void cancelCellEditing() {
        this.editorButton.setBean(null);
        super.cancelCellEditing();
    }
}

