/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import liquibase.change.AbstractSQLChange;
import liquibase.change.CheckSum;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.logging.LogFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

public class SQLFileChange
extends AbstractSQLChange {
    private String path;
    private String encoding = null;
    private Boolean relativeToChangelogFile;

    public SQLFileChange() {
        super("sqlFile", "SQL From File", 1);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String fileName) {
        this.path = fileName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean isRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }

    public void setRelativeToChangelogFile(Boolean relativeToChangelogFile) {
        this.relativeToChangelogFile = relativeToChangelogFile;
    }

    public void init() throws SetupException {
        if (this.path == null) {
            throw new SetupException("<sqlfile> - No path specified");
        }
        LogFactory.getLogger().debug("SQLFile file:" + this.path);
        boolean loaded = this.loadFromClasspath(this.path);
        if (!loaded) {
            loaded = this.loadFromFileSystem(this.path);
        }
        if (!loaded) {
            throw new SetupException("<sqlfile path=" + this.path + "> - Could not find file");
        }
        LogFactory.getLogger().debug("SQLFile file contents is:" + this.getSql());
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (StringUtils.trimToNull(this.getPath()) == null) {
            validationErrors.addError("'path' is required");
        }
        return validationErrors;
    }

    public Warnings warn(Database database) {
        return new Warnings();
    }

    private boolean loadFromFileSystem(String file) throws SetupException {
        if (this.relativeToChangelogFile != null && this.relativeToChangelogFile.booleanValue()) {
            file = this.getChangeSet().getFilePath().replaceFirst("/[^/]*$", "") + "/" + file;
        }
        InputStream fis = null;
        try {
            fis = this.getResourceAccessor().getResourceAsStream(file);
            if (fis == null) {
                throw new SetupException("<sqlfile path=" + file + "> -Unable to read file");
            }
            this.setSql(StreamUtil.getStreamContents(fis, this.encoding));
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fnfe) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new SetupException("<sqlfile path=" + file + "> -Unable to read file", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromClasspath(String file) throws SetupException {
        if (this.relativeToChangelogFile != null && this.relativeToChangelogFile.booleanValue()) {
            file = this.getChangeSet().getFilePath().replaceFirst("/[^/]*$", "") + "/" + file;
        }
        InputStream in = null;
        try {
            ResourceAccessor fo = this.getResourceAccessor();
            if (fo == null) {
                boolean bl = false;
                return bl;
            }
            in = fo.getResourceAsStream(file);
            if (in == null) {
                boolean bl = false;
                return bl;
            }
            this.setSql(StreamUtil.getStreamContents(in, this.encoding));
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public CheckSum generateCheckSum() {
        String sql = this.getSql();
        if (sql == null) {
            sql = "";
        }
        return CheckSum.compute(sql);
    }

    public String getConfirmationMessage() {
        return "SQL in file " + this.path + " executed";
    }

    public void setSql(String sql) {
        if (this.getChangeLogParameters() != null) {
            sql = this.getChangeLogParameters().expandExpressions(sql);
        }
        super.setSql(sql);
    }
}

