/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.translation;

import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.namespace.NamespaceComponents;
import org.andromda.core.translation.Expression;
import org.andromda.core.translation.Translator;
import org.andromda.core.translation.TranslatorException;
import org.andromda.core.translation.library.LibraryTranslation;
import org.andromda.core.translation.library.LibraryTranslationFinder;
import org.apache.log4j.Logger;

public class ExpressionTranslator {
    private static Logger logger = Logger.getLogger((Class)(class$org$andromda$core$translation$ExpressionTranslator == null ? (class$org$andromda$core$translation$ExpressionTranslator = ExpressionTranslator.class$("org.andromda.core.translation.ExpressionTranslator")) : class$org$andromda$core$translation$ExpressionTranslator));
    private static ExpressionTranslator translator = new ExpressionTranslator();
    static /* synthetic */ Class class$org$andromda$core$translation$ExpressionTranslator;

    public static ExpressionTranslator instance() {
        return translator;
    }

    public void initialize() {
        AndroMDALogger.initialize();
        NamespaceComponents.instance().discover();
    }

    public Expression translate(String translationName, String expression, Object contextElement) {
        ExceptionUtils.checkEmpty("translationName", translationName);
        ExceptionUtils.checkEmpty("expression", expression);
        Expression translatedExpression = null;
        try {
            LibraryTranslation libraryTranslation = LibraryTranslationFinder.findLibraryTranslation(translationName);
            if (libraryTranslation != null) {
                Translator translator = libraryTranslation.getTranslator();
                translatedExpression = translator.translate(translationName, expression, contextElement);
            } else {
                logger.error((Object)("ERROR! No translation found with name --> '" + translationName + "'"));
            }
        }
        catch (Throwable throwable) {
            throw new TranslatorException(throwable);
        }
        return translatedExpression;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

