/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.io.Serializable;
import java.util.Map;

public class PupitriCatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Species species;
    protected boolean sorted;
    protected Map<Signs, Float> weightBySign = Maps.newHashMap();

    public PupitriCatch(Species species, boolean sorted) {
        this.species = species;
        this.sorted = sorted;
    }

    public Species getSpecies() {
        return this.species;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public Map<Signs, Float> getWeightBySign() {
        return this.weightBySign;
    }

    public void addToSign(String sign, Float weight) {
        Signs s = Signs.getSign(sign);
        Float f = this.weightBySign.get((Object)s);
        if (f == null) {
            f = Float.valueOf(0.0f);
        }
        f = Float.valueOf(f.floatValue() + weight.floatValue());
        this.weightBySign.put(s, f);
    }

    public int hashCode() {
        int speciesHashCode = this.species != null ? this.species.hashCode() : 0;
        int sortedHashCode = this.sorted ? 0x55555555 : 0x2AAAAAAA;
        return speciesHashCode ^ sortedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PupitriCatch other = (PupitriCatch)obj;
        if (!(this.species == other.species || this.species != null && this.species.equals(other.species))) {
            return false;
        }
        return this.sorted == other.sorted;
    }

    public static enum Signs {
        DEFAULT("0"),
        MALE("1"),
        FEMALE("2"),
        SMALL("P"),
        MEDIUM("M"),
        BIG("G");

        private String sign;

        private Signs(String sign) {
            this.sign = sign;
        }

        public static Signs getSign(String sign) {
            Signs result = null;
            for (Signs s : Signs.values()) {
                if (!s.sign.equals(sign)) continue;
                result = s;
                break;
            }
            return result;
        }
    }
}

