// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.taxon;

/**
 * <p>
 * Il désigne un ensemble de taxons appartenant à des groupes
 * taxinomiques différents mais ayant les mêmes caractéristiques
 * pour un critère donné. Ce critère peut être morpho-anatomique
 * (par exemple les strates algales ou la taille des organismes),
 * comportemental (par exemple des groupes trophiques ou des modes
 * de déplacement), ou encore basé sur des notions plus complexes
 * comme la polluo-sensibilité (exemple des groupes écologiques
 * définis pour les macroinvertébrés benthiques). Pour un critère
 * donné, les groupes de taxons sont rassemblés dans un
 * regroupement appelé groupe de taxons père.
 * </p>
 * <p>
 * Les groupes de taxons sont de deux catégories :
 * </p>
 * <p>
 * - Descriptif : c'est à dire seulement utilisé pour l'extraction
 * de données. Les regroupements de taxons sont effectués en aval
 * de la mesure effectuée.
 * </p>
 * <p>
 * - Identification : il s'agit de regroupements utilisés pour
 * identifier des catégories de taxons sur le terrain ou en
 * laboratoire, lorsqu'il est difficile d'opérer une identification
 * précise ou lorsque celle-ci s'avère tout simplement impossible
 * ou non pertinente. Le regroupement des taxons s'effectue alors
 * en amont de la mesure.
 * </p>
 * <p>
 * Certains groupes peuvent être figés, c'est à dire qu'ils sont
 * définis une bonne fois pour toute dans un document. Pour ce
 * dernier cas particulier, il n'y a donc, a priori, pas besoin de
 * mise à jour, et encore moins de pouvoir les supprimer : ils sont
 * donc non modifiables (mais ce ne doit pas être une règle
 * générale)
 * </p>
 */
public abstract class TaxonGroup
    implements java.io.Serializable
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -8545358162349439616L;

    private java.lang.Integer id;

    /**
     * <p>
     * Identifiant unique du groupe de taxons.
     * </p>
     */
    public java.lang.Integer getId()
    {
        return this.id;
    }

    public void setId(java.lang.Integer id)
    {
        this.id = id;
    }

    private java.lang.String label;

    /**
     * <p>
     * Code (ou mnénomique) du groupe de taxons. Ceci peut être un code
     * de quelques caractères identifiant le groupe. (exemple: Ca pour
     * carnivores)
     * </p>
     */
    public java.lang.String getLabel()
    {
        return this.label;
    }

    public void setLabel(java.lang.String label)
    {
        this.label = label;
    }

    private java.lang.String name;

    /**
     * <p>
     * Nom du groupe de taxons.
     * </p>
     */
    public java.lang.String getName()
    {
        return this.name;
    }

    public void setName(java.lang.String name)
    {
        this.name = name;
    }

    private java.lang.String comments;

    /**
     * <p>
     * Commentaire long associé au groupe de taxons.
     * </p>
     */
    public java.lang.String getComments()
    {
        return this.comments;
    }

    public void setComments(java.lang.String comments)
    {
        this.comments = comments;
    }

    private java.lang.Boolean isChildGroupExclusive;

    /**
     * <p>
     * Ce champ permet de renseigner si les groupes de taxons fils sont
     * exclusifs ou pas. Par défaut, les fils ne sont pas exclusifs.
     * S'ils sont exclusifs, un même taxon ne pourra pas faire parti de
     * plusieurs groupes du même taxon père.
     * </p>
     */
    public java.lang.Boolean getIsChildGroupExclusive()
    {
        return this.isChildGroupExclusive;
    }

    public void setIsChildGroupExclusive(java.lang.Boolean isChildGroupExclusive)
    {
        this.isChildGroupExclusive = isChildGroupExclusive;
    }

    private java.lang.Boolean isUpdatable;

    /**
     * <p>
     * Cette information permet de savoir si un groupe de taxons est
     * modifiable ou pas dans l'interface de mise à jour.
     * </p>
     */
    public java.lang.Boolean getIsUpdatable()
    {
        return this.isUpdatable;
    }

    public void setIsUpdatable(java.lang.Boolean isUpdatable)
    {
        this.isUpdatable = isUpdatable;
    }

    private java.util.Date creationDate;

    /**
     * <p>
     * Date de création système du groupe. Renseigné automatiquement
     * par le système.
     * </p>
     */
    public java.util.Date getCreationDate()
    {
        return this.creationDate;
    }

    public void setCreationDate(java.util.Date creationDate)
    {
        this.creationDate = creationDate;
    }

    private java.sql.Timestamp updateDate;

    /**
     * <p>
     * Date de mise à jour système du groupe. Renseigné automatiquement
     * par le système.
     * </p>
     */
    public java.sql.Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    public void setUpdateDate(java.sql.Timestamp updateDate)
    {
        this.updateDate = updateDate;
    }













    private java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup> childTaxonGroup = new java.util.HashSet<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup>();

    /**
     * 
     */
    public java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup> getChildTaxonGroup()
    {
        return this.childTaxonGroup;
    }

    public void setChildTaxonGroup(java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup> childTaxonGroup)
    {
        this.childTaxonGroup = childTaxonGroup;
    }


    private fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup parentTaxonGroup;

    /**
     * 
     */
    public fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup getParentTaxonGroup()
    {
        return this.parentTaxonGroup;
    }

    public void setParentTaxonGroup(fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup parentTaxonGroup)
    {
        this.parentTaxonGroup = parentTaxonGroup;
    }


    private fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupType taxonGroupType;

    /**
     * 
     */
    public fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupType getTaxonGroupType()
    {
        return this.taxonGroupType;
    }

    public void setTaxonGroupType(fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupType taxonGroupType)
    {
        this.taxonGroupType = taxonGroupType;
    }


    private java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupHistoricalRecord> taxonGroupHistoricalRecords = new java.util.HashSet<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupHistoricalRecord>();

    /**
     * 
     */
    public java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupHistoricalRecord> getTaxonGroupHistoricalRecords()
    {
        return this.taxonGroupHistoricalRecords;
    }

    public void setTaxonGroupHistoricalRecords(java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupHistoricalRecord> taxonGroupHistoricalRecords)
    {
        this.taxonGroupHistoricalRecords = taxonGroupHistoricalRecords;
    }


    private java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupInformation> taxonGroupInformations = new java.util.HashSet<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupInformation>();

    /**
     * 
     */
    public java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupInformation> getTaxonGroupInformations()
    {
        return this.taxonGroupInformations;
    }

    public void setTaxonGroupInformations(java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupInformation> taxonGroupInformations)
    {
        this.taxonGroupInformations = taxonGroupInformations;
    }


    private fr.ifremer.adagio.core.dao.referential.Status status;

    /**
     * 
     */
    public fr.ifremer.adagio.core.dao.referential.Status getStatus()
    {
        return this.status;
    }

    public void setStatus(fr.ifremer.adagio.core.dao.referential.Status status)
    {
        this.status = status;
    }




    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only return <code>true</code> if the argument reference and <code>this</code>
     * refer to the same object.
     */
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof TaxonGroup))
        {
            return false;
        }
        final TaxonGroup that = (TaxonGroup)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (id == null ? 0 : id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup}.
         */
        public static fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup newInstance()
        {
            final fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup entity = new fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupImpl();
			return entity;
        }

        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup}, taking all required and/or
         * read-only properties as arguments.
         */
        public static fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup newInstance(java.lang.String name, java.lang.Boolean isChildGroupExclusive, java.lang.Boolean isUpdatable, java.util.Date creationDate, fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupType taxonGroupType, fr.ifremer.adagio.core.dao.referential.Status status)
        {
            final fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup entity = newInstance();
            entity.setName(name);
            entity.setIsChildGroupExclusive(isChildGroupExclusive);
            entity.setIsUpdatable(isUpdatable);
            entity.setCreationDate(creationDate);
            entity.setTaxonGroupType(taxonGroupType);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup}, taking all possible properties
         * (except the identifier(s))as arguments.
         */
        public static fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup newInstance(java.lang.String label, java.lang.String name, java.lang.String comments, java.lang.Boolean isChildGroupExclusive, java.lang.Boolean isUpdatable, java.util.Date creationDate, java.sql.Timestamp updateDate, java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup> childTaxonGroup, fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup parentTaxonGroup, fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupType taxonGroupType, java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupHistoricalRecord> taxonGroupHistoricalRecords, java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupInformation> taxonGroupInformations, fr.ifremer.adagio.core.dao.referential.Status status)
        {
            final fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup entity = newInstance();
            entity.setLabel(label);
            entity.setName(name);
            entity.setComments(comments);
            entity.setIsChildGroupExclusive(isChildGroupExclusive);
            entity.setIsUpdatable(isUpdatable);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setChildTaxonGroup(childTaxonGroup);
            entity.setParentTaxonGroup(parentTaxonGroup);
            entity.setTaxonGroupType(taxonGroupType);
            entity.setTaxonGroupHistoricalRecords(taxonGroupHistoricalRecords);
            entity.setTaxonGroupInformations(taxonGroupInformations);
            entity.setStatus(status);
            return entity;
        }
    }
    
// TaxonGroup.java merge-point
}