/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.config.TuttiServiceConfig;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.util.DateUtil;

public class TuttiDataContext
extends AbstractBean
implements Closeable {
    private static final Log log = LogFactory.getLog(TuttiDataContext.class);
    public static final String PROPERTY_PROGRAM_ID = "programId";
    public static final String PROPERTY_CRUISE_ID = "cruiseId";
    public static final String PROPERTY_PROTOCOL_ID = "protocolId";
    public static final String PROPERTY_FISHING_OPERATION_ID = "fishingOperationId";
    public static final String PROPERTY_PROGRAM_FILLED = "programFilled";
    public static final String PROPERTY_CRUISE__FILLED = "cruiseFilled";
    public static final String PROPERTY_PROTOCOL_FILLED = "protocolFilled";
    public static final String PROPERTY_FISHING_OPERATION_FILLED = "fishingOperationFilled";
    protected String programId;
    protected String cruiseId;
    protected String protocolId;
    protected String fishingOperationId;
    protected SampleCategoryModel sampleCategoryModel;
    protected Program program;
    protected Cruise cruise;
    protected TuttiProtocol protocol;
    protected FishingOperation fishingOperation;
    protected List<Caracteristic> caracteristics;
    protected List<Caracteristic> caracteristicsWithProtected;
    protected List<Caracteristic> lengthStepCaracteristics;
    protected List<CaracteristicQualitativeValue> genderValues;
    protected List<CaracteristicQualitativeValue> deadOrAliveValues;
    protected List<Person> persons;
    protected List<Species> species;
    protected List<Species> referentSpeciesWithSurveyCode;
    protected List<Species> referentBenthosWithSurveyCode;
    protected List<Species> referentSpecies;
    protected List<Vessel> fishingVessels;
    protected List<Vessel> scientificVessels;
    protected List<Gear> fishingGears;
    protected List<Gear> scientificGears;
    protected PersistenceService service;
    protected final TuttiValidationDataContext validationContext = new TuttiValidationDataContext();

    TuttiDataContext() {
        this.addPropertyChangeListener(PROPERTY_PROGRAM_ID, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiDataContext.this.program = null;
            }
        });
        this.addPropertyChangeListener(PROPERTY_CRUISE_ID, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiDataContext.this.cruise = null;
            }
        });
        this.addPropertyChangeListener(PROPERTY_PROTOCOL_ID, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiDataContext.this.resetProtocol();
                TuttiDataContext.this.resetSpecies();
            }
        });
        this.addPropertyChangeListener(PROPERTY_FISHING_OPERATION_ID, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiDataContext.this.fishingOperation = null;
                TuttiDataContext.this.getValidationContext().existingFishingOperations = null;
            }
        });
    }

    public void open(TuttiServiceConfig config, PersistenceService persistenceService) {
        this.close();
        this.service = persistenceService;
        this.loadSampleCategoryModel(config.getPersistenceConfig().getSampleCategoryModel());
    }

    @Override
    public void close() {
        this.service = null;
        this.clearContext();
    }

    public void clearContext() {
        this.program = null;
        this.cruise = null;
        this.fishingOperation = null;
        this.sampleCategoryModel = null;
        this.resetProtocol();
        this.resetVessels();
        this.resetGears();
        this.resetPersons();
        this.resetSpecies();
        this.resetValidationDataContext();
    }

    public void checkDbContext() {
        String saneProtocolId = null;
        String saneProgramId = null;
        String saneCruiseId = null;
        String oldProtocolId = this.getProtocolId();
        String oldProgramId = this.getProgramId();
        String oldCruiseId = this.getCruiseId();
        if (this.isProtocolFilled()) {
            if (!this.service.isProtocolExist(oldProtocolId)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Remove invalid protocolId: " + oldProtocolId));
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("protocolId valid: " + oldProtocolId));
                }
                saneProtocolId = oldProtocolId;
            }
        }
        if (this.isProgramFilled()) {
            Program program = null;
            try {
                program = this.service.getProgram(oldProgramId);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (program == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Remove invalid programId: " + oldProgramId));
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("ProgramId valid: " + oldProgramId));
                }
                saneProgramId = oldProgramId;
                if (this.isCruiseFilled()) {
                    Cruise cruise = null;
                    try {
                        cruise = this.service.getCruise(oldCruiseId);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (cruise != null && !cruise.getProgram().getId().equals(oldProgramId)) {
                        cruise = null;
                    }
                    if (cruise == null) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Remove invalid cruiseId: " + oldCruiseId));
                        }
                        this.setCruiseId(null);
                    } else {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("CruiseId valid: " + oldCruiseId));
                        }
                        saneCruiseId = oldCruiseId;
                    }
                }
            }
        }
        boolean oldProtocolFilled = this.isProtocolFilled();
        boolean oldProgramFilled = this.isProgramFilled();
        boolean oldCruiseFilled = this.isCruiseFilled();
        this.programId = saneProgramId;
        this.cruiseId = saneCruiseId;
        this.protocolId = saneProtocolId;
        this.firePropertyChange(PROPERTY_PROGRAM_FILLED, oldProgramFilled, this.isProgramFilled());
        this.firePropertyChange(PROPERTY_PROTOCOL_FILLED, oldProtocolFilled, this.isProtocolFilled());
        this.firePropertyChange(PROPERTY_CRUISE__FILLED, oldCruiseFilled, this.isCruiseFilled());
        this.firePropertyChange(PROPERTY_PROGRAM_ID, oldProgramId, saneProgramId);
        this.firePropertyChange(PROPERTY_PROTOCOL_ID, oldProtocolId, saneProtocolId);
        this.firePropertyChange(PROPERTY_CRUISE_ID, oldCruiseId, saneCruiseId);
    }

    public SampleCategoryModel getSampleCategoryModel() {
        return this.sampleCategoryModel;
    }

    public String getProgramId() {
        return this.programId;
    }

    public String getCruiseId() {
        return this.cruiseId;
    }

    public String getProtocolId() {
        return this.protocolId;
    }

    public String getFishingOperationId() {
        return this.fishingOperationId;
    }

    public boolean isCruiseFilled() {
        return this.isProgramFilled() && StringUtils.isNotBlank((CharSequence)this.cruiseId);
    }

    public boolean isProtocolFilled() {
        return StringUtils.isNotBlank((CharSequence)this.protocolId);
    }

    public boolean isProgramFilled() {
        return StringUtils.isNotBlank((CharSequence)this.programId);
    }

    public boolean isFishingOperationFilled() {
        return StringUtils.isNotBlank((CharSequence)this.fishingOperationId);
    }

    public void setProgramId(String programId) {
        boolean oldProgramFilled = this.isProgramFilled();
        boolean oldCruiseFilled = this.isCruiseFilled();
        this.programId = programId;
        this.firePropertyChange(PROPERTY_PROGRAM_ID, -1, programId);
        this.firePropertyChange(PROPERTY_PROGRAM_FILLED, oldProgramFilled, this.isProgramFilled());
        this.firePropertyChange(PROPERTY_CRUISE__FILLED, oldCruiseFilled, this.isCruiseFilled());
    }

    public void setCruiseId(String cruiseId) {
        boolean oldValue = this.isCruiseFilled();
        this.cruiseId = cruiseId;
        this.firePropertyChange(PROPERTY_CRUISE_ID, -1, cruiseId);
        this.firePropertyChange(PROPERTY_CRUISE__FILLED, oldValue, this.isCruiseFilled());
    }

    public void setProtocolId(String protocolId) {
        boolean oldValue = this.isProtocolFilled();
        this.protocolId = protocolId;
        this.firePropertyChange(PROPERTY_PROTOCOL_ID, -1, protocolId);
        this.firePropertyChange(PROPERTY_PROTOCOL_FILLED, oldValue, this.isProtocolFilled());
    }

    public void setFishingOperationId(String fishingOperationId) {
        boolean oldValue = this.isFishingOperationFilled();
        this.fishingOperationId = fishingOperationId;
        this.firePropertyChange(PROPERTY_FISHING_OPERATION_ID, -1, fishingOperationId);
        this.firePropertyChange(PROPERTY_FISHING_OPERATION_FILLED, oldValue, this.isFishingOperationFilled());
    }

    public Program getProgram() {
        this.checkOpened();
        if (this.program == null && this.isProgramFilled()) {
            String id = this.getProgramId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading program: " + id));
            }
            this.program = this.service.getProgram(id);
        }
        return this.program;
    }

    public Cruise getCruise() {
        this.checkOpened();
        if (this.cruise == null && this.isCruiseFilled()) {
            String id = this.getCruiseId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading cruise: " + id));
            }
            this.cruise = this.service.getCruise(id);
        }
        return this.cruise;
    }

    public TuttiProtocol getProtocol() {
        this.checkOpened();
        if (this.protocol == null && this.isProtocolFilled()) {
            String id = this.getProtocolId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading protocol: " + id));
            }
            this.protocol = this.service.getProtocol(id);
        }
        return this.protocol;
    }

    public FishingOperation getFishingOperation() {
        this.checkOpened();
        if (this.fishingOperation == null && this.isFishingOperationFilled()) {
            String id = this.getFishingOperationId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading fishingOperation: " + id));
            }
            this.fishingOperation = this.service.getFishingOperation(id);
        }
        return this.fishingOperation;
    }

    public List<Caracteristic> getCaracteristics() {
        this.checkOpened();
        if (this.caracteristics == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allCaracteristic");
            }
            this.caracteristics = this.service.getAllCaracteristic();
        }
        return this.caracteristics;
    }

    public List<Caracteristic> getCaracteristicWithProtected() {
        this.checkOpened();
        if (this.caracteristicsWithProtected == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allCaracteristicWithProtected");
            }
            this.caracteristicsWithProtected = this.service.getAllCaracteristicWithProtected();
        }
        return this.caracteristicsWithProtected;
    }

    public List<Caracteristic> getLengthStepCaracteristics() {
        this.checkOpened();
        if (this.lengthStepCaracteristics == null) {
            if (this.isProtocolFilled()) {
                this.protocol = this.getProtocol();
                this.lengthStepCaracteristics = Lists.newArrayListWithCapacity((int)this.protocol.sizeLengthClassesPmfmId());
                Map allCaractericsById = TuttiEntities.splitById(this.getCaracteristics());
                if (!this.protocol.isLengthClassesPmfmIdEmpty()) {
                    for (String id : this.protocol.getLengthClassesPmfmId()) {
                        this.lengthStepCaracteristics.add((Caracteristic)allCaractericsById.get(id));
                    }
                }
            } else {
                this.lengthStepCaracteristics = Lists.newArrayList(this.getCaracteristics());
            }
            this.lengthStepCaracteristics = Collections.unmodifiableList(this.lengthStepCaracteristics);
        }
        return this.lengthStepCaracteristics;
    }

    public List<CaracteristicQualitativeValue> getGenderValues() {
        this.checkOpened();
        if (this.genderValues == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading genderValues");
            }
            this.genderValues = this.service.getSexCaracteristic().getQualitativeValue();
        }
        return this.genderValues;
    }

    public List<CaracteristicQualitativeValue> getDeadOrAliveValues() {
        this.checkOpened();
        if (this.deadOrAliveValues == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading deadOrAliveValues");
            }
            this.deadOrAliveValues = this.service.getDeadOrAliveCaracteristic().getQualitativeValue();
        }
        return this.deadOrAliveValues;
    }

    public List<Species> getReferentSpeciesWithSurveyCode() {
        this.checkOpened();
        if (this.referentSpeciesWithSurveyCode == null) {
            if (this.isProtocolFilled()) {
                TuttiProtocol protocol = this.getProtocol();
                Preconditions.checkNotNull((Object)protocol, (Object)"Could not find protocol in ui context");
                this.referentSpeciesWithSurveyCode = Lists.newArrayList();
                if (!protocol.isSpeciesEmpty()) {
                    Map map = TuttiEntities.splitByTaxonId(this.getReferentSpecies());
                    for (SpeciesProtocol protocolSpecy : protocol.getSpecies()) {
                        String taxonId = String.valueOf(protocolSpecy.getSpeciesReferenceTaxonId());
                        Species species = (Species)map.get(taxonId);
                        species.setSurveyCode(protocolSpecy.getSpeciesSurveyCode());
                        this.referentSpeciesWithSurveyCode.add(species);
                    }
                }
            } else {
                this.referentSpeciesWithSurveyCode = Lists.newArrayList(this.getReferentSpecies());
            }
            this.referentSpeciesWithSurveyCode = Collections.unmodifiableList(this.referentSpeciesWithSurveyCode);
        }
        return this.referentSpeciesWithSurveyCode;
    }

    public List<Species> getReferentBenthosWithSurveyCode() {
        this.checkOpened();
        if (this.referentBenthosWithSurveyCode == null) {
            if (this.isProtocolFilled()) {
                TuttiProtocol protocol = this.getProtocol();
                Preconditions.checkNotNull((Object)protocol, (Object)"Could not find protocol in ui context");
                this.referentBenthosWithSurveyCode = Lists.newArrayList();
                if (!protocol.isBenthosEmpty()) {
                    Map map = TuttiEntities.splitByTaxonId(this.getReferentSpecies());
                    for (SpeciesProtocol protocolSpecy : protocol.getBenthos()) {
                        String taxonId = String.valueOf(protocolSpecy.getSpeciesReferenceTaxonId());
                        Species species = (Species)map.get(taxonId);
                        species.setSurveyCode(protocolSpecy.getSpeciesSurveyCode());
                        this.referentBenthosWithSurveyCode.add(species);
                    }
                }
            } else {
                this.referentBenthosWithSurveyCode = Lists.newArrayList(this.getReferentSpecies());
            }
            this.referentBenthosWithSurveyCode = Collections.unmodifiableList(this.referentBenthosWithSurveyCode);
        }
        return this.referentBenthosWithSurveyCode;
    }

    public List<Species> getSpecies() {
        if (this.species == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allSpecies");
            }
            this.species = this.service.getAllSpecies(this.protocol);
        }
        return this.species;
    }

    public List<Species> getReferentSpecies() {
        if (this.referentSpecies == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allReferentSpecies");
            }
            this.referentSpecies = this.service.getAllReferentSpecies(this.protocol);
        }
        return this.referentSpecies;
    }

    public List<Person> getPersons() {
        this.checkOpened();
        if (this.persons == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allPerson");
            }
            this.persons = this.service.getAllPerson();
        }
        return this.persons;
    }

    public List<Vessel> getFishingVessels() {
        this.checkOpened();
        if (this.fishingVessels == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allfishingVessel");
            }
            this.fishingVessels = this.service.getAllFishingVessel();
        }
        return this.fishingVessels;
    }

    public List<Vessel> getScientificVessels() {
        this.checkOpened();
        if (this.scientificVessels == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allScientificVessel");
            }
            this.scientificVessels = this.service.getAllScientificVessel();
        }
        return this.scientificVessels;
    }

    public List<Gear> getFishingGears() {
        this.checkOpened();
        if (this.fishingGears == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allFishingGear");
            }
            this.fishingGears = this.service.getAllFishingGear();
        }
        return this.fishingGears;
    }

    public List<Gear> getScientificGears() {
        this.checkOpened();
        if (this.scientificGears == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Loading allScientificGear");
            }
            this.scientificGears = this.service.getAllScientificGear();
        }
        return this.scientificGears;
    }

    public void resetCruise() {
        this.cruise = null;
    }

    public void resetProtocol() {
        this.protocol = null;
        this.lengthStepCaracteristics = null;
    }

    public void resetGears() {
        this.fishingGears = null;
        this.scientificGears = null;
    }

    public void resetVessels() {
        this.fishingVessels = null;
        this.scientificVessels = null;
    }

    public void resetPersons() {
        this.persons = null;
    }

    public void resetSpecies() {
        this.species = null;
        this.referentSpecies = null;
        this.referentSpeciesWithSurveyCode = null;
        this.referentBenthosWithSurveyCode = null;
    }

    public void resetCaracteristics() {
        this.caracteristics = null;
    }

    public void loadSampleCategoryModel(SampleCategoryModel sampleCategoryModel) {
        this.sampleCategoryModel = sampleCategoryModel;
        sampleCategoryModel.load((TuttiPersistence)this.service);
    }

    protected void checkOpened() {
        Preconditions.checkState((this.service != null ? 1 : 0) != 0, (Object)"No persistence service assigned!");
    }

    public PersistenceService getService() {
        return this.service;
    }

    public void resetValidationDataContext() {
        this.validationContext.reset();
    }

    public TuttiValidationDataContext getValidationContext() {
        return this.validationContext;
    }

    public class TuttiValidationDataContext {
        protected List<Program> existingPrograms = Lists.newArrayList();
        protected List<TuttiProtocol> existingProtocols = Lists.newArrayList();
        protected List<FishingOperation> existingFishingOperations = Lists.newArrayList();

        public List<Program> getExistingPrograms() {
            TuttiDataContext.this.checkOpened();
            if (this.existingPrograms == null) {
                this.existingPrograms = Lists.newArrayList(TuttiDataContext.this.service.getAllProgram());
                if (TuttiDataContext.this.isProgramFilled()) {
                    this.existingPrograms.remove(TuttiDataContext.this.getProgram());
                }
            }
            return this.existingPrograms;
        }

        public List<TuttiProtocol> getExistingProtocols() {
            TuttiDataContext.this.checkOpened();
            if (this.existingProtocols == null) {
                this.existingProtocols = Lists.newArrayList(TuttiDataContext.this.service.getAllProtocol());
                if (TuttiDataContext.this.isProtocolFilled()) {
                    this.existingProtocols.remove(TuttiDataContext.this.getProtocol());
                }
            }
            return this.existingProtocols;
        }

        public List<FishingOperation> getExistingFishingOperations() {
            TuttiDataContext.this.checkOpened();
            if (this.existingFishingOperations == null) {
                this.existingFishingOperations = Lists.newArrayList(TuttiDataContext.this.service.getAllFishingOperation(TuttiDataContext.this.getCruiseId()));
                if (TuttiDataContext.this.isFishingOperationFilled()) {
                    this.existingFishingOperations.remove(TuttiDataContext.this.getFishingOperation());
                }
            }
            return this.existingFishingOperations;
        }

        public boolean isDateInCruise(Date date) {
            return DateUtil.between((Date)date, (Date)TuttiDataContext.this.getCruise().getBeginDate(), (Date)TuttiDataContext.this.getCruise().getEndDate());
        }

        public boolean isValidDuration(Date gearShootingStartDate, Date gearShootingEndDate) {
            boolean result;
            boolean bl = result = gearShootingStartDate == null || gearShootingEndDate == null;
            if (!result) {
                int minutes = DateUtil.getDifferenceInMinutes((Date)gearShootingStartDate, (Date)gearShootingEndDate);
                result |= minutes <= 45 && minutes >= 20;
            }
            return result;
        }

        public void reset() {
            this.existingPrograms = null;
            this.existingProtocols = null;
            this.existingFishingOperations = null;
        }
    }
}

