package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: SampleCategoryColumnIdentifier.java 1153 2013-07-24 17:35:44Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/SampleCategoryColumnIdentifier.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2
 */
public class SampleCategoryColumnIdentifier<R extends SampleCategoryAble> extends ColumnIdentifier<R> {

    private static final long serialVersionUID = 1L;

    public static <R extends SampleCategoryAble> SampleCategoryColumnIdentifier<R> newId(String propertyName,
                                                                                         Integer sampleCategoryId,
                                                                                         String headerI18nKey,
                                                                                         String headerTipI18nKey) {
        return new SampleCategoryColumnIdentifier<R>(propertyName,
                                                     sampleCategoryId,
                                                     headerI18nKey,
                                                     headerTipI18nKey);
    }

    private final Integer sampleCategoryId;

    SampleCategoryColumnIdentifier(String propertyName,
                                   Integer sampleCategoryId,
                                   String headerI18nKey,
                                   String headerTipI18nKey) {
        super(propertyName, headerI18nKey, headerTipI18nKey);
        this.sampleCategoryId = sampleCategoryId;
    }

    @Override
    public Object getValue(R entry) {
        SampleCategory sampleCategory = entry.getSampleCategoryById(getSampleCategoryId());
        return sampleCategory;
    }

    public void setWeightValue(R entry, Object value) {

        entry.setSampleCategoryWeight(getSampleCategoryId(), value);
    }

    public Integer getSampleCategoryId() {
        return sampleCategoryId;
    }

}
