/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;

public class SpeciesFrequencyTableModel
extends AbstractTuttiTableModel<SpeciesFrequencyRowModel> {
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> LENGTH_STEP = ColumnIdentifier.newId("lengthStep", I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> NUMBER = ColumnIdentifier.newId("number", I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> WEIGHT = ColumnIdentifier.newId("weight", I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]));
    private final SpeciesFrequencyUIModel uiModel;
    private final Map<Float, SpeciesFrequencyRowModel> rowCache;

    public SpeciesFrequencyTableModel(TableColumnModelExt columnModel, SpeciesFrequencyUIModel uiModel) {
        super(columnModel, true, true);
        this.uiModel = uiModel;
        this.rowCache = Maps.newTreeMap();
        this.setNoneEditableCols(new ColumnIdentifier[0]);
    }

    @Override
    public SpeciesFrequencyRowModel createNewRow() {
        SpeciesFrequencyRowModel rowModel;
        Float lengthStep;
        Float defaultStep = null;
        int rowCount = this.getRowCount();
        if (rowCount > 0 && (lengthStep = (rowModel = (SpeciesFrequencyRowModel)this.getEntry(rowCount - 1)).getLengthStep()) != null) {
            defaultStep = Float.valueOf(this.uiModel.getLengthStep(lengthStep.floatValue() + this.uiModel.getStep()));
        }
        SpeciesFrequencyRowModel result = new SpeciesFrequencyRowModel();
        result.addPropertyChangeListener("lengthStep", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SpeciesFrequencyRowModel row;
                Float lengthStep;
                Float oldValue = (Float)evt.getOldValue();
                if (oldValue != null) {
                    SpeciesFrequencyTableModel.this.rowCache.remove(oldValue);
                }
                if ((lengthStep = (row = (SpeciesFrequencyRowModel)evt.getSource()).getLengthStep()) != null) {
                    SpeciesFrequencyTableModel.this.rowCache.put(lengthStep, row);
                }
            }
        });
        result.setLengthStepCaracteristic(this.uiModel.getLengthStepCaracteristic());
        result.setLengthStep(defaultStep);
        result.setValid(true);
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<SpeciesFrequencyRowModel> propertyName, SpeciesFrequencyRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
    }

    public Map<Float, SpeciesFrequencyRowModel> getRowCache() {
        return this.rowCache;
    }

    @Override
    protected void onRowsChanged(List<SpeciesFrequencyRowModel> data) {
        this.rowCache.clear();
        for (SpeciesFrequencyRowModel row : data) {
            Float lengthStep = row.getLengthStep();
            if (lengthStep == null) continue;
            this.rowCache.put(lengthStep, row);
        }
    }
}

