/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.data;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;

public enum SizeEnum implements TuttiEnumerationFile.TuttiEnumerable<Integer>
{
    SMALL("QUALITATIVE_SIZE_SMALL_ID"),
    MEDIUM("QUALITATIVE_SIZE_MEDIUM_ID"),
    BIG("QUALITATIVE_SIZE_BIG_ID");

    private final String fieldName;
    private Integer fieldValue;
    private boolean init;

    private SizeEnum(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Integer getFieldValue() {
        Preconditions.checkState((boolean)this.isInit(), (Object)("Enumeration " + this.getClass() + " was not init!"));
        return this.fieldValue;
    }

    @Override
    public void setFieldValue(Object fieldValue) {
        this.fieldValue = (Integer)fieldValue;
    }

    @Override
    public boolean isInit() {
        return this.init;
    }

    @Override
    public void setInit(boolean init) {
        this.init = init;
    }

    public boolean matchValue(CaracteristicQualitativeValue value) {
        return this.fieldValue.equals(Integer.valueOf(value.getId()));
    }

    public CaracteristicQualitativeValue getValue(Caracteristic c) {
        Preconditions.checkNotNull((Object)c);
        Preconditions.checkState((!c.isQualitativeValueEmpty() ? 1 : 0) != 0);
        CaracteristicQualitativeValue result = null;
        for (CaracteristicQualitativeValue value : c.getQualitativeValue()) {
            if (!this.matchValue(value)) continue;
            result = value;
            break;
        }
        return result;
    }
}

