/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate.metafacades;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.andromda.cartridges.hibernate.HibernateProfile;
import org.andromda.cartridges.hibernate.HibernateUtils;
import org.andromda.cartridges.hibernate.metafacades.HibernateEntity;
import org.andromda.cartridges.hibernate.metafacades.HibernateEntityLogic;
import org.andromda.cartridges.hibernate.metafacades.HibernateMetafacadeUtils;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.Entity;
import org.andromda.metafacades.uml.EntityAttribute;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class HibernateEntityLogicImpl
extends HibernateEntityLogic {
    private static final String INHERITANCE_STRATEGY_CLASS = "class";
    private static final String INHERITANCE_STRATEGY_SUBCLASS = "subclass";
    private static final String INHERITANCE_STRATEGY_CONCRETE = "concrete";
    private static final String INHERITANCE_STRATEGY_INTERFACE = "interface";
    private static final String INHERITANCE_STRATEGY_UNION_SUBCLASS = "union-subclass";
    private static final Collection inheritanceStrategies = new ArrayList();
    private static final String INHERITANCE_STRATEGY = "hibernateInheritanceStrategy";
    private static final String HIBERNATE_ENTITY_CACHE = "hibernateEntityCache";
    private static final String HIBERNATE_DEFAULT_CASCADE = "hibernateDefaultCascade";
    private static final String DEFAULT_HIBERNATE_GENERATOR_CLASS = "defaultHibernateGeneratorClass";
    private static final String HIBERNATE_GENERATOR_CLASS_FOREIGN = "foreign";
    private static final String HIBERNATE_GENERATOR_CLASS_ASSIGNED = "assigned";
    private static final String HIBERNATE_GENERATOR_CLASS_SEQUENCE = "sequence";
    private static final String HIBERNATE_PROXY = "hibernateProxy";
    private static final String CLASS_MAPPING_NAME = "class";
    private static final String JOINED_SUBCLASS_MAPPING_NAME = "joined-subclass";
    private static final String SUBCLASS_MAPPING_NAME = "subclass";
    private static final String UNION_SUBCLASS_MAPPING_NAME = "union-subclass";
    private static final String SEQUENCE_IDENTIFIER_SUFFIX = "sequenceIdentifierSuffix";

    public HibernateEntityLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    protected Collection handleGetAllBusinessOperations() {
        Collection result = this.getBusinessOperations();
        for (Entity superElement = (Entity)this.getGeneralization(); superElement != null; superElement = (Entity)superElement.getGeneralization()) {
            result.addAll(superElement.getBusinessOperations());
        }
        return result;
    }

    protected String handleGetHibernateInheritanceStrategy() {
        String inheritance = HibernateEntityLogicImpl.getInheritance(this);
        HibernateEntity superEntity = this.getSuperEntity();
        while (superEntity != null && StringUtils.isBlank((String)inheritance)) {
            inheritance = superEntity.getHibernateInheritanceStrategy();
        }
        String string = inheritance = inheritance != null ? inheritance.toLowerCase() : null;
        if (StringUtils.isBlank((String)inheritance) || !inheritanceStrategies.contains(inheritance)) {
            inheritance = this.getDefaultInheritanceStrategy();
        }
        return inheritance;
    }

    private String getDefaultInheritanceStrategy() {
        return String.valueOf(this.getConfiguredProperty(INHERITANCE_STRATEGY));
    }

    private static String getInheritance(HibernateEntity entity) {
        Object value;
        String inheritance = null;
        if (entity != null && (value = entity.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_INHERITANCE)) != null) {
            inheritance = String.valueOf(value);
        }
        return inheritance;
    }

    public Collection getProperties() {
        Collection properties = this.getAttributes();
        List connectingEnds = this.getAssociationEnds();
        CollectionUtils.transform((Collection)connectingEnds, (Transformer)new Transformer(){

            public Object transform(Object object) {
                return ((AssociationEndFacade)object).getOtherEnd();
            }
        });
        class NavigableFilter
        implements Predicate {
            NavigableFilter() {
            }

            public boolean evaluate(Object object) {
                AssociationEndFacade end = (AssociationEndFacade)object;
                return end.isNavigable() || end.getOtherEnd().isChild() && HibernateEntityLogicImpl.this.isForeignHibernateGeneratorClass();
            }
        }
        CollectionUtils.filter((Collection)connectingEnds, (Predicate)new NavigableFilter());
        properties.addAll(connectingEnds);
        return properties;
    }

    protected boolean handleIsHibernateInheritanceClass() {
        return this.getHibernateInheritanceStrategy().equalsIgnoreCase("class");
    }

    protected boolean handleIsHibernateInheritanceInterface() {
        return this.getHibernateInheritanceStrategy().equalsIgnoreCase(INHERITANCE_STRATEGY_INTERFACE);
    }

    protected boolean handleIsHibernateInheritanceSubclass() {
        return this.getHibernateInheritanceStrategy().equalsIgnoreCase("subclass");
    }

    protected boolean handleIsHibernateInheritanceConcrete() {
        return this.getHibernateInheritanceStrategy().equalsIgnoreCase(INHERITANCE_STRATEGY_CONCRETE);
    }

    protected boolean handleIsHibernateInheritanceUnionSubClass() {
        String version = (String)this.getConfiguredProperty("hibernateVersion");
        return version.equals("3") && this.getHibernateInheritanceStrategy().equalsIgnoreCase("union-subclass");
    }

    protected boolean handleIsLazy() {
        String value = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_LAZY);
        if (StringUtils.isBlank((String)value)) {
            String version = (String)this.getConfiguredProperty("hibernateVersion");
            value = version.equals("2") ? "false" : "true";
        }
        return Boolean.valueOf(value);
    }

    protected String handleGetHibernateCacheType() {
        String cacheType = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ENTITY_CACHE);
        if (cacheType == null) {
            cacheType = String.valueOf(this.getConfiguredProperty(HIBERNATE_ENTITY_CACHE));
        }
        return cacheType;
    }

    protected String handleGetFullyQualifiedEntityName() {
        return HibernateMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getEntityName(), null);
    }

    protected String handleGetFullyQualifiedEntityImplementationName() {
        return HibernateMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getEntityImplementationName(), null);
    }

    protected String handleGetHibernateDefaultCascade() {
        return StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty(HIBERNATE_DEFAULT_CASCADE)));
    }

    protected String handleGetHibernateGeneratorClass() {
        String hibernateGeneratorClass;
        if (this.isUsingForeignIdentifier()) {
            hibernateGeneratorClass = HIBERNATE_GENERATOR_CLASS_FOREIGN;
        } else if (this.isUsingAssignedIdentifier()) {
            hibernateGeneratorClass = HIBERNATE_GENERATOR_CLASS_ASSIGNED;
        } else {
            hibernateGeneratorClass = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_GENERATOR_CLASS, false);
            if (StringUtils.isBlank((String)hibernateGeneratorClass)) {
                hibernateGeneratorClass = (String)this.getConfiguredProperty(DEFAULT_HIBERNATE_GENERATOR_CLASS);
            }
        }
        return StringUtils.trimToEmpty((String)hibernateGeneratorClass);
    }

    protected boolean handleIsForeignHibernateGeneratorClass() {
        return this.isUsingForeignIdentifier() || this.getHibernateGeneratorClass().equalsIgnoreCase(HIBERNATE_GENERATOR_CLASS_FOREIGN);
    }

    protected boolean handleIsSequenceHibernateGeneratorClass() {
        return this.getHibernateGeneratorClass().equalsIgnoreCase(HIBERNATE_GENERATOR_CLASS_SEQUENCE);
    }

    protected String handleGetEntityName() {
        String entityNamePattern = (String)this.getConfiguredProperty("entityNamePattern");
        return MessageFormat.format(entityNamePattern, StringUtils.trimToEmpty((String)this.getName()));
    }

    protected String handleGetEntityImplementationName() {
        String implNamePattern = String.valueOf(this.getConfiguredProperty("entityImplementationNamePattern"));
        return MessageFormat.format(implNamePattern, StringUtils.trimToEmpty((String)this.getName()));
    }

    protected String handleGetHibernateDiscriminatorColumn() {
        String column = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_ENTITY_DISCRIMINATOR_COLUMN);
        if (column == null) {
            column = String.valueOf(this.getConfiguredProperty("defaultEntityDiscriminatorColumn"));
        }
        return column;
    }

    protected String handleGetHibernateDiscriminatorFormula() {
        String formula = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_ENTITY_DISCRIMINATOR_FORMULA);
        return formula;
    }

    protected String handleGetHibernateDiscriminatorType() {
        String type = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_ENTITY_DISCRIMINATOR_TYPE);
        if (type == null) {
            type = String.valueOf(this.getConfiguredProperty("defaultEntityDiscriminatorType"));
        }
        return type;
    }

    protected int handleGetHibernateDiscriminatorLength() {
        return 1;
    }

    public Collection getBusinessOperations() {
        return HibernateMetafacadeUtils.filterBusinessOperations(super.getBusinessOperations());
    }

    protected boolean handleIsBusinessOperationsPresent() {
        Collection allBusinessOperations = this.getAllBusinessOperations();
        return allBusinessOperations != null && !allBusinessOperations.isEmpty();
    }

    protected boolean handleIsHibernateProxy() {
        String hibernateProxy = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_PROXY);
        if (hibernateProxy == null) {
            hibernateProxy = (String)this.getConfiguredProperty(HIBERNATE_PROXY);
        }
        return Boolean.valueOf(hibernateProxy);
    }

    protected int handleGetEhCacheMaxElementsInMemory() {
        String maxElements = null;
        maxElements = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_MAX_ELEMENTS);
        if (StringUtils.isBlank((String)maxElements)) {
            maxElements = (String)this.getConfiguredProperty("ehCacheMaxElementsInMemory");
        }
        return Integer.parseInt(StringUtils.trimToEmpty((String)maxElements));
    }

    protected boolean handleIsEhCacheEternal() {
        String eternal = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_ETERNAL);
        if (eternal == null) {
            eternal = (String)this.getConfiguredProperty("ehCacheEternal");
        }
        return Boolean.valueOf(StringUtils.trimToEmpty((String)eternal));
    }

    protected int handleGetEhCacheTimeToIdleSeconds() {
        String timeToIdle = null;
        timeToIdle = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_TIME_TO_IDLE);
        if (StringUtils.isBlank((String)timeToIdle)) {
            timeToIdle = (String)this.getConfiguredProperty("ehCacheTimeToIdleSeconds");
        }
        return Integer.parseInt(StringUtils.trimToEmpty((String)timeToIdle));
    }

    protected int handleGetEhCacheTimeToLiveSeconds() {
        String timeToLive = null;
        timeToLive = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_TIME_TO_LIVE);
        if (StringUtils.isBlank((String)timeToLive)) {
            timeToLive = (String)this.getConfiguredProperty("ehCacheTimeToLiveSeconds");
        }
        return Integer.parseInt(StringUtils.trimToEmpty((String)timeToLive));
    }

    protected boolean handleIsEhCacheOverflowToDisk() {
        String eternal = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_EHCACHE_OVERFLOW_TO_DISK);
        if (eternal == null) {
            eternal = (String)this.getConfiguredProperty("ehCacheOverflowToDisk");
        }
        return Boolean.valueOf(StringUtils.trimToEmpty((String)eternal));
    }

    protected boolean handleIsHibernateCacheDistributed() {
        String distributed = (String)this.getConfiguredProperty("hibernateEnableDistributedCache");
        boolean distributedCachingEnabled = Boolean.valueOf(StringUtils.trimToEmpty((String)distributed));
        if (distributedCachingEnabled) {
            String entityCacheDistributed = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ENTITYCACHE_DISTRIBUTED);
            return Boolean.valueOf(StringUtils.trimToEmpty((String)entityCacheDistributed));
        }
        return false;
    }

    protected boolean handleIsTableRequired() {
        return !this.isHibernateInheritanceClass() || this.isHibernateInheritanceClass() && this.getGeneralization() == null;
    }

    protected String handleGetMappingClassName() {
        String mappingClassName = "class";
        HibernateEntity superEntity = this.getSuperEntity();
        if (superEntity != null && !superEntity.isHibernateInheritanceInterface() && !superEntity.isHibernateInheritanceConcrete()) {
            mappingClassName = JOINED_SUBCLASS_MAPPING_NAME;
            if (this.isHibernateInheritanceClass()) {
                mappingClassName = "subclass";
            } else if (this.isHibernateInheritanceUnionSubClass()) {
                mappingClassName = "union-subclass";
            }
        }
        return mappingClassName;
    }

    private HibernateEntity getSuperEntity() {
        HibernateEntity superEntity = null;
        if (this.getGeneralization() != null && this.getGeneralization() instanceof HibernateEntity) {
            superEntity = (HibernateEntity)this.getGeneralization();
        }
        return superEntity;
    }

    protected String handleGetSubclassKeyColumn() {
        String column = null;
        HibernateEntity superEntity = this.getSuperEntity();
        if (superEntity != null && superEntity.isHibernateInheritanceSubclass()) {
            column = ((EntityAttribute)this.getIdentifiers().iterator().next()).getColumnName();
        }
        return column;
    }

    protected boolean handleIsRequiresMapping() {
        HibernateEntity superEntity = this.getSuperEntity();
        return HibernateUtils.mapSubclassesInSeparateFile((String)this.getConfiguredProperty("hibernateMappingStrategy")) || this.isRoot() && (!this.isHibernateInheritanceInterface() || this.getSpecializations().isEmpty() || superEntity != null && superEntity.isHibernateInheritanceInterface());
    }

    private boolean isRoot() {
        HibernateEntity superEntity = this.getSuperEntity();
        boolean abstractConcreteEntity = (this.isHibernateInheritanceConcrete() || this.isHibernateInheritanceInterface()) && this.isAbstract();
        return (this.getSuperEntity() == null || superEntity.isHibernateInheritanceInterface() || superEntity.isHibernateInheritanceConcrete()) && !abstractConcreteEntity;
    }

    protected boolean handleIsRequiresSpecializationMapping() {
        return !HibernateUtils.mapSubclassesInSeparateFile((String)this.getConfiguredProperty("hibernateMappingStrategy")) && this.isRoot() && (this.isHibernateInheritanceSubclass() || this.isHibernateInheritanceClass() || this.isHibernateInheritanceUnionSubClass());
    }

    protected boolean handleIsDynamicInsert() {
        String dynamicInsert = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ENTITY_DYNAMIC_INSERT);
        if (dynamicInsert == null) {
            dynamicInsert = (String)this.getConfiguredProperty("hibernateEntityDynamicInsert");
        }
        return Boolean.valueOf(dynamicInsert);
    }

    protected boolean handleIsDynamicUpdate() {
        String dynamicUpdate = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_ENTITY_DYNAMIC_UPDATE);
        if (dynamicUpdate == null) {
            dynamicUpdate = (String)this.getConfiguredProperty("hibernateEntityDynamicUpdate");
        }
        return Boolean.valueOf(dynamicUpdate);
    }

    protected boolean handleIsMappingRequiresSuperProperties() {
        return this.isHibernateInheritanceInterface() || this.isHibernateInheritanceConcrete() && this.isAbstract();
    }

    protected String handleGetHibernateVersionProperty() {
        String version = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_VERSION_PROPERTY);
        if (version == null) {
            version = (String)this.getConfiguredProperty("versionProperty");
        }
        return version;
    }

    protected String handleGetHibernateVersionPropertySqlName() {
        return EntityMetafacadeUtils.toSqlName((String)this.getHibernateVersionProperty(), (Object)this.getConfiguredProperty("sqlNameSeparator"));
    }

    protected int handleGetVersion() {
        return Integer.parseInt((String)this.getConfiguredProperty("hibernateVersion"));
    }

    private boolean isXmlPersistenceActive() {
        return HibernateUtils.isXmlPersistenceActive((String)this.getConfiguredProperty("hibernateVersion"), (String)this.getConfiguredProperty("hibernateXMLPersistence"));
    }

    protected String handleGetXmlTagName() {
        String tagName = null;
        if (this.isXmlPersistenceActive() && (tagName = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_XML_TAG_NAME)) == null) {
            tagName = this.getName();
        }
        return StringUtils.isBlank(tagName) ? null : tagName;
    }

    protected String handleGetHibernateDiscriminatorValue() {
        String value = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_ENTITY_DISCRIMINATOR_VALUE);
        if (value == null) {
            value = this.getEntityImplementationName();
        }
        return value;
    }

    protected String handleGetSequenceName() {
        short maxLength;
        String sequenceName = this.getTableName();
        String sequenceSuffix = this.getSequenceSuffix();
        short s = maxLength = this.getMaxSqlNameLength() != null ? (short)(this.getMaxSqlNameLength() - this.getSequenceSuffix().length()) : (short)0;
        if (maxLength > 0) {
            sequenceName = EntityMetafacadeUtils.ensureMaximumNameLength((String)sequenceName, (Short)new Short(maxLength)) + sequenceSuffix;
        }
        return sequenceName;
    }

    private String getSequenceSuffix() {
        return ObjectUtils.toString((Object)this.getConfiguredProperty(SEQUENCE_IDENTIFIER_SUFFIX));
    }

    protected String handleGetComments() {
        return HibernateUtils.convertDocumentationIntoComments(this.getDocumentation(""));
    }

    static {
        inheritanceStrategies.add("class");
        inheritanceStrategies.add("subclass");
        inheritanceStrategies.add(INHERITANCE_STRATEGY_CONCRETE);
        inheritanceStrategies.add(INHERITANCE_STRATEGY_INTERFACE);
        inheritanceStrategies.add("union-subclass");
    }
}

