/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.syntax;

import org.andromda.core.common.ExceptionUtils;
import org.andromda.translation.ocl.syntax.OperationDeclaration;
import org.andromda.translation.ocl.syntax.VariableDeclaration;
import org.apache.commons.lang.StringUtils;

public class OperationDeclarationImpl
implements OperationDeclaration {
    private String name;
    private String returnType;
    private VariableDeclaration[] arguments = new VariableDeclaration[0];

    public OperationDeclarationImpl(String name, String returnType, VariableDeclaration[] arguments) {
        ExceptionUtils.checkEmpty((String)"name", (String)name);
        this.name = StringUtils.trimToEmpty((String)name);
        this.returnType = StringUtils.trimToEmpty((String)returnType);
        this.arguments = arguments;
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public VariableDeclaration[] getArguments() {
        return this.arguments;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer(this.getName());
        toString.append("(");
        if (this.getArguments().length > 0) {
            toString.append(StringUtils.join((Object[])this.getArguments(), (char)','));
        }
        toString.append(")");
        if (StringUtils.isNotEmpty((String)this.getReturnType())) {
            toString.append("::");
            toString.append(this.getReturnType());
        }
        return toString.toString();
    }
}

