/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.utils.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.utils.beans.SortCriteria;
import org.andromda.utils.beans.comparators.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;

public class BeanSorter {
    public static List sort(Collection beans, String sortBy, SortCriteria.Ordering ordering) {
        return BeanSorter.sort(beans, new SortCriteria[]{new SortCriteria(sortBy, ordering)});
    }

    public static List sort(Collection beans, String sortBy, boolean nullsFirst) {
        return BeanSorter.sort(beans, new SortCriteria[]{new SortCriteria(sortBy, nullsFirst)});
    }

    public static List sort(Collection beans, String sortBy, SortCriteria.Ordering ordering, boolean nullsFirst) {
        return BeanSorter.sort(beans, new SortCriteria[]{new SortCriteria(sortBy, ordering, nullsFirst)});
    }

    public static List sort(Collection beans, SortCriteria[] sortBy) {
        ExceptionUtils.checkNull((String)"beans", (Object)beans);
        ExceptionUtils.checkNull((String)"sortBy", (Object)sortBy);
        if (sortBy.length == 0) {
            throw new IllegalArgumentException("sortBy must contain at least one value by which to sort");
        }
        ArrayList sorted = null;
        sorted = !(beans instanceof List) ? new ArrayList(beans) : (ArrayList)beans;
        int sortByNum = sortBy.length;
        ComparatorChain chain = new ComparatorChain();
        for (int ctr = 0; ctr < sortByNum; ++ctr) {
            SortCriteria orderBy = sortBy[ctr];
            chain.addComparator((Comparator)new BeanComparator(orderBy));
        }
        Collections.sort(sorted, chain);
        return sorted;
    }
}

