/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.table;

import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import java.awt.event.ActionEvent;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoveToPreviousEditableCellAction<M extends AbstractTuttiTableModel>
extends AbstractSelectTableAction<M> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MoveToPreviousEditableCellAction.class);

    public static <M extends AbstractTuttiTableModel> MoveToPreviousEditableCellAction<M> newAction(M model, JTable table) {
        return new MoveToPreviousEditableCellAction<M>(model, table);
    }

    protected MoveToPreviousEditableCellAction(M model, JTable table) {
        super(model, table);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int currentRow = this.getSelectedRow();
        int currentColumn = this.getSelectedColumn();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Move to previous editable cell, " + this.getCellCoordinate(currentRow, currentColumn)));
        }
        int columnCount = this.getColumnCount();
        while (currentRow > 0 || currentColumn > 0) {
            if (--currentColumn < 0) {
                currentColumn = columnCount - 1;
                --currentRow;
            }
            if (this.isCellEditable(currentRow, currentColumn)) {
                this.doSelectCell(currentRow, currentColumn);
                break;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Cell not editable at " + this.getCellCoordinate(currentRow, currentColumn)));
        }
    }
}

