/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.multipost.TuttiMultiPostImportExportService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.nuiton.i18n.I18n;

public class ExportMultiPostAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected File file;
    protected FishingOperation currentOperation;
    protected TuttiMultiPostImportExportService multiPostImportExportService = this.getContext().getMultiPostImportExportService();

    public ExportMultiPostAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            EditCatchesUI catchesUI = ((SpeciesBatchUI)this.getUI()).getParentContainer(EditCatchesUI.class);
            this.currentOperation = catchesUI.getModel().getFishingOperation();
            this.file = TuttiUIUtil.saveFile(this.decorate(this.currentOperation, "fileNameCompatible") + ".zip", this.getContext().getMainUI(), I18n._((String)"tutti.editSpeciesBatch.action.exportMultiPost.destinationFile.title", (Object[])new Object[0]), I18n._((String)"tutti.editSpeciesBatch.action.exportMultiPost.destinationFile.button", (Object[])new Object[0]), "^.*\\.zip", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
            doAction = this.file == null ? false : ((SpeciesBatchUIHandler)this.getHandler()).askOverwriteFile(this.file);
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        this.currentOperation = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        this.multiPostImportExportService.exportSpecies(this.file, this.currentOperation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.editSpeciesBatch.action.exportMultiPost.success", (Object[])new Object[]{this.file}));
    }
}

