/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.mapping;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.mapping.Mappings;
import org.andromda.core.mapping.MappingsException;

public class Mapping {
    private final Collection froms = new LinkedHashSet();
    private final List paths = new ArrayList();
    private String to;
    private Mappings mappings;

    public void addFrom(String from) {
        ExceptionUtils.checkNull("from", from);
        this.froms.add(from);
    }

    public Collection getFroms() {
        return this.froms;
    }

    public String getTo() {
        if (!this.paths.isEmpty()) {
            try {
                StringBuffer pathsContents = new StringBuffer();
                Iterator iterator = this.paths.iterator();
                while (iterator.hasNext()) {
                    pathsContents.append(ResourceUtils.getContents(new FileReader(this.mappings.getCompletePath((String)iterator.next()))));
                }
                this.to = pathsContents.toString();
            }
            catch (FileNotFoundException exception) {
                throw new MappingsException(exception);
            }
        }
        return this.to;
    }

    public void addPath(String path) {
        this.paths.add(path);
    }

    public void setTo(String to) {
        this.to = to;
    }

    final void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(512);
        Iterator fromIterator = this.froms.iterator();
        while (fromIterator.hasNext()) {
            String from = (String)fromIterator.next();
            buffer.append(from);
            if (!fromIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(" --> ").append(this.to);
        return buffer.toString();
    }
}

