/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonImpl;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.operation.Operation;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.vessel.feature.person.VesselPersonFeatures;
import fr.ifremer.adagio.core.dao.referential.VesselPersonRole;
import fr.ifremer.adagio.core.dao.referential.VesselPersonRoleImpl;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component(value="vesselPersonFeaturesPersistenceHelper")
public class VesselPersonFeaturesPersistenceHelper
extends AbstractPersistenceService {
    public VesselPersonRole getScientificCruiseManagerRole() {
        return (VesselPersonRole)this.load(VesselPersonRoleImpl.class, this.enumeration.VESSEL_PERSON_ROLE_ID_SCIENTIFIC_CRUISE_MANAGER);
    }

    public VesselPersonRole getSortRoomManagerRole() {
        return (VesselPersonRole)this.load(VesselPersonRoleImpl.class, this.enumeration.VESSEL_PERSON_ROLE_ID_SORT_ROOM_MANAGER);
    }

    public VesselPersonRole getRecorderPersonRole() {
        return (VesselPersonRole)this.load(VesselPersonRoleImpl.class, this.enumeration.VESSEL_PERSON_ROLE_ID_RECORDER_PERSON);
    }

    public void fillVesselPersonFeatures(VesselPersonFeatures vesselPersonFeatures, FishingTrip fishingTrip, PersonImpl person, VesselPersonRole role) {
        vesselPersonFeatures.setFishingTrip(fishingTrip);
        vesselPersonFeatures.setPerson((Person)person);
        vesselPersonFeatures.getVesselPersonRoles().add(role);
        vesselPersonFeatures.setStartDate(fishingTrip.getDepartureDateTime());
        vesselPersonFeatures.setEndDate(fishingTrip.getReturnDateTime());
        vesselPersonFeatures.setVessel(fishingTrip.getVessel());
        vesselPersonFeatures.setProgram(fishingTrip.getProgram());
        vesselPersonFeatures.setCreationDate(fishingTrip.getCreationDate());
        vesselPersonFeatures.setQualityFlag(fishingTrip.getQualityFlag());
        vesselPersonFeatures.setRankOrder(Short.valueOf((short)1));
    }

    public void fillVesselPersonFeatures(VesselPersonFeatures vesselPersonFeatures, FishingOperation fishingOperation, PersonImpl person, VesselPersonRole role) {
        vesselPersonFeatures.setOperation((Operation)fishingOperation);
        vesselPersonFeatures.setPerson((Person)person);
        vesselPersonFeatures.getVesselPersonRoles().add(role);
        vesselPersonFeatures.setStartDate(fishingOperation.getStartDateTime());
        vesselPersonFeatures.setEndDate(fishingOperation.getEndDateTime());
        vesselPersonFeatures.setVessel(fishingOperation.getVessel());
        vesselPersonFeatures.setProgram(fishingOperation.getFishingTrip().getProgram());
        vesselPersonFeatures.setCreationDate(new Date());
        vesselPersonFeatures.setQualityFlag(fishingOperation.getQualityFlag());
        vesselPersonFeatures.setRankOrder(Short.valueOf((short)1));
    }
}

