/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.util.List;
import java.util.Map;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;

public class SpeciesFrequencyTableModel
extends AbstractTuttiTableModel<SpeciesFrequencyRowModel> {
    private static final long serialVersionUID = 1L;
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> LENGTH_STEP = ColumnIdentifier.newId("lengthStep", I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> NUMBER = ColumnIdentifier.newId("number", I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesFrequencyRowModel> WEIGHT = ColumnIdentifier.newId("weight", I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesFrequencies.table.header.weight", (Object[])new Object[0]));
    private final SpeciesFrequencyUIModel uiModel;
    private final Map<Float, SpeciesFrequencyRowModel> rowCache;

    public SpeciesFrequencyTableModel(TableColumnModelExt columnModel, SpeciesFrequencyUIModel uiModel) {
        super(columnModel, true, true);
        this.uiModel = uiModel;
        this.rowCache = Maps.newTreeMap();
        this.setNoneEditableCols(new ColumnIdentifier[0]);
    }

    @Override
    public SpeciesFrequencyRowModel createNewRow() {
        SpeciesFrequencyRowModel rowModel;
        Float lengthStep;
        Float defaultStep = null;
        int rowCount = this.getRowCount();
        if (rowCount > 0 && (lengthStep = (rowModel = (SpeciesFrequencyRowModel)this.getEntry(rowCount - 1)).getLengthStep()) != null) {
            defaultStep = Float.valueOf(this.uiModel.getLengthStep(lengthStep.floatValue() + this.uiModel.getStep()));
        }
        SpeciesFrequencyRowModel result = new SpeciesFrequencyRowModel();
        result.setLengthStep(defaultStep);
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<SpeciesFrequencyRowModel> propertyName, SpeciesFrequencyRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
    }

    public Map<Float, SpeciesFrequencyRowModel> getRowCache() {
        return this.rowCache;
    }

    @Override
    protected void onRowsChanged(List<SpeciesFrequencyRowModel> data) {
        this.rowCache.clear();
        for (SpeciesFrequencyRowModel row : data) {
            Float lengthStep = row.getLengthStep();
            if (lengthStep == null) continue;
            this.rowCache.put(lengthStep, row);
        }
    }

    @Override
    protected void onRowAdded(int rowIndex, SpeciesFrequencyRowModel newValue) {
        Preconditions.checkNotNull((Object)newValue, (Object)"can't add a null row");
        newValue.setLengthStepCaracteristic(this.uiModel.getLengthStepCaracteristic());
        Float lengthStep = newValue.getLengthStep();
        Preconditions.checkNotNull((Object)lengthStep, (Object)"can't add a null lengthStep row");
        float roundLenghtValue = this.uiModel.getLengthStep(lengthStep.floatValue());
        if (!this.rowCache.containsKey(Float.valueOf(roundLenghtValue))) {
            this.rowCache.put(Float.valueOf(roundLenghtValue), newValue);
        }
    }
}

