/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class CloseDbAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(CloseDbAction.class);
    String jdbcUrl;

    public CloseDbAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.MANAGE_DB);
    }

    @Override
    protected void doAction() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Will close db...");
        }
        this.jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();
        this.getContext().getPersistenceService().clearAllCaches();
        this.getContext().setDbLoaded(false);
        ((MainUIHandler)this.getHandler()).reloadPersistenceService();
        this.getContext().clearDbContext();
        TuttiIOUtil.deleteDirectory(this.getConfig().getServiceConfig().getPersistenceConfig().getCacheDirectory(), "Could not delete cache directory");
    }

    @Override
    public void postSuccessAction() {
        this.sendMessage(I18n._((String)"tutti.flash.info.db.closed", (Object[])new Object[]{this.jdbcUrl}));
        ((MainUI)this.getUI()).getHandler().changeTitle();
    }
}

