/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SexEnum;
import fr.ifremer.tutti.persistence.entities.data.SizeEnum;
import fr.ifremer.tutti.persistence.entities.data.SortedUnsortedEnum;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ReflectionUtils;

public class TuttiEnumerationFile {
    @Value(value="${GearClassificationId.SCIENTIFIC_CRUISE}")
    public final Integer GEAR_CLASSIFICIATION_ID_SCIENTIFIC = null;
    @Value(value="${GearClassificationId.FAO}")
    public final Integer GEAR_CLASSIFICIATION_ID_FISHING = null;
    @Value(value="${LocationClassificationId.TERRITORIAL}")
    public final Integer LOCATION_CLASSIFICATION_ID_TERRITORIAL = null;
    @Value(value="${LocationClassificationId.SECTOR}")
    public final Integer LOCATION_CLASSIFICATION_ID_SECTOR = null;
    @Value(value="${LocationLabel.FRANCE}")
    public final String LOCATION_LABEL_DEFAULT_COUNTRY;
    @Value(value="${LocationLevelId.PAYS_ISO3}")
    public final Integer LOCATION_LEVEL_ID_COUNTRY = null;
    @Value(value="${LocationLevelId.PORT}")
    public final Integer LOCATION_LEVEL_ID_HARBOUR = null;
    @Value(value="${LocationLevelId.LOCALITE}")
    public final Integer LOCATION_LEVEL_ID_LOCALITE = null;
    @Value(value="${LocationLevelId.PROGRAM}")
    public final Integer LOCATION_LEVEL_ID_PROGRAM = null;
    @Value(value="${LocationLevelId.STRATA}")
    public final Integer LOCATION_LEVEL_ID_STRATA = null;
    @Value(value="${LocationLevelId.SUB_STRATA}")
    public final Integer LOCATION_LEVEL_ID_SUB_STRATA = null;
    @Value(value="${ParameterCode.AGE}")
    public final String PARAMETER_CODE_AGE;
    @Value(value="${ParameterCode.WEIGHT}")
    public final String PARAMETER_CODE_WEIGHT;
    @Value(value="${PmfmId.SIZE_CATEGORY}")
    public final Integer PMFM_ID_SIZE_CATEGORY = null;
    @Value(value="${PmfmId.SEX}")
    public final Integer PMFM_ID_SEX = null;
    @Value(value="${PmfmId.SORTED_UNSORTED}")
    public final Integer PMFM_ID_SORTED_UNSORTED = null;
    @Value(value="${PmfmId.MATURITY}")
    public final Integer PMFM_ID_MATURITY = null;
    @Value(value="${PmfmId.MARINE_LITTER_TYPE}")
    public final Integer PMFM_ID_MARINE_LITTER_TYPE = null;
    @Value(value="${PmfmId.MARINE_LITTER_SIZE_CATEGORY}")
    public final Integer PMFM_ID_MARINE_LITTER_SIZE_CATEGORY = null;
    @Value(value="${PmfmId.SCIENTIFIC_CRUISE_SORTING_TYPE}")
    public final Integer PMFM_ID_SORTING_TYPE = null;
    @Value(value="${UnitId.NONE}")
    public final Integer UNIT_ID_NONE = null;
    @Value(value="${UserProfilId.OBSERVER}")
    public final Integer USER_PROFIL_ID_OBSERVER = null;
    @Value(value="${UserProfilId.PROJECT_MEMBER}")
    public final Integer USER_PROFIL_ID_PROJECT_MEMBER = null;
    @Value(value="${UserProfilId.USER}")
    public final Integer USER_PROFIL_ID_USER = null;
    @Value(value="${VesselTypeId.SCIENTIFIC_RESEARCH_VESSEL}")
    public final Integer VESSEL_TYPE_ID_SCIENTIFIC = null;
    @Value(value="${VesselTypeId.FISHING_VESSEL}")
    public final Integer VESSEL_TYPE_ID_FISHING = null;
    @Value(value="${LocationLevelId.RECTANGLE_STATISTIQUE_MED}")
    public final Integer RECTANGLE_STATISTIQUE_MED = null;
    @Value(value="${LocationLevelId.RECTANGLE_STATISTIQUE}")
    public final Integer RECTANGLE_STATISTIQUE = null;
    @Value(value="${QualitativeValueId.SORTED_VRAC}")
    public final Integer QUALITATIVE_VRAC_ID = null;
    @Value(value="${QualitativeValueId.SORTED_HORS_VRAC}")
    public final Integer QUALITATIVE_HORS_VRAC_ID = null;
    @Value(value="${QualitativeValueId.UNSORTED}")
    public final Integer QUALITATIVE_UNSORTED_ID = null;
    @Value(value="${QualitativeValueId.SEX_MALE}")
    public final Integer QUALITATIVE_SEX_MALE_ID = null;
    @Value(value="${QualitativeValueId.SEX_FEMALE}")
    public final Integer QUALITATIVE_SEX_FEMALE_ID = null;
    @Value(value="${QualitativeValueId.SIZE_SMALL}")
    public final Integer QUALITATIVE_SIZE_SMALL_ID = null;
    @Value(value="${QualitativeValueId.SIZE_MEDIUM}")
    public final Integer QUALITATIVE_SIZE_MEDIUM_ID = null;
    @Value(value="${QualitativeValueId.SIZE_BIG}")
    public final Integer QUALITATIVE_SIZE_BIG_ID = null;
    @Value(value="${QualitativeValueId.SORTING_TYPE_SPECIES}")
    public final Integer QUALITATIVE_ID_SORTING_TYPE_SPECIES = null;
    @Value(value="${QualitativeValueId.SORTING_TYPE_BENTHOS}")
    public final Integer QUALITATIVE_ID_SORTING_TYPE_BENTHOS = null;
    @Value(value="${StatusCode.ENABLE}")
    public final String STATUS_VALID_CODE;
    @Value(value="${StatusCode.TEMPORARY}")
    public final String STATUS_TEMPORARY_CODE;
    @Value(value="${PersonId.UNKNOWN_RECORDER_PERSON}")
    public final Integer PERSON_ID_UNKNOWN_RECORDER_PERSON = null;
    @Value(value="${QualityFlagCode.NOTQUALIFIED}")
    public final String QUALITY_FLAG_CODE_NOT_QUALIFIED;
    @Value(value="${QualityFlagCode.DOUBTFUL}")
    public final String QUALITY_FLAG_CODE_DOUBTFUL;
    @Value(value="${PmfmId.STATION_NUMBER}")
    public final Integer PMFM_ID_STATION_NUMBER = null;
    @Value(value="${PmfmId.TRAWL_DISTANCE}")
    public final Integer PMFM_ID_TRAWL_DISTANCE = null;
    @Value(value="${PmfmId.RECTILINEAR_OPERATION}")
    public final Integer PMFM_ID_RECTILINEAR_OPERATION = null;
    @Value(value="${QualitativeValueId.RECTILINEAR_OPERATION_YES}")
    public final Integer QUALITATIVE_RECTILINEAR_OPERATION_YES = null;
    @Value(value="${QualitativeValueId.RECTILINEAR_OPERATION_NO}")
    public final Integer QUALITATIVE_RECTILINEAR_OPERATION_NO = null;
    @Value(value="${PmfmId.HAUL_VALID}")
    public final Integer PMFM_ID_HAUL_VALID = null;
    @Value(value="${QualitativeValueId.HAUL_VALID_YES}")
    public final Integer QUALITATIVE_HAUL_VALID_YES = null;
    @Value(value="${QualitativeValueId.HAUL_VALID_NO}")
    public final Integer QUALITATIVE_HAUL_VALID_NO = null;
    @Value(value="${PmfmId.MULTIRIG_NUMBER}")
    public final Integer PMFM_ID_MULTIRIG_NUMBER = null;
    @Value(value="${PmfmId.MULTIRIG_AGGREGATION}")
    public final Integer PMFM_ID_MULTIRIG_AGGREGATION = null;
    @Value(value="${PmfmId.WEIGHT_MEASURED}")
    public final Integer PMFM_ID_WEIGHT_MEASURED = null;
    @Value(value="${DepartmentId.UNKNOWN_RECORDER_DEPARTMENT}")
    public final Integer DEPARTMENT_ID_UNKNOWN_RECORDER_DEPARTMENT = null;
    @Value(value="${PmfmId.AGE}")
    public final Integer PMFM_ID_AGE = null;
    @Value(value="${PmfmId.SURVEY_PART}")
    public final Integer PMFM_ID_SURVEY_PART = null;
    @Value(value="${PmfmId.MEASUREMENT_FILE}")
    public final Integer PMFM_ID_MEASUREMENT_FILE = null;
    @Value(value="${ProgramCode.SCIENTIFIC_CRUISE_PREFIX}")
    public final String PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX;
    @Value(value="${TaxonGroupTypeCode.COMMERCIAL_SPECIES}")
    public final String TAXON_GROUP_TYPE_ID_COMMERCIAL_SPECIES;
    @Value(value="${ReferenceTaxonId.LIFE}")
    public final Integer REFERENCE_TAXON_ID_LIFE = null;
    @Value(value="${ReferenceTaxonId.INERT}")
    public final Integer REFERENCE_TAXON_ID_INERT = null;
    @Value(value="${ObjectTypeCode.SCIENTIFIC_CRUISE}")
    public final String OBJECT_TYPE_SCIENTIFIC_CRUISE;
    @Value(value="${ObjectTypeCode.CATCH_BATCH}")
    public final String OBJECT_TYPE_CATCH_BATCH;
    @Value(value="${ObjectTypeCode.OPERATION}")
    public final String OBJECT_TYPE_OPERATION;
    @Value(value="${ObjectTypeCode.SAMPLE}")
    public final String OBJECT_TYPE_SAMPLE;
    protected Set<Integer> propertedPmfmIds;
    protected Map<Integer, SampleCategoryEnum> pmfmIdToSampleCategory;

    public TuttiEnumerationFile() {
        this.LOCATION_LABEL_DEFAULT_COUNTRY = null;
        this.PARAMETER_CODE_AGE = null;
        this.PARAMETER_CODE_WEIGHT = null;
        this.STATUS_VALID_CODE = null;
        this.STATUS_TEMPORARY_CODE = null;
        this.QUALITY_FLAG_CODE_NOT_QUALIFIED = null;
        this.QUALITY_FLAG_CODE_DOUBTFUL = null;
        this.PROGRAM_CODE_SCIENTIFIC_CRUISE_PREFIX = null;
        this.TAXON_GROUP_TYPE_ID_COMMERCIAL_SPECIES = null;
        this.OBJECT_TYPE_SCIENTIFIC_CRUISE = null;
        this.OBJECT_TYPE_CATCH_BATCH = null;
        this.OBJECT_TYPE_OPERATION = null;
        this.OBJECT_TYPE_SAMPLE = null;
    }

    public void init() {
        TreeMap annotatedFieldValues = Maps.newTreeMap();
        Field[] declaredFields = this.getClass().getDeclaredFields();
        for (Field declaredField : declaredFields) {
            Value annotation = declaredField.getAnnotation(Value.class);
            if (annotation == null) continue;
            Object fieldValue = ReflectionUtils.getField((Field)declaredField, (Object)this);
            String fieldName = declaredField.getName();
            Preconditions.checkNotNull((Object)fieldValue, (Object)(annotation.value() + " constant not found (field " + fieldName + ")"));
            annotatedFieldValues.put(fieldName, fieldValue);
        }
        this.initEnum(SortedUnsortedEnum.class, annotatedFieldValues);
        this.initEnum(SexEnum.class, annotatedFieldValues);
        this.initEnum(SizeEnum.class, annotatedFieldValues);
        this.initEnum(AttachementObjectTypeEnum.class, annotatedFieldValues);
        this.initEnum(SampleCategoryEnum.class, annotatedFieldValues);
        this.propertedPmfmIds = Sets.newHashSet((Object[])new Integer[]{this.PMFM_ID_MULTIRIG_AGGREGATION, this.PMFM_ID_MULTIRIG_NUMBER, this.PMFM_ID_STATION_NUMBER, this.PMFM_ID_RECTILINEAR_OPERATION, this.PMFM_ID_HAUL_VALID, this.PMFM_ID_TRAWL_DISTANCE, this.PMFM_ID_SURVEY_PART, this.PMFM_ID_MEASUREMENT_FILE, this.PMFM_ID_SORTED_UNSORTED, this.PMFM_ID_SIZE_CATEGORY, this.PMFM_ID_MATURITY, this.PMFM_ID_SEX, this.PMFM_ID_AGE});
        this.pmfmIdToSampleCategory = Maps.newTreeMap();
        for (SampleCategoryEnum type : SampleCategoryEnum.values()) {
            this.pmfmIdToSampleCategory.put(type.getFieldValue(), type);
        }
    }

    public boolean isProtectedCaracteristic(Integer pmfmId) {
        return this.propertedPmfmIds.contains(pmfmId);
    }

    public SampleCategoryEnum getSampleCategoryByPmfmId(Integer pmfmId) {
        SampleCategoryEnum result = this.pmfmIdToSampleCategory.get(pmfmId);
        return result;
    }

    protected <O, E extends Enum<E>> void initEnum(Class<E> enumType, Map<String, Object> annotatedFieldValues) {
        for (Enum e : (Enum[])enumType.getEnumConstants()) {
            if (((TuttiEnumerable)((Object)e)).isInit()) continue;
            String fieldName = ((TuttiEnumerable)((Object)e)).getFieldName();
            Object field = annotatedFieldValues.get(fieldName);
            Preconditions.checkNotNull((Object)field, (Object)("Could not find field " + fieldName + ")"));
            ((TuttiEnumerable)((Object)e)).setFieldValue(field);
            ((TuttiEnumerable)((Object)e)).setInit(true);
        }
    }

    public static interface TuttiEnumerable<O> {
        public String getFieldName();

        public O getFieldValue();

        public void setFieldValue(Object var1);

        public boolean isInit();

        public void setInit(boolean var1);
    }
}

