/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.BenthosBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.batch.BatchPersistenceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service(value="benthosBatchPersistenceService")
public class BenthosBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements BenthosBatchPersistenceService {
    private static final Log log = LogFactory.getLog(BenthosBatchPersistenceServiceImpl.class);
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService referentialService;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;

    @Override
    public BatchContainer<SpeciesBatch> getRootBenthosBatch(String fishingOperationId) {
        SpeciesBatch target;
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(Integer.valueOf(fishingOperationId));
        Preconditions.checkNotNull((Object)catchBatchId);
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        Preconditions.checkNotNull((Object)catchBatch);
        Collection catchBatchChils = catchBatch.getChildBatchs();
        SortingBatch vracSpeciesBatch = this.catchBatchDao.getSortingBatch(catchBatchChils, new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, "pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS});
        BatchContainer<SpeciesBatch> result = new BatchContainer<SpeciesBatch>();
        result.setId(vracSpeciesBatch.getId());
        for (Batch batch1 : vracSpeciesBatch.getChildBatchs()) {
            SortingBatch source = (SortingBatch)batch1;
            if (source.getReferenceTaxon() == null || this.enumeration.REFERENCE_TAXON_ID_LIFE.equals(source.getReferenceTaxon().getId()) || this.enumeration.REFERENCE_TAXON_ID_INERT.equals(source.getReferenceTaxon().getId())) continue;
            target = new SpeciesBatch();
            this.batchHelper.entityToSpeciesBatch(source, target);
            result.addChildren(target);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Loaded CatchBatch Vrac > Benthos > " + target.getSpecies().getReferenceTaxonId() + " : " + target.getId()));
        }
        SortingBatch horsVracSpeciesBatch = this.catchBatchDao.getSortingBatch(catchBatchChils, new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, "pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS});
        if (horsVracSpeciesBatch != null) {
            for (Batch batch : horsVracSpeciesBatch.getChildBatchs()) {
                target = new SpeciesBatch();
                this.batchHelper.entityToSpeciesBatch((SortingBatch)batch, target);
                result.addChildren(target);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Loaded CatchBatch Hors Vrac > Benthos > " + target.getSpecies().getReferenceTaxonId() + " : " + target.getId()));
            }
        }
        return result;
    }

    @Override
    public SpeciesBatch createBenthosBatch(SpeciesBatch bean, String parentBatchId) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getSpecies().getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(bean.getFishingOperation().getIdAsInt());
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        SortingBatch batch = SortingBatch.Factory.newInstance();
        this.benthosBatchToEntity(bean, batch, parentBatchId, catchBatch);
        batch = this.catchBatchDao.createSortingBatch(batch, catchBatch);
        bean.setId(batch.getId());
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public SpeciesBatch saveBenthosBatch(SpeciesBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(bean.getIdAsInt());
        Preconditions.checkNotNull((Object)catchBatchId);
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        Preconditions.checkNotNull((Object)catchBatch);
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        SortingBatch batch = this.catchBatchDao.getSortingBatchById(catchBatch, bean.getIdAsInt());
        String parentBatchId = null;
        if (bean.getParentBatch() != null) {
            parentBatchId = bean.getParentBatch().getId();
        }
        this.benthosBatchToEntity(bean, batch, parentBatchId, catchBatch);
        this.catchBatchDao.updateSortingBatch(batch, catchBatch);
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public void deleteBenthosBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        this.catchBatchDao.removeWithChildren(Integer.valueOf(id));
        this.getCurrentSession().flush();
    }

    @Override
    public void deleteBenthosSubBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        this.deleteBenthosBatch(id);
    }

    @Override
    public void changeBenthosBatchSpecies(String batchId, Species species) {
        Preconditions.checkNotNull((Object)batchId);
        Preconditions.checkNotNull((Object)species);
        Preconditions.checkNotNull((Object)species.getReferenceTaxonId());
        this.catchBatchDao.setSortingBatchReferenceTaxon(batchId, species.getReferenceTaxonId());
    }

    @Override
    public List<SpeciesBatchFrequency> getAllBenthosBatchFrequency(String benthosBatchId) {
        ArrayList results = Lists.newArrayList();
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(Integer.valueOf(benthosBatchId));
        if (catchBatchId == null) {
            return results;
        }
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        SortingBatch sortingBatch = this.catchBatchDao.getSortingBatchById(catchBatch, Integer.valueOf(benthosBatchId));
        for (Batch batch : sortingBatch.getChildBatchs()) {
            SortingBatch source = (SortingBatch)batch;
            SpeciesBatchFrequency target = new SpeciesBatchFrequency();
            this.batchHelper.entityToSpeciesBatchFrequency(source, target);
            results.add(target);
        }
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<SpeciesBatchFrequency> saveBenthosBatchFrequency(String benthosBatchId, List<SpeciesBatchFrequency> frequencies) {
        Preconditions.checkNotNull((Object)benthosBatchId);
        Preconditions.checkNotNull(frequencies);
        String pmfmId = null;
        for (SpeciesBatchFrequency source : frequencies) {
            if (pmfmId == null) {
                pmfmId = source.getLengthStepCaracteristic().getId();
                continue;
            }
            if (pmfmId.equals(source.getLengthStepCaracteristic().getId())) continue;
            throw new DataIntegrityViolationException("Batch frequencies under one Speciesbatch must have all the same lengthStepCaracteristic");
        }
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        Integer sortingBatchId = Integer.valueOf(benthosBatchId);
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(sortingBatchId);
        CatchBatch catchBatch = this.catchBatchDao.loadFullTree(catchBatchId);
        if (catchBatch == null) {
            return frequencies;
        }
        SortingBatch parentBatch = this.catchBatchDao.getSortingBatchById(catchBatch, sortingBatchId);
        ArrayList notUpdatedChildIds = Lists.newArrayList();
        for (Batch batch : parentBatch.getChildBatchs()) {
            SortingBatch sortingBatch = (SortingBatch)batch;
            notUpdatedChildIds.add(sortingBatch.getId());
        }
        short rankOrder = 0;
        ArrayList batchsToUpdate = Lists.newArrayList();
        for (SpeciesBatchFrequency source : frequencies) {
            SortingBatch target;
            rankOrder = (short)(rankOrder + 1);
            if (source.getId() == null) {
                target = SortingBatch.Factory.newInstance();
                this.batchHelper.speciesBatchFrequencyToEntity(source, target, parentBatch, rankOrder);
                this.catchBatchDao.createSortingBatch(target, catchBatch);
                source.setId(target.getId());
                continue;
            }
            target = this.catchBatchDao.getSortingBatchById(catchBatch, source.getIdAsInt());
            this.batchHelper.speciesBatchFrequencyToEntity(source, target, parentBatch, rankOrder);
            batchsToUpdate.add(target);
            notUpdatedChildIds.remove(target.getId());
        }
        if (batchsToUpdate.size() > 0) {
            this.catchBatchDao.updateSortingBatch((List)batchsToUpdate, catchBatch);
        }
        if (notUpdatedChildIds.size() > 0) {
            for (Integer batchId : notUpdatedChildIds) {
                this.catchBatchDao.removeWithChildren(batchId, catchBatch);
            }
        }
        this.getCurrentSession().flush();
        return Collections.unmodifiableList(frequencies);
    }

    protected void benthosBatchToEntity(SpeciesBatch source, SortingBatch target, String parentBatchId, CatchBatch catchBatch) {
        this.batchHelper.speciesBatchToEntity(source, target, parentBatchId, catchBatch, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS);
    }
}

