/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.io.File;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(ImportProtocolAction.class);
    public static final JAXXContextEntryDef<TuttiProtocol> IMPORT_PROTOCOL_ENTRY = new JAXXContextEntryDef("importProtocol", TuttiProtocol.class);
    private File file;

    public ImportProtocolAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_PROTOCOL);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.selectCruise.title.choose.importFile", (Object[])new Object[0]), I18n._((String)"tutti.selectCruise.action.chooseProtocolFile", (Object[])new Object[0]), "^.+\\.tuttiProtocol$", I18n._((String)"tutti.common.file.protocol", (Object[])new Object[0]));
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol file: " + this.file));
        }
        TuttiProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        TuttiProtocol protocol = service.importProtocol(this.file);
        this.sendMessage("Protocole [" + protocol.getName() + "] lu depuis le fichier.");
        IMPORT_PROTOCOL_ENTRY.setContextValue((JAXXContext)this.getContext().getMainUI(), (Object)protocol);
        protocol.setId((String)null);
        this.getContext().setProtocolId(null);
        super.doAction();
    }
}

