/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.awt.Component;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.updater.ApplicationUpdater;
import org.nuiton.util.updater.ApplicationUpdaterCallback;
import org.nuiton.util.updater.DownloadMonitor;

public class UpdateApplicationAction
extends AbstractTuttiAction<TuttiUIContext, MainUI, MainUIHandler> {
    private static final Log log = LogFactory.getLog(UpdateApplicationAction.class);

    public UpdateApplicationAction(MainUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected void doAction() throws Exception {
        TuttiUIContext context = this.getContext();
        TuttiApplicationConfig config = context.getConfig();
        File current = config.getTuttiBasedir();
        if (current == null || !current.exists()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No application base directory defined, skip updates.");
            }
        } else {
            String url = config.getUpdateUrl();
            File dest = new File(config.getTuttiBasedir(), "NEW");
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Try to update jre, i18N, help or tutti (current application location: %s), using update url: %s", current, url));
            }
            ProgressionModel progressionModel = new ProgressionModel();
            context.getActionUI().getModel().setProgressionModel(progressionModel);
            progressionModel.setMessage("Recherche de mises \u00e0 jour de JRE / Tutti / I18N / Help");
            TuttiApplicationUpdaterCallBack callback = new TuttiApplicationUpdaterCallBack(this, progressionModel);
            callback.setTypes(TuttiApplicationUpdaterCallBack.UpdateType.JRE, TuttiApplicationUpdaterCallBack.UpdateType.I18N, TuttiApplicationUpdaterCallBack.UpdateType.TUTTI, TuttiApplicationUpdaterCallBack.UpdateType.HELP);
            ApplicationUpdater up = new ApplicationUpdater();
            up.setDownloadMonitor((DownloadMonitor)progressionModel);
            up.update(url, current, dest, false, (ApplicationUpdaterCallback)callback);
            if (callback.isApplicationUpdated()) {
                TuttiUIUtil.showSuccessMessage((Component)this.getUI(), "Red\u00e9marrage de Tutti n\u00e9cessaire...", "La mise \u00e0 jour n\u00e9cessite le r\u00e9d\u00e9marrage du Tutti.\nL'application va se fermer puis se r\u00e9ouvrir automatiquement.");
                callback.restart();
            } else {
                this.sendMessage("Aucune mise \u00e0 jour de l'application d\u00e9tect\u00e9e.");
            }
        }
    }
}

