/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.protocol;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.YamlWriter;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class TuttiProtocols {
    public static void toFile(TuttiProtocol protocol, File file) {
        String id = protocol.getId();
        BufferedWriter fileWriter = null;
        try {
            fileWriter = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            YamlWriter writer = new YamlWriter((Writer)fileWriter, TuttiProtocols.createConfig());
            writer.write((Object)protocol);
            writer.close();
            fileWriter.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not transform protocol " + id + " to file " + file, e);
        }
        finally {
            IOUtils.closeQuietly((Writer)fileWriter);
        }
    }

    public static TuttiProtocol fromFile(File file) {
        BufferedReader fileReader = null;
        try {
            fileReader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
            YamlReader reader = new YamlReader((Reader)fileReader, TuttiProtocols.createConfig());
            TuttiProtocol result = (TuttiProtocol)reader.read(TuttiProtocol.class);
            ((Reader)fileReader).close();
            TuttiProtocol tuttiProtocol = result;
            return tuttiProtocol;
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not import protocol from file " + file, e);
        }
        finally {
            IOUtils.closeQuietly((Reader)fileReader);
        }
    }

    protected static YamlConfig createConfig() {
        YamlConfig result = new YamlConfig();
        result.setClassTag(SpeciesProtocol.class.getSimpleName(), SpeciesProtocol.class);
        result.writeConfig.setAlwaysWriteClassname(false);
        result.writeConfig.setWriteRootTags(false);
        return result;
    }
}

