/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.persistence.hibernate.usertypes;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class HibernateStringClobType
implements UserType {
    private static final long serialVersionUID = 10000L;

    public int[] sqlTypes() {
        return new int[]{2005};
    }

    public Class<?> returnedClass() {
        return String.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        boolean equal = false;
        equal = x == null || y == null ? false : (!(x instanceof String) || !(y instanceof String) ? false : ((String)x).equals(y));
        return equal;
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, Object owner) throws HibernateException, SQLException {
        StringBuffer buffer = new StringBuffer();
        try {
            Reader inputStream = resultSet.getCharacterStream(names[0]);
            if (inputStream == null) {
                return null;
            }
            char[] buf = new char[1024];
            int read = -1;
            while ((read = inputStream.read(buf)) > 0) {
                buffer.append(new String(buf, 0, read));
            }
            inputStream.close();
        }
        catch (IOException exception) {
            throw new HibernateException("Unable to read from resultset", (Throwable)exception);
        }
        return buffer.toString();
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object data, int index) throws HibernateException, SQLException {
        if (data != null) {
            StringReader r = new StringReader((String)data);
            preparedStatement.setCharacterStream(index, (Reader)r, ((String)data).length());
        } else {
            preparedStatement.setNull(index, this.sqlTypes()[0]);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        String ret = null;
        value = value == null ? new String() : value;
        String in = (String)value;
        int len = in.length();
        char[] buf = new char[len];
        for (int i = 0; i < len; ++i) {
            buf[i] = in.charAt(i);
        }
        ret = new String(buf);
        return ret;
    }

    public boolean isMutable() {
        return false;
    }

    public Object replace(Object original, Object target, Object owner) {
        return this.deepCopy(original);
    }

    public Object assemble(Serializable cached, Object owner) {
        return this.deepCopy(cached);
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public int hashCode(Object x) {
        return x.hashCode();
    }
}

