/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.gear;

import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassification;
import fr.ifremer.adagio.core.dao.referential.gear.GearImpl;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

public abstract class Gear
implements Serializable {
    private static final long serialVersionUID = -8682748581802811410L;
    private Integer id;
    private String label;
    private String name;
    private String description;
    private Timestamp updateDate;
    private GearClassification gearClassification;
    private Collection<Gear> childGears = new HashSet<Gear>();
    private Gear parentGear;
    private Status status;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public GearClassification getGearClassification() {
        return this.gearClassification;
    }

    public void setGearClassification(GearClassification gearClassification) {
        this.gearClassification = gearClassification;
    }

    public Collection<Gear> getChildGears() {
        return this.childGears;
    }

    public void setChildGears(Collection<Gear> childGears) {
        this.childGears = childGears;
    }

    public Gear getParentGear() {
        return this.parentGear;
    }

    public void setParentGear(Gear parentGear) {
        this.parentGear = parentGear;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Gear)) {
            return false;
        }
        Gear that = (Gear)object;
        return this.id != null && that.getId() != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static Gear newInstance() {
            GearImpl entity = new GearImpl();
            return entity;
        }

        public static Gear newInstance(String label, String name, GearClassification gearClassification, Status status) {
            Gear entity = Factory.newInstance();
            entity.setLabel(label);
            entity.setName(name);
            entity.setGearClassification(gearClassification);
            entity.setStatus(status);
            return entity;
        }

        public static Gear newInstance(String label, String name, String description, Timestamp updateDate, GearClassification gearClassification, Collection<Gear> childGears, Gear parentGear, Status status) {
            Gear entity = Factory.newInstance();
            entity.setLabel(label);
            entity.setName(name);
            entity.setDescription(description);
            entity.setUpdateDate(updateDate);
            entity.setGearClassification(gearClassification);
            entity.setChildGears(childGears);
            entity.setParentGear(parentGear);
            entity.setStatus(status);
            return entity;
        }
    }
}

