/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiDataContext;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionException;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.util.decorator.Decorator;

public abstract class AbstractTuttiAction<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
extends AbstractBean {
    private static final Log log = LogFactory.getLog(AbstractTuttiAction.class);
    public static final String PROPERTY_DONE = "done";
    protected final H handler;
    protected String actionDescription;
    protected final boolean hideBody;
    protected final Object lock = new Object();

    protected abstract void doAction() throws Exception;

    protected AbstractTuttiAction(H handler, boolean hideBody) {
        this.handler = handler;
        this.hideBody = hideBody;
    }

    protected boolean prepareAction() throws Exception {
        return true;
    }

    protected void releaseAction() {
        this.firePropertyChange(PROPERTY_DONE, null, true);
    }

    public void postSuccessAction() {
    }

    public void postFailedAction(Throwable error) {
    }

    public static void runAction(AbstractTuttiAction action) {
        Throwable error = null;
        try {
            action.doAction();
            action.postSuccessAction();
        }
        catch (Throwable e) {
            error = e;
            throw TuttiActionException.propagateError(action, e);
        }
        finally {
            if (error != null) {
                action.postFailedAction(error);
            }
            action.releaseAction();
        }
    }

    public H getHandler() {
        return this.handler;
    }

    public M getModel() {
        return (M)((AbstractBean)((AbstractTuttiUIHandler)this.handler).getModel());
    }

    public final UI getUI() {
        return ((AbstractTuttiUIHandler)this.handler).getUI();
    }

    public TuttiUIContext getContext() {
        return ((AbstractTuttiUIHandler)this.handler).getContext();
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public void setActionDescription(String actionDescription) {
        this.actionDescription = actionDescription;
    }

    protected void setProgressionModel(ProgressionModel progressionModel) {
        this.getContext().getActionUI().getModel().setProgressionModel(progressionModel);
    }

    protected ProgressionModel getProgressionModel() {
        return this.getContext().getActionUI().getModel().getProgressionModel();
    }

    public boolean isHideBody() {
        return this.hideBody;
    }

    public TuttiDataContext getDataContext() {
        return this.getContext().getDataContext();
    }

    protected TuttiApplicationConfig getConfig() {
        return this.getContext().getConfig();
    }

    protected void sendMessage(String message) {
        this.getContext().showInformationMessage(message);
    }

    protected <O> Decorator<O> getDecorator(Class<O> type, String name) {
        Decorator<O> decorator = ((AbstractTuttiUIHandler)this.handler).getDecorator(type, name);
        Preconditions.checkNotNull(decorator);
        return decorator;
    }

    protected String decorate(Object object) {
        return this.getDecorator(object.getClass(), null).toString(object);
    }

    protected String decorate(Object object, String context) {
        return this.getDecorator(object.getClass(), context).toString(object);
    }

    protected void test(final Runnable r) throws InterruptedException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("run");
                r.run();
                System.out.println("Deblock ?");
                log.info((Object)"Deblock ?");
                AbstractTuttiAction.this.unblock();
            }
        });
        log.info((Object)"Block ?");
        System.out.println("Block ?");
        this.block();
        System.out.println("Block !");
        log.info((Object)"Block !");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void block() {
        try {
            AbstractTuttiAction abstractTuttiAction = this;
            synchronized (abstractTuttiAction) {
                this.lock.wait();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unblock() {
        try {
            AbstractTuttiAction abstractTuttiAction = this;
            synchronized (abstractTuttiAction) {
                this.lock.notifyAll();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

