/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonExtendDao;
import fr.ifremer.adagio.core.dao.data.vessel.VesselExtendDao;
import fr.ifremer.adagio.core.dao.referential.StatusDao;
import fr.ifremer.adagio.core.dao.referential.gear.FishingGear;
import fr.ifremer.adagio.core.dao.referential.gear.FishingGearExtendDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameExtendDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonRefTaxVO;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.referential.AbstractTuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Status;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.type.DateType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="referentialPersistenceService")
public class ReferentialPersistenceServiceImpl
extends AbstractPersistenceService
implements ReferentialPersistenceService {
    private static final Log log = LogFactory.getLog(ReferentialPersistenceServiceImpl.class);
    @Resource(name="taxonNameDao")
    protected TaxonNameExtendDao taxonNameDao;
    @Resource(name="statusDao")
    protected StatusDao statusDao;
    @Resource(name="personDao")
    protected PersonExtendDao personDao;
    @Resource(name="fishingGearDao")
    protected FishingGearExtendDao fishingGearDao;
    @Resource(name="vesselExtendDao")
    protected VesselExtendDao vesselExtendDao;
    @Resource(name="locationDao")
    protected LocationExtendDao locationDao;

    @Override
    public List<Zone> getAllProgramZone() {
        Iterator<Object[]> list = this.queryListWithStatus("allProgramZones", "locationClassificationId", IntegerType.INSTANCE, this.enumeration.LOCATION_CLASSIFICATION_ID_SECTOR, "locationLevelId", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_PROGRAM);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            Zone target = new Zone();
            target.setId(String.valueOf(source[0]));
            target.setLabel((String)source[1]);
            target.setName((String)source[2]);
            this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[3], target);
            result.add(target);
        }
        return result;
    }

    @Override
    public List<Country> getAllCountry() {
        Iterator<Object[]> list = this.queryListWithStatus("allCountries", "locationLevelId", IntegerType.INSTANCE, this.enumeration.LOCATION_LEVEL_ID_COUNTRY);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            Country target = new Country();
            target.setId(String.valueOf(source[0]));
            target.setLabel((String)source[1]);
            target.setName((String)source[2]);
            this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[3], target);
            result.add(target);
        }
        return result;
    }

    @Override
    public List<FishingOperationLocation> getAllFishingOperationStrata(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId);
        List<FishingOperationLocation> result = this.getFishingOperationLocationsByParent(this.enumeration.LOCATION_LEVEL_ID_STRATA, Integer.valueOf(zoneId), this.enumeration.LOCATION_LEVEL_ID_PROGRAM);
        return result;
    }

    @Override
    public List<FishingOperationLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = this.enumeration.LOCATION_LEVEL_ID_STRATA;
        } else {
            parentId = zoneId;
            parentLocationLevelId = this.enumeration.LOCATION_LEVEL_ID_PROGRAM;
        }
        Preconditions.checkNotNull((Object)parentId);
        List<FishingOperationLocation> result = this.getFishingOperationLocationsByParent(this.enumeration.LOCATION_LEVEL_ID_SUB_STRATA, Integer.valueOf(parentId), parentLocationLevelId);
        return result;
    }

    @Override
    public List<FishingOperationLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (subStrataId != null) {
            parentId = subStrataId;
            parentLocationLevelId = this.enumeration.LOCATION_LEVEL_ID_SUB_STRATA;
        } else if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = this.enumeration.LOCATION_LEVEL_ID_STRATA;
        } else {
            parentId = zoneId;
            parentLocationLevelId = this.enumeration.LOCATION_LEVEL_ID_PROGRAM;
        }
        Preconditions.checkNotNull((Object)parentId);
        List<FishingOperationLocation> result = this.getFishingOperationLocationsByParent(this.enumeration.LOCATION_LEVEL_ID_LOCALITE, Integer.valueOf(parentId), parentLocationLevelId);
        return result;
    }

    @Override
    public FishingOperationLocation getFishingOperationLocation(String id) {
        Object[] source = this.queryUnique("fishingOperationLocationById", "locationId", IntegerType.INSTANCE, Integer.valueOf(id));
        if (source == null) {
            return null;
        }
        FishingOperationLocation target = new FishingOperationLocation();
        target.setId(String.valueOf(source[0]));
        target.setLabel((String)source[1]);
        target.setName((String)source[2]);
        target.setLocationLevel((Integer)source[3]);
        this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[4], target);
        return target;
    }

    @Override
    public List<Vessel> getAllScientificVessel() {
        Iterator<Object[]> list = this.queryListWithStatus("allVessels", "refDate", DateType.INSTANCE, new Date(), "vesselTypeId", IntegerType.INSTANCE, this.enumeration.VESSEL_TYPE_ID_SCIENTIFIC);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            Vessel target = this.loadVessel(source);
            result.add(target);
        }
        return result;
    }

    @Override
    @Cacheable(value={"fishingVessels"})
    public List<Vessel> getAllFishingVessel() {
        Iterator<Object[]> list = this.queryListWithStatus("allVessels", "refDate", DateType.INSTANCE, new Date(), "vesselTypeId", IntegerType.INSTANCE, this.enumeration.VESSEL_TYPE_ID_FISHING);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            Vessel target = this.loadVessel(source);
            result.add(target);
        }
        return result;
    }

    @Override
    public Vessel getVessel(String vesselCode) {
        Iterator<Object[]> source;
        if (log.isInfoEnabled()) {
            log.info((Object)("get vessel: " + vesselCode));
        }
        Vessel result = (source = this.queryListWithStatus("vessel", "vesselCode", StringType.INSTANCE, vesselCode, "refDate", DateType.INSTANCE, new Date())).hasNext() ? this.loadVessel(source.next()) : null;
        return result;
    }

    @Override
    public List<Gear> getAllScientificGear() {
        Iterator<Object[]> sources = this.queryListWithStatus("allGears", "gearClassificiationId", IntegerType.INSTANCE, this.enumeration.GEAR_CLASSIFICIATION_ID_SCIENTIFIC);
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            Gear target = this.loadGear(source);
            result.add(target);
        }
        return result;
    }

    @Override
    public List<Gear> getAllFishingGear() {
        Iterator<Object[]> sources = this.queryListWithStatus("allGears", "gearClassificiationId", IntegerType.INSTANCE, this.enumeration.GEAR_CLASSIFICIATION_ID_FISHING);
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            Gear target = this.loadGear(source);
            result.add(target);
        }
        return result;
    }

    @Override
    public List<fr.ifremer.tutti.persistence.entities.referential.Person> getAllPerson() {
        Iterator<Object[]> list = this.queryListWithStatus("allPersons", "observerProfilId", IntegerType.INSTANCE, this.enumeration.USER_PROFIL_ID_OBSERVER, "projectMemberProfilId", IntegerType.INSTANCE, this.enumeration.USER_PROFIL_ID_PROJECT_MEMBER, "userProfilId", IntegerType.INSTANCE, this.enumeration.USER_PROFIL_ID_USER);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            fr.ifremer.tutti.persistence.entities.referential.Person target = this.loadPerson(source);
            result.add(target);
        }
        return result;
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.referential.Person getPerson(Integer personId) {
        Object[] source = this.queryUnique("person", "personId", IntegerType.INSTANCE, personId);
        fr.ifremer.tutti.persistence.entities.referential.Person result = source == null ? null : this.loadPerson(source);
        return result;
    }

    @Override
    public Gear getGear(Integer gearId) {
        Object[] source = this.queryUnique("gear", "gearId", IntegerType.INSTANCE, gearId);
        Gear result = source == null ? null : this.loadGear(source);
        return result;
    }

    @Override
    public boolean isSortedQualitativeValue(CaracteristicQualitativeValue value) {
        return value != null && this.enumeration.QUALITATIVE_VRAC_ID.toString().equals(value.getId());
    }

    @Override
    @Cacheable(value={"species"})
    public List<Species> getAllSpecies() {
        TaxonRefTaxVO[] sources = this.taxonNameDao.getAllTaxonNames(true);
        ArrayList result = Lists.newArrayListWithCapacity((int)sources.length);
        ArrayList referenceTaxonsOnly = Lists.newArrayList();
        for (TaxonRefTaxVO source : sources) {
            Species target = this.loadSpecies(source);
            if (target.isReferenceTaxon()) {
                this.putToSpeciesReferentCache(target.getReferenceTaxonId(), target);
                referenceTaxonsOnly.add(target);
            }
            result.add(target);
        }
        this.putToSpeciesReferentCache(referenceTaxonsOnly);
        return result;
    }

    @Override
    @Cacheable(value={"referentSpecies"})
    public List<Species> getAllReferentSpecies() {
        TaxonRefTaxVO[] sources = this.taxonNameDao.getAllTaxonNames(false);
        ArrayList result = Lists.newArrayListWithCapacity((int)sources.length);
        for (TaxonRefTaxVO source : sources) {
            if (36403 == source.getTaxonNameId() || 34539 == source.getTaxonNameId()) continue;
            Species target = this.loadSpecies(source);
            this.putToSpeciesReferentCache(target.getReferenceTaxonId(), target);
            result.add(target);
        }
        return result;
    }

    @Override
    @Cacheable(value={"referentSpecies"}, key="#speciesId")
    public Species getSpeciesByReferenceTaxonId(Integer speciesId) {
        Species target;
        try {
            TaxonRefTaxVO source = this.taxonNameDao.getTaxonNameReferent(speciesId);
            target = this.loadSpecies(source);
        }
        catch (DataRetrievalFailureException drfe) {
            target = null;
        }
        return target;
    }

    @Override
    @Cacheable(value={"pmfms"})
    public List<Caracteristic> getAllCaracteristic() {
        Iterator<Object[]> sources = this.queryListWithStatus("allPmfm", "unitIdNone", IntegerType.INSTANCE, this.enumeration.UNIT_ID_NONE);
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            Integer pmfmId = (Integer)source[0];
            if (!this.isProtectedCaracteristic(pmfmId)) {
                Caracteristic target = this.loadCaracteristic(source);
                this.putToCaracteristicCache(pmfmId, target);
                result.add(target);
                continue;
            }
            this.putToCaracteristicCache(pmfmId, this.loadCaracteristic(source));
        }
        return result;
    }

    @Override
    public Caracteristic getSizeCategoryCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_SIZE_CATEGORY;
        Caracteristic result = this.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getSexCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_SEX;
        Caracteristic result = this.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getSortedUnsortedCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_SORTED_UNSORTED;
        Caracteristic result = this.getCaracteristic(pmfmId);
        for (CaracteristicQualitativeValue qv : result.getQualitativeValue()) {
            if (qv == null || qv.getId() == null || !this.enumeration.QUALITATIVE_UNSORTED_ID.equals(Integer.valueOf(qv.getId()))) continue;
            result.removeQualitativeValue(qv);
            break;
        }
        return result;
    }

    @Override
    public Caracteristic getMaturityCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_MATURITY;
        Caracteristic result = this.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getMacroWasteCategoryCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_MARINE_LITTER_TYPE;
        Caracteristic result = this.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getMacroWasteSizeCategoryCaracteristic() {
        Integer pmfmId = this.enumeration.PMFM_ID_MARINE_LITTER_SIZE_CATEGORY;
        Caracteristic result = this.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    @Cacheable(value={"pmfms"}, key="#pmfmId")
    public Caracteristic getCaracteristic(Integer pmfmId) {
        Object[] source = this.queryUniqueWithStatus("pmfmById", "pmfmId", IntegerType.INSTANCE, pmfmId, "unitIdNone", IntegerType.INSTANCE, this.enumeration.UNIT_ID_NONE);
        Caracteristic target = this.loadCaracteristic(source);
        return target;
    }

    @Override
    @CacheEvict(value={"species", "referentSpecies"}, allEntries=true)
    public List<Species> importTemporarySpecies(List<Species> species) {
        ArrayList result = Lists.newArrayList();
        for (Species source : species) {
            source = this.importTemporarySpecies(source);
            result.add(source);
        }
        return result;
    }

    @Override
    @CacheEvict(value={"fishingVessels"}, allEntries=true)
    public List<Vessel> importTemporaryVessel(List<Vessel> vessels) {
        ArrayList result = Lists.newArrayList();
        fr.ifremer.adagio.core.dao.referential.Status status = this.statusDao.load(this.enumeration.STATUS_TEMPORARY_CODE);
        Integer countryLocationId = this.locationDao.getLocationIdByLabelAndLocationLevel(this.enumeration.LOCATION_LABEL_DEFAULT_COUNTRY, new Integer[]{this.enumeration.LOCATION_LEVEL_ID_COUNTRY});
        if (countryLocationId == null) {
            throw new DataIntegrityViolationException("Default country location not found, with label=" + this.enumeration.LOCATION_LABEL_DEFAULT_COUNTRY);
        }
        for (Vessel source : vessels) {
            source = this.importTemporaryVessel(source, countryLocationId, status);
            result.add(source);
        }
        return result;
    }

    @Override
    @CacheEvict(value={"persons"}, allEntries=true)
    public List<fr.ifremer.tutti.persistence.entities.referential.Person> importTemporaryPerson(List<fr.ifremer.tutti.persistence.entities.referential.Person> persons) {
        ArrayList result = Lists.newArrayList();
        fr.ifremer.adagio.core.dao.referential.Status status = this.statusDao.load(this.enumeration.STATUS_TEMPORARY_CODE);
        for (fr.ifremer.tutti.persistence.entities.referential.Person source : persons) {
            source = this.importTemporaryPerson(source, status);
            result.add(source);
        }
        return result;
    }

    @Override
    @CacheEvict(value={"gears"}, allEntries=true)
    public List<Gear> importTemporaryGear(List<Gear> gears) {
        ArrayList result = Lists.newArrayList();
        fr.ifremer.adagio.core.dao.referential.Status status = this.statusDao.load(this.enumeration.STATUS_TEMPORARY_CODE);
        for (Gear source : gears) {
            source = this.importTemporaryGear(source, status);
            result.add(source);
        }
        return result;
    }

    public Vessel importTemporaryVessel(Vessel source, Integer registrationLocationId, fr.ifremer.adagio.core.dao.referential.Status status) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getName());
        Preconditions.checkNotNull((Object)source.getInternationalRegistrationCode());
        Integer vesselTypeId = source.isScientificVessel() ? this.enumeration.VESSEL_TYPE_ID_SCIENTIFIC : this.enumeration.VESSEL_TYPE_ID_FISHING;
        fr.ifremer.adagio.core.dao.referential.vessel.Vessel target = this.vesselExtendDao.createAsTemporary(null, source.getInternationalRegistrationCode(), registrationLocationId, source.getName(), vesselTypeId);
        Vessel result = new Vessel();
        result.setId(target.getCode());
        result.setName(source.getName());
        result.setRegistrationCode(source.getRegistrationCode());
        result.setInternationalRegistrationCode(source.getInternationalRegistrationCode());
        result.setScientificVessel(source.isScientificVessel());
        this.setStatus(status, result);
        return result;
    }

    public fr.ifremer.tutti.persistence.entities.referential.Person importTemporaryPerson(fr.ifremer.tutti.persistence.entities.referential.Person source, fr.ifremer.adagio.core.dao.referential.Status status) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getFirstName());
        Preconditions.checkNotNull((Object)source.getLastName());
        Person target = this.personDao.createAsTemporary(source.getLastName(), source.getFirstName(), this.enumeration.DEPARTMENT_ID_UNKNOWN_RECORDER_DEPARTMENT);
        fr.ifremer.tutti.persistence.entities.referential.Person result = new fr.ifremer.tutti.persistence.entities.referential.Person();
        result.setId(target.getId().toString());
        result.setLastName(source.getLastName());
        result.setFirstName(source.getFirstName());
        this.setStatus(status, result);
        return result;
    }

    protected Species importTemporarySpecies(Species source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getName());
        TaxonRefTaxVO taxonName = new TaxonRefTaxVO();
        taxonName.setName(source.getName());
        taxonName = this.taxonNameDao.createAsTemporary(taxonName, "Added by tutti (file import).");
        Species result = this.loadSpecies(taxonName);
        this.putToSpeciesReferentCache(Integer.valueOf(result.getId()), result);
        return result;
    }

    public Gear importTemporaryGear(Gear source, fr.ifremer.adagio.core.dao.referential.Status status) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getLabel());
        Preconditions.checkNotNull((Object)source.getName());
        Integer gearClassificationId = source.isScientificGear() ? this.enumeration.GEAR_CLASSIFICIATION_ID_SCIENTIFIC : this.enumeration.GEAR_CLASSIFICIATION_ID_FISHING;
        FishingGear target = this.fishingGearDao.createAsTemporary(source.getLabel(), source.getName(), gearClassificationId);
        Gear result = new Gear();
        result.setId(target.getId().toString());
        result.setLabel(source.getLabel());
        result.setName(source.getName());
        this.setStatus(status, result);
        return result;
    }

    protected List<FishingOperationLocation> getFishingOperationLocations(Integer locationLevelId) {
        Iterator<Object[]> sources = this.queryListWithStatus("allFishingOperationLocation", "locationClassificationId", IntegerType.INSTANCE, this.enumeration.LOCATION_CLASSIFICATION_ID_SECTOR, "locationLevelId", IntegerType.INSTANCE, locationLevelId);
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            FishingOperationLocation target = new FishingOperationLocation();
            target.setId(String.valueOf(source[0]));
            target.setLabel((String)source[1]);
            target.setName((String)source[2]);
            target.setLocationLevel((Integer)source[3]);
            this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[4], target);
            result.add(target);
        }
        return result;
    }

    protected List<FishingOperationLocation> getFishingOperationLocationsByParent(Integer locationLevelId, Integer parentId, Integer parentLocationLevelId) {
        Iterator<Object[]> sources = this.queryListWithStatus("allFishingOperationLocationByParent", "parentId", IntegerType.INSTANCE, parentId, "parentLocationLevelId", IntegerType.INSTANCE, parentLocationLevelId, "locationClassificationId", IntegerType.INSTANCE, this.enumeration.LOCATION_CLASSIFICATION_ID_SECTOR, "locationLevelId", IntegerType.INSTANCE, locationLevelId);
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            FishingOperationLocation target = new FishingOperationLocation();
            target.setId(String.valueOf(source[0]));
            target.setLabel((String)source[1]);
            target.setName((String)source[2]);
            target.setLocationLevel((Integer)source[3]);
            this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[4], target);
            result.add(target);
        }
        return result;
    }

    protected Caracteristic loadCaracteristic(Object[] source) {
        Integer pmfmId = (Integer)source[0];
        Caracteristic result = new Caracteristic();
        result.setId(pmfmId.toString());
        result.setParameterName((String)source[1]);
        result.setMatrixName((String)source[2]);
        result.setFractionName((String)source[3]);
        result.setMethodName((String)source[4]);
        CaracteristicType type = TuttiEntities.getType((Boolean)source[5], (Boolean)source[6]);
        result.setCaracteristicType(type);
        result.setSignifFiguresNumber((Integer)source[7]);
        result.setMaximumNumberDecimals((Integer)source[8]);
        result.setPrecision((Float)source[9]);
        result.setUnit((String)source[10]);
        this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[11], result);
        if (TuttiEntities.isQualitativeCaracteristic(result)) {
            Iterator<Object[]> sources = this.queryListWithStatus("pmfmQualitativeValues", "pmfmId", IntegerType.INSTANCE, pmfmId);
            ArrayList values = Lists.newArrayList();
            while (sources.hasNext()) {
                Object[] source2 = sources.next();
                CaracteristicQualitativeValue target2 = new CaracteristicQualitativeValue();
                target2.setId(String.valueOf(source2[0]));
                target2.setName(String.valueOf(source2[1]));
                this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source2[2], target2);
                values.add(target2);
            }
            result.setQualitativeValue(values);
        }
        return result;
    }

    protected Species loadSpecies(TaxonRefTaxVO source) {
        Species target = new Species();
        target.setId(String.valueOf(source.getTaxonNameId()));
        target.setName(source.getName());
        target.setRefTaxCode(source.getRefTaxCode());
        target.setReferenceTaxonId(source.getReferenceTaxonId());
        target.setReferenceTaxon(source.getIsReference());
        fr.ifremer.adagio.core.dao.referential.Status status = this.statusDao.load(source.getStatus().getValue());
        this.setStatus(status, target);
        return target;
    }

    protected Vessel loadVessel(Object[] source) {
        Vessel target = new Vessel();
        target.setId((String)source[0]);
        target.setRegistrationCode((String)source[1]);
        target.setInternationalRegistrationCode((String)source[2]);
        target.setName((String)source[3]);
        this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[4], target);
        return target;
    }

    protected fr.ifremer.tutti.persistence.entities.referential.Person loadPerson(Object[] source) {
        fr.ifremer.tutti.persistence.entities.referential.Person target = new fr.ifremer.tutti.persistence.entities.referential.Person();
        target.setId(String.valueOf(source[0]));
        target.setFirstName((String)source[1]);
        target.setLastName((String)source[2]);
        target.setDepartment((String)source[3]);
        this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[4], target);
        return target;
    }

    protected Gear loadGear(Object[] source) {
        Gear result = new Gear();
        result.setId(String.valueOf(source[0]));
        result.setLabel((String)source[1]);
        result.setName((String)source[2]);
        this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[3], result);
        return result;
    }

    protected Iterator<Object[]> queryListWithStatus(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        query.setString("statusValidCode", this.enumeration.STATUS_VALID_CODE);
        query.setString("statusTemporaryCode", this.enumeration.STATUS_TEMPORARY_CODE);
        Iterator result = query.iterate();
        return result;
    }

    protected Object[] queryUniqueWithStatus(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        query.setString("statusValidCode", this.enumeration.STATUS_VALID_CODE);
        query.setString("statusTemporaryCode", this.enumeration.STATUS_TEMPORARY_CODE);
        Object result = query.uniqueResult();
        return (Object[])result;
    }

    protected <E extends AbstractTuttiReferentialEntity> void setStatus(fr.ifremer.adagio.core.dao.referential.Status status, E entity) {
        Status newStatus = new Status();
        newStatus.setId(status.getCode());
        newStatus.setName(status.getName());
        entity.setStatus(newStatus);
    }

    @Override
    public List<Integer> getSampleCategoryIds() {
        return Lists.newArrayList((Object[])new Integer[]{this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.PMFM_ID_SIZE_CATEGORY, this.enumeration.PMFM_ID_MATURITY, this.enumeration.PMFM_ID_SEX, this.enumeration.PMFM_ID_AGE});
    }

    protected boolean isProtectedCaracteristic(Integer pmfmId) {
        return pmfmId.equals(this.enumeration.PMFM_ID_MULTIRIG_AGGREGATION) || pmfmId.equals(this.enumeration.PMFM_ID_MULTIRIG_NUMBER) || pmfmId.equals(this.enumeration.PMFM_ID_STATION_NUMBER) || pmfmId.equals(this.enumeration.PMFM_ID_RECTILINEAR_OPERATION) || pmfmId.equals(this.enumeration.PMFM_ID_HAUL_VALID) || pmfmId.equals(this.enumeration.PMFM_ID_TRAWL_DISTANCE);
    }

    @Override
    public SampleCategoryEnum getSampleCategoryByPmfmId(Integer pmfmId) {
        if (pmfmId == null) {
            return null;
        }
        SampleCategoryEnum sampleCategory = null;
        if (pmfmId.intValue() == this.enumeration.PMFM_ID_SORTED_UNSORTED.intValue()) {
            sampleCategory = SampleCategoryEnum.sortedUnsorted;
        } else if (this.enumeration.PMFM_ID_SIZE_CATEGORY.equals(pmfmId)) {
            sampleCategory = SampleCategoryEnum.size;
        } else if (this.enumeration.PMFM_ID_MATURITY.equals(pmfmId)) {
            sampleCategory = SampleCategoryEnum.maturity;
        } else if (this.enumeration.PMFM_ID_SEX.equals(pmfmId)) {
            sampleCategory = SampleCategoryEnum.sex;
        } else if (this.enumeration.PMFM_ID_AGE.equals(pmfmId)) {
            sampleCategory = SampleCategoryEnum.age;
        }
        return sampleCategory;
    }

    @Cacheable(value={"pmfms"}, key="#pmfmId")
    protected Caracteristic putToCaracteristicCache(Integer pmfmId, Caracteristic caracteristic) {
        return caracteristic;
    }

    @CachePut(value={"referentSpecies"})
    protected List<Species> putToSpeciesReferentCache(List<Species> species) {
        return species;
    }

    @CachePut(value={"referentSpecies"}, key="#speciesId")
    protected Species putToSpeciesReferentCache(Integer speciesId, Species species) {
        return species;
    }
}

