/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupHistoricalRecord;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupInformation;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupType;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class TaxonGroupDaoBase
extends HibernateDaoSupport
implements TaxonGroupDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("TaxonGroup.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(TaxonGroupImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (TaxonGroup)entity);
    }

    @Override
    public TaxonGroup load(Integer id) {
        return (TaxonGroup)this.load(0, id);
    }

    @Override
    public Collection<TaxonGroup> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(TaxonGroupImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public TaxonGroup create(TaxonGroup taxonGroup) {
        return (TaxonGroup)this.create(0, taxonGroup);
    }

    @Override
    public Object create(int transform, TaxonGroup taxonGroup) {
        if (taxonGroup == null) {
            throw new IllegalArgumentException("TaxonGroup.create - 'taxonGroup' can not be null");
        }
        this.getHibernateTemplate().save((Object)taxonGroup);
        return this.transformEntity(transform, taxonGroup);
    }

    @Override
    public Collection<TaxonGroup> create(Collection<TaxonGroup> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<TaxonGroup> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonGroup.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonGroupDaoBase.this.create(transform, (TaxonGroup)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public TaxonGroup create(String label, String name, String comments, Boolean isChildGroupExclusive, Boolean isUpdatable, Date creationDate, Timestamp updateDate, Collection<TaxonGroup> childTaxonGroup, TaxonGroup parentTaxonGroup, Collection<TaxonGroupHistoricalRecord> taxonGroupHistoricalRecords, TaxonGroupType taxonGroupType, Collection<TaxonGroupInformation> taxonGroupInformations, Status status) {
        return (TaxonGroup)this.create(0, label, name, comments, isChildGroupExclusive, isUpdatable, creationDate, updateDate, childTaxonGroup, parentTaxonGroup, taxonGroupHistoricalRecords, taxonGroupType, taxonGroupInformations, status);
    }

    @Override
    public Object create(int transform, String label, String name, String comments, Boolean isChildGroupExclusive, Boolean isUpdatable, Date creationDate, Timestamp updateDate, Collection<TaxonGroup> childTaxonGroup, TaxonGroup parentTaxonGroup, Collection<TaxonGroupHistoricalRecord> taxonGroupHistoricalRecords, TaxonGroupType taxonGroupType, Collection<TaxonGroupInformation> taxonGroupInformations, Status status) {
        TaxonGroupImpl entity = new TaxonGroupImpl();
        entity.setLabel(label);
        entity.setName(name);
        entity.setComments(comments);
        entity.setIsChildGroupExclusive(isChildGroupExclusive);
        entity.setIsUpdatable(isUpdatable);
        entity.setCreationDate(creationDate);
        entity.setUpdateDate(updateDate);
        entity.setChildTaxonGroup(childTaxonGroup);
        entity.setParentTaxonGroup(parentTaxonGroup);
        entity.setTaxonGroupHistoricalRecords(taxonGroupHistoricalRecords);
        entity.setTaxonGroupType(taxonGroupType);
        entity.setTaxonGroupInformations(taxonGroupInformations);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public TaxonGroup create(Date creationDate, Boolean isChildGroupExclusive, Boolean isUpdatable, String name, Status status, TaxonGroupType taxonGroupType) {
        return (TaxonGroup)this.create(0, creationDate, isChildGroupExclusive, isUpdatable, name, status, taxonGroupType);
    }

    @Override
    public Object create(int transform, Date creationDate, Boolean isChildGroupExclusive, Boolean isUpdatable, String name, Status status, TaxonGroupType taxonGroupType) {
        TaxonGroupImpl entity = new TaxonGroupImpl();
        entity.setCreationDate(creationDate);
        entity.setIsChildGroupExclusive(isChildGroupExclusive);
        entity.setIsUpdatable(isUpdatable);
        entity.setName(name);
        entity.setStatus(status);
        entity.setTaxonGroupType(taxonGroupType);
        return this.create(transform, entity);
    }

    @Override
    public void update(TaxonGroup taxonGroup) {
        if (taxonGroup == null) {
            throw new IllegalArgumentException("TaxonGroup.update - 'taxonGroup' can not be null");
        }
        this.getHibernateTemplate().update((Object)taxonGroup);
    }

    @Override
    public void update(final Collection<TaxonGroup> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonGroup.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonGroupDaoBase.this.update((TaxonGroup)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(TaxonGroup taxonGroup) {
        if (taxonGroup == null) {
            throw new IllegalArgumentException("TaxonGroup.remove - 'taxonGroup' can not be null");
        }
        this.getHibernateTemplate().delete((Object)taxonGroup);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("TaxonGroup.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        TaxonGroup entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<TaxonGroup> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonGroup.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, TaxonGroup entity) {
        TaxonGroup target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected TaxonGroup toEntity(Object[] row) {
        TaxonGroup target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof TaxonGroup)) continue;
                target = (TaxonGroup)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonGroupImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonGroupImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<TaxonGroup> search(Search search) {
        return this.search(0, search);
    }
}

