/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.taxon.Author;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceDocument;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceDocumentDao;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceDocumentImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonInformationHistory;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class ReferenceDocumentDaoBase
extends HibernateDaoSupport
implements ReferenceDocumentDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("ReferenceDocument.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(ReferenceDocumentImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (ReferenceDocument)entity);
    }

    @Override
    public ReferenceDocument load(Integer id) {
        return (ReferenceDocument)this.load(0, id);
    }

    @Override
    public Collection<ReferenceDocument> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(ReferenceDocumentImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public ReferenceDocument create(ReferenceDocument referenceDocument) {
        return (ReferenceDocument)this.create(0, referenceDocument);
    }

    @Override
    public Object create(int transform, ReferenceDocument referenceDocument) {
        if (referenceDocument == null) {
            throw new IllegalArgumentException("ReferenceDocument.create - 'referenceDocument' can not be null");
        }
        this.getHibernateTemplate().save((Object)referenceDocument);
        return this.transformEntity(transform, referenceDocument);
    }

    @Override
    public Collection<ReferenceDocument> create(Collection<ReferenceDocument> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<ReferenceDocument> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ReferenceDocument.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ReferenceDocumentDaoBase.this.create(transform, (ReferenceDocument)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public ReferenceDocument create(String reference, Date publicationDate, String comments, Date creationDate, Timestamp updateDate, Status status, Collection<Author> authors, Collection<TaxonInformationHistory> taxonInformationHistories) {
        return (ReferenceDocument)this.create(0, reference, publicationDate, comments, creationDate, updateDate, status, authors, taxonInformationHistories);
    }

    @Override
    public Object create(int transform, String reference, Date publicationDate, String comments, Date creationDate, Timestamp updateDate, Status status, Collection<Author> authors, Collection<TaxonInformationHistory> taxonInformationHistories) {
        ReferenceDocumentImpl entity = new ReferenceDocumentImpl();
        entity.setReference(reference);
        entity.setPublicationDate(publicationDate);
        entity.setComments(comments);
        entity.setCreationDate(creationDate);
        entity.setUpdateDate(updateDate);
        entity.setStatus(status);
        entity.setAuthors(authors);
        entity.setTaxonInformationHistories(taxonInformationHistories);
        return this.create(transform, entity);
    }

    @Override
    public ReferenceDocument create(Collection<Author> authors, Date creationDate, String reference, Status status) {
        return (ReferenceDocument)this.create(0, authors, creationDate, reference, status);
    }

    @Override
    public Object create(int transform, Collection<Author> authors, Date creationDate, String reference, Status status) {
        ReferenceDocumentImpl entity = new ReferenceDocumentImpl();
        entity.setAuthors(authors);
        entity.setCreationDate(creationDate);
        entity.setReference(reference);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(ReferenceDocument referenceDocument) {
        if (referenceDocument == null) {
            throw new IllegalArgumentException("ReferenceDocument.update - 'referenceDocument' can not be null");
        }
        this.getHibernateTemplate().update((Object)referenceDocument);
    }

    @Override
    public void update(final Collection<ReferenceDocument> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ReferenceDocument.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ReferenceDocumentDaoBase.this.update((ReferenceDocument)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(ReferenceDocument referenceDocument) {
        if (referenceDocument == null) {
            throw new IllegalArgumentException("ReferenceDocument.remove - 'referenceDocument' can not be null");
        }
        this.getHibernateTemplate().delete((Object)referenceDocument);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("ReferenceDocument.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        ReferenceDocument entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<ReferenceDocument> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ReferenceDocument.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, ReferenceDocument entity) {
        ReferenceDocument target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected ReferenceDocument toEntity(Object[] row) {
        ReferenceDocument target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof ReferenceDocument)) continue;
                target = (ReferenceDocument)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ReferenceDocumentImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ReferenceDocumentImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<ReferenceDocument> search(Search search) {
        return this.search(0, search);
    }
}

