/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential;

import fr.ifremer.adagio.core.dao.data.history.ProcessingHistory;
import fr.ifremer.adagio.core.dao.referential.ProcessingTypeImpl;
import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

public abstract class ProcessingType
implements Serializable {
    private static final long serialVersionUID = 3972972664070343819L;
    private String code;
    private String description;
    private Timestamp updateDate;
    private Status status;
    private Collection<ProcessingHistory> processingHistories = new HashSet<ProcessingHistory>();

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Collection<ProcessingHistory> getProcessingHistories() {
        return this.processingHistories;
    }

    public void setProcessingHistories(Collection<ProcessingHistory> processingHistories) {
        this.processingHistories = processingHistories;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProcessingType)) {
            return false;
        }
        ProcessingType that = (ProcessingType)object;
        return this.code != null && that.getCode() != null && this.code.equals(that.getCode());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.code == null ? 0 : this.code.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static ProcessingType newInstance() {
            ProcessingTypeImpl entity = new ProcessingTypeImpl();
            return entity;
        }

        public static ProcessingType newInstance(Status status) {
            ProcessingType entity = Factory.newInstance();
            entity.setStatus(status);
            return entity;
        }

        public static ProcessingType newInstance(String description, Timestamp updateDate, Status status, Collection<ProcessingHistory> processingHistories) {
            ProcessingType entity = Factory.newInstance();
            entity.setDescription(description);
            entity.setUpdateDate(updateDate);
            entity.setStatus(status);
            entity.setProcessingHistories(processingHistories);
            return entity;
        }
    }
}

