package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.ActionListCellRenderer;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SelectCruiseUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SelectCruiseUIModel, SelectCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CRUISE_COMBOBOX_ENABLED = "cruiseCombobox.enabled";
    public static final String BINDING_CRUISE_COMBOBOX_SELECTED_ITEM = "cruiseCombobox.selectedItem";
    public static final String BINDING_EDIT_CATCHES_BUTTON_ENABLED = "editCatchesButton.enabled";
    public static final String BINDING_EDIT_CRUISE_BUTTON_ENABLED = "editCruiseButton.enabled";
    public static final String BINDING_EDIT_PROGRAM_BUTTON_ENABLED = "editProgramButton.enabled";
    public static final String BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED = "editProtocolComboBox.enabled";
    public static final String BINDING_NEW_CRUISE_BUTTON_ENABLED = "newCruiseButton.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_ENABLED = "programCombobox.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM = "programCombobox.selectedItem";
    public static final String BINDING_PROTOCOL_COMBOBOX_ENABLED = "protocolCombobox.enabled";
    public static final String BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM = "protocolCombobox.selectedItem";
    public static final String BINDING_VALIDATE_CATCHES_BUTTON_ENABLED = "validateCatchesButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAL1ZS28cRRDu9fuRxI5f8SthY0KwiTNrJwSFJILE65jYOCGKnSjgg5ndadsTZmeGmd54rVUQP4GfAHdAQnDjhDhw5sAF8RcQ4sAVUd3z7Jmex3ojImXl7a6qrvq6Xl379Z+o27bQ+WdyoyFZdZ2oNSxt3Hn69IPKM1wlq9iuWqpJDAs5/wodqGMHDSr+uk3QqzublL3kspfKRs00dKyHuG9uogGbHGnYPsCYEHSW56jadmnL377ZMOuWJ9VXSiT1y7//6vhC+fyrDoQaJmh3DkwpZnEFlnRtog5VIWgETnoulzRZ3wc1LFXfB31P0rWyJtv2A7mGP0Wfod5N1GPKFggjaC6/yUwG42+YBI3ZWANgy1ZdtfG2YT6UdawRdG3PktQ9C9ewJZE6IapUVyX7EFSRqoZOQLJ0YIA9WyHux+umyQT3ENR7IOuKhi2Cbh1L0j2HPRDYXTMUqtiNY4m7T5kDYf3PZU1VZECFoEvc/fgbrswt+vnEWwwk9FQs4xNq3kKyPtv06z04d4XRBsyndXz40DKIUTW0FSACvdEovd6Gy7nhrFLyfp9rTIU7tQjPSPemeboRrKjZVKNVDRwkk2wMN3IdOgb4YpItr/fCtlzR8BJBkxzuLmJ0j2c4YVrGviXXNuUKvf4RDia2SAlf8+mHXHqIgIpRMRrgyoKDKERwxxUs69IKfKypGsEWPZ3xrRgNXmrfhQ0WGEtRDdgqT3vaxZ9qEcFB8omGHRdIpRmsMu/1jXyDP+eUs+0ZSlcvi7Vept+X+L1hqqUTHhEF3g6wBCUzSE6a7o0naTnsEeTQ84pAz7GwN3uXQ9A4dwvhSysHLh4KszDFezyZd/pVwensLssyqR5gO4LBhk807iYNnEhooRnOCaG+SEF9CQpAYQd1W3VYhvDYiZekR7DlFKPJSDGiAtnuvxOjv/34xw9r4Qo0LiQNFVCoDHBLJqQzlR495JSfOlG10n3ZvLmD+p0iwarrrECxLXcblIPzTlN2ibJL92T7AER09/7+088TH//aiTrW0IBmyMqaTOnXUT85sAAFQ1Ma5ru3mUYnDvvgcxj+dxLURUMU0kaTpf8XBA2oy9f1hxbeU8ELhpyM6yp/JEFmB1mHj7BNi3oXseq4AWjNCtDyVa70//LP6NZ3tz3ECmDBVCJ5gFr3R6hH1TVVx6xquwVZWKUHTRvXFSMovKJSjKAYT4hzkVs5HrPPD2MwFaA67h5AnSHoleYcg4R+k8KVXaIrcy8adSpCZmbSv6oooQMwM87sovDiBqA86tyBRuNfcpMvXBPcr2ro67Qmo15/eZAYhratmtuMdT5B1z0Va4onSyLQvvgGXk40kGdKNpcrKFlmdoPyWKd3AW3ZbPN8pLhIqn23ZpKj+QXwzBOOOlhZJxhMHXNcVtrHXjFgVH3UobePTAj7oaa7IVWpH9BNz5PDmA3t+k2JWwSnm7vzcwLY5xaEFkdLYpbRvWGjJ10zVNtVds2o6wozxXWASUcT58KlUPEDe2o6rhm6WiWocDfiFF2UElDbZex32A5BU827gQBn0UeHd57LCX4Q14P3oCuJHiTgTHajeJXPgrXHR+wMh1jQCfCAPYgA1ikrSgyvyeYDnz0VrsV0owMleLSWs9AKMSaDFet2csRdH3PtNdqiDzf5VifwvZFwFDhEEdR6vFUejtdTs4jDwyOxmJF5qll5NtzO5UivQQjONM/z9qelndEg7TjqOVknSCw+IPG8MhXNKw5pQlqJ9J8tZZXlhKxSvHix6O046sfSzZlYuim7BrWebSZZtnH424meQIsWoyfEmBI90Vb9JSfwiWg6EgGaKxudodkoB5yXMnOKCM2lHLkoE8zom6a1TDTSjD5nAhjHIhWZkUVQ6wvWeUQWsroaxsXjIWX3Qg5XMhr8862lrHSWdUMcFml5aZxrhxhbNDOFwInnphlBz8OIE7JT7N2ZZVxHMGO63XSnV8yjKD+bH83HxjaLRdFMhpllYV3BFp0QnWsCX9GJh03VJmWsaY/c3Xmx8qKXa5b+neHLmQoHPRMTRL1npZZgZXx8tFgUDIsWi6LR0GJRNAhqHxHhGCB/xzUp6LhcV2s5yU25LRfjb6dFDanRYosa5kxpUWP+mh+wGQ4w3st5zNajDZdDHINttrnOSUlFbindfl4fHrxrWeBFmFMexqLgzg/hlOhdJAAwX6sy7T2MssGTcr1vBNBdzfk0ygJOMIHOD9s0BxuXeHjcylHcqoZ5FMNtplkOi0gFrpRuPacLj9ybWcjxvMnQicbyx41aPj+nO12PQyyI2ruNlxW1vD4tRm2EOSVqRWXpuBDyxYyHcDUKoUMsgHCVk9IOhLw+LUIYYU6BUFTDW3p0lPz+g/125jzs6mqZ/kLXIMHjTtWAPH2Y5A7Vjz9McgW0O0xyxRxjmORxZgyTuF8P/h+0Zzm0Iz9j8Ig/ib5kPOoY6mebT3hBqcgvp+MX0YlH/60s9KPcyTcg/g0n6xYKEPWafGQAMTp1C9jlYkXVFVXffyd2SIF+DuSQ6E+IgaLwrVjOYqYcyvxNioRSLgnfp0i43rYON9rWYaVtHVbblvA+SPgP259da7ciAAA=";
    private static final Log log = LogFactory.getLog(SelectCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cloneProtocolButton;
    @ValidatorField( validatorId = "validator",  propertyName = "cruise",  editorName = "cruiseCombobox")
    protected BeanFilterableComboBox<Cruise> cruiseCombobox;
    protected JLabel cruiseLabel;
    protected JButton deleteProtocolButton;
    protected JButton editCatchesButton;
    protected JButton editCruiseButton;
    protected JButton editProgramButton;
    protected JButton editProtocolButton;
    protected JComboBox editProtocolComboBox;
    protected JButton exportProtocolButton;
    protected SelectCruiseUIHandler handler;
    protected JButton importProtocolButton;
    protected SelectCruiseUIModel model;
    protected JButton newCruiseButton;
    protected JButton newProgramButton;
    protected JButton newProtocolButton;
    protected JComboBox newProtocolComboBox;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programCombobox")
    protected BeanFilterableComboBox<Program> programCombobox;
    protected JLabel programLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "protocol",  editorName = "protocolCombobox")
    protected BeanFilterableComboBox<TuttiProtocol> protocolCombobox;
    protected JLabel protocolLabel;
    protected SelectCruiseUI selectCruiseTopPanel = this;
    protected JButton validateCatchesButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<SelectCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiUIContext uiContext;
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectCruiseUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                uiContext = parentUI.getHandler().getContext();
                SelectCruiseUIHandler handler =
                                     new SelectCruiseUIHandler(parentUI, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public SelectCruiseUI() {
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExistingProtocolAction(event);
    }

    public void doActionPerformed__on__newProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startNewProtocolAction(event);
    }

    public void doMouseClicked__on__editProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProtocolComboBox.isEnabled()) { handler.startExistingProtocolAction(event); }
    }

    public void doMouseClicked__on__newProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startNewProtocolAction(event);
    }

    public void doMouseEntered__on__editProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProtocolComboBox.isEnabled()) { editProtocolComboBox.showPopup(); }
    }

    public void doMouseEntered__on__newProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        newProtocolComboBox.showPopup();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloneProtocolButton() {
        return cloneProtocolButton;
    }

    public BeanFilterableComboBox<Cruise> getCruiseCombobox() {
        return cruiseCombobox;
    }

    public JLabel getCruiseLabel() {
        return cruiseLabel;
    }

    public JButton getDeleteProtocolButton() {
        return deleteProtocolButton;
    }

    public JButton getEditCatchesButton() {
        return editCatchesButton;
    }

    public JButton getEditCruiseButton() {
        return editCruiseButton;
    }

    public JButton getEditProgramButton() {
        return editProgramButton;
    }

    public JButton getEditProtocolButton() {
        return editProtocolButton;
    }

    public JComboBox getEditProtocolComboBox() {
        return editProtocolComboBox;
    }

    public JButton getExportProtocolButton() {
        return exportProtocolButton;
    }

    public SelectCruiseUIHandler getHandler() {
        return handler;
    }

    public JButton getImportProtocolButton() {
        return importProtocolButton;
    }

    public SelectCruiseUIModel getModel() {
        return model;
    }

    public JButton getNewCruiseButton() {
        return newCruiseButton;
    }

    public JButton getNewProgramButton() {
        return newProgramButton;
    }

    public JButton getNewProtocolButton() {
        return newProtocolButton;
    }

    public JComboBox getNewProtocolComboBox() {
        return newProtocolComboBox;
    }

    public BeanFilterableComboBox<Program> getProgramCombobox() {
        return programCombobox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public BeanFilterableComboBox<TuttiProtocol> getProtocolCombobox() {
        return protocolCombobox;
    }

    public JLabel getProtocolLabel() {
        return protocolLabel;
    }

    public JButton getValidateCatchesButton() {
        return validateCatchesButton;
    }

    public SwingValidator<SelectCruiseUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSelectCruiseTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(newProtocolButton);
        add(importProtocolButton);
        add(editProtocolButton);
        add(cloneProtocolButton);
        add(exportProtocolButton);
        add(deleteProtocolButton);
        add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tuttihelp.selectCruise.help"));
    }

    protected void createCloneProtocolButton() {
        $objectMap.put("cloneProtocolButton", cloneProtocolButton = new JButton());
        
        cloneProtocolButton.setName("cloneProtocolButton");
        cloneProtocolButton.setText(_("tutti.action.cloneProtocol"));
        cloneProtocolButton.setMnemonic(67);
        cloneProtocolButton.setToolTipText(_("tuttihelp.selectCruise.action.cloneProtocol.tip"));
        cloneProtocolButton.putClientProperty("help", "tuttihelp.selectCruise.action.cloneProtocol.help");
        cloneProtocolButton.putClientProperty("tuttiAction", CloneProtocolAction.class);
    }

    protected void createCruiseCombobox() {
        $objectMap.put("cruiseCombobox", cruiseCombobox = new BeanFilterableComboBox<Cruise>(this));
        
        cruiseCombobox.setName("cruiseCombobox");
        cruiseCombobox.setI18nPrefix("tutti.property.");
        cruiseCombobox.setProperty("cruise");
        cruiseCombobox.setShowReset(true);
        cruiseCombobox.putClientProperty("validatorLabel", _("tutti.label.cruise"));
    }

    protected void createCruiseLabel() {
        $objectMap.put("cruiseLabel", cruiseLabel = new JLabel());
        
        cruiseLabel.setName("cruiseLabel");
        cruiseLabel.setText(_("tutti.label.cruise"));
        cruiseLabel.setToolTipText(_("tuttihelp.selectCruise.field.cruise.tip"));
        cruiseLabel.putClientProperty("help", "tuttihelp.selectCruise.field.cruise.help");
    }

    protected void createDeleteProtocolButton() {
        $objectMap.put("deleteProtocolButton", deleteProtocolButton = new JButton());
        
        deleteProtocolButton.setName("deleteProtocolButton");
        deleteProtocolButton.setText(_("tutti.action.deleteProtocol"));
        deleteProtocolButton.setMnemonic(68);
        deleteProtocolButton.setToolTipText(_("tuttihelp.selectCruise.action.deleteProtocol.tip"));
        deleteProtocolButton.putClientProperty("help", "tuttihelp.selectCruise.action.deleteProtocol.help");
        deleteProtocolButton.putClientProperty("tuttiAction", DeleteProtocolAction.class);
    }

    protected void createEditCatchesButton() {
        $objectMap.put("editCatchesButton", editCatchesButton = new JButton());
        
        editCatchesButton.setName("editCatchesButton");
        editCatchesButton.setText(_("tutti.action.editCatches"));
        editCatchesButton.setMnemonic(69);
        editCatchesButton.setToolTipText(_("tuttihelp.selectCruise.action.editCatches.tip"));
        editCatchesButton.putClientProperty("help", "tuttihelp.selectCruise.action.editCatches.help");
        editCatchesButton.putClientProperty("tuttiAction", EditCatchesAction.class);
    }

    protected void createEditCruiseButton() {
        $objectMap.put("editCruiseButton", editCruiseButton = new JButton());
        
        editCruiseButton.setName("editCruiseButton");
        editCruiseButton.setText(_("tutti.action.editCruise"));
        editCruiseButton.setMnemonic(69);
        editCruiseButton.setToolTipText(_("tuttihelp.selectCruise.action.editCruise.tip"));
        editCruiseButton.putClientProperty("help", "tuttihelp.selectCruise.action.editCruise.help");
        editCruiseButton.putClientProperty("tuttiAction", EditCruiseAction.class);
    }

    protected void createEditProgramButton() {
        $objectMap.put("editProgramButton", editProgramButton = new JButton());
        
        editProgramButton.setName("editProgramButton");
        editProgramButton.setText(_("tutti.action.editProgram"));
        editProgramButton.setMnemonic(69);
        editProgramButton.setToolTipText(_("tuttihelp.selectCruise.action.editProgram.tip"));
        editProgramButton.putClientProperty("help", "tuttihelp.selectCruise.action.editProgram.help");
        editProgramButton.putClientProperty("tuttiAction", EditProgramAction.class);
    }

    protected void createEditProtocolButton() {
        $objectMap.put("editProtocolButton", editProtocolButton = new JButton());
        
        editProtocolButton.setName("editProtocolButton");
        editProtocolButton.setText(_("tutti.action.editProtocol"));
        editProtocolButton.setMnemonic(69);
        editProtocolButton.setToolTipText(_("tuttihelp.selectCruise.action.editProtocol.tip"));
        editProtocolButton.putClientProperty("help", "tuttihelp.selectCruise.action.editProtocol.help");
        editProtocolButton.putClientProperty("tuttiAction", EditProtocolAction.class);
    }

    protected void createEditProtocolComboBox() {
        $objectMap.put("editProtocolComboBox", editProtocolComboBox = new JComboBox());
        
        editProtocolComboBox.setName("editProtocolComboBox");
        editProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editProtocolComboBox"));
        editProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__editProtocolComboBox"));
        editProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editProtocolComboBox"));
    }

    protected void createExportProtocolButton() {
        $objectMap.put("exportProtocolButton", exportProtocolButton = new JButton());
        
        exportProtocolButton.setName("exportProtocolButton");
        exportProtocolButton.setText(_("tutti.action.exportProtocol"));
        exportProtocolButton.setMnemonic(69);
        exportProtocolButton.setToolTipText(_("tuttihelp.selectCruise.action.exportProtocol.tip"));
        exportProtocolButton.putClientProperty("help", "tuttihelp.selectCruise.action.exportProtocol.help");
        exportProtocolButton.putClientProperty("tuttiAction", ExportProtocolAction.class);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SelectCruiseUIHandler.class));
    }

    protected void createImportProtocolButton() {
        $objectMap.put("importProtocolButton", importProtocolButton = new JButton());
        
        importProtocolButton.setName("importProtocolButton");
        importProtocolButton.setText(_("tutti.action.importProtocol"));
        importProtocolButton.setMnemonic(73);
        importProtocolButton.setToolTipText(_("tuttihelp.selectCruise.action.importProtocol.tip"));
        importProtocolButton.putClientProperty("help", "tuttihelp.selectCruise.action.importProtocol.help");
        importProtocolButton.putClientProperty("tuttiAction", ImportProtocolAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SelectCruiseUIModel.class));
    }

    protected void createNewCruiseButton() {
        $objectMap.put("newCruiseButton", newCruiseButton = new JButton());
        
        newCruiseButton.setName("newCruiseButton");
        newCruiseButton.setText(_("tutti.action.newCruise"));
        newCruiseButton.setMnemonic(78);
        newCruiseButton.setToolTipText(_("tuttihelp.selectCruise.action.newCruise.tip"));
        newCruiseButton.putClientProperty("help", "tuttihelp.selectCruise.action.newCruise.help");
        newCruiseButton.putClientProperty("tuttiAction", NewCruiseAction.class);
    }

    protected void createNewProgramButton() {
        $objectMap.put("newProgramButton", newProgramButton = new JButton());
        
        newProgramButton.setName("newProgramButton");
        newProgramButton.setText(_("tutti.action.newProgram"));
        newProgramButton.setMnemonic(78);
        newProgramButton.setToolTipText(_("tuttihelp.selectCruise.action.newProgram.tip"));
        newProgramButton.putClientProperty("help", "tuttihelp.selectCruise.action.newProgram.help");
        newProgramButton.putClientProperty("tuttiAction", NewProgramAction.class);
    }

    protected void createNewProtocolButton() {
        $objectMap.put("newProtocolButton", newProtocolButton = new JButton());
        
        newProtocolButton.setName("newProtocolButton");
        newProtocolButton.setText(_("tutti.action.newProtocol"));
        newProtocolButton.setMnemonic(78);
        newProtocolButton.setToolTipText(_("tuttihelp.selectCruise.action.newProtocol.tip"));
        newProtocolButton.putClientProperty("help", "tuttihelp.selectCruise.action.newProtocol.help");
        newProtocolButton.putClientProperty("tuttiAction", NewProtocolAction.class);
    }

    protected void createNewProtocolComboBox() {
        $objectMap.put("newProtocolComboBox", newProtocolComboBox = new JComboBox());
        
        newProtocolComboBox.setName("newProtocolComboBox");
        newProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newProtocolComboBox"));
        newProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__newProtocolComboBox"));
        newProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__newProtocolComboBox"));
    }

    protected void createProgramCombobox() {
        $objectMap.put("programCombobox", programCombobox = new BeanFilterableComboBox<Program>(this));
        
        programCombobox.setName("programCombobox");
        programCombobox.setI18nPrefix("tutti.property.");
        programCombobox.setProperty("program");
        programCombobox.setShowReset(true);
        programCombobox.putClientProperty("validatorLabel", _("tutti.label.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(_("tutti.label.program"));
        programLabel.setToolTipText(_("tuttihelp.selectCruise.field.program.tip"));
        programLabel.putClientProperty("help", "tuttihelp.selectCruise.field.program.help");
    }

    protected void createProtocolCombobox() {
        $objectMap.put("protocolCombobox", protocolCombobox = new BeanFilterableComboBox<TuttiProtocol>(this));
        
        protocolCombobox.setName("protocolCombobox");
        protocolCombobox.setI18nPrefix("tutti.property.");
        protocolCombobox.setProperty("protocol");
        protocolCombobox.setShowReset(true);
        protocolCombobox.putClientProperty("validatorLabel", _("tutti.label.protocol"));
    }

    protected void createProtocolLabel() {
        $objectMap.put("protocolLabel", protocolLabel = new JLabel());
        
        protocolLabel.setName("protocolLabel");
        protocolLabel.setText(_("tutti.label.protocol"));
        protocolLabel.setToolTipText(_("tuttihelp.selectCruise.field.protocol.tip"));
        protocolLabel.putClientProperty("help", "tuttihelp.selectCruise.field.protocol.help");
    }

    protected void createValidateCatchesButton() {
        $objectMap.put("validateCatchesButton", validateCatchesButton = new JButton());
        
        validateCatchesButton.setName("validateCatchesButton");
        validateCatchesButton.setText(_("tutti.action.validateCatches"));
        validateCatchesButton.setMnemonic(86);
        validateCatchesButton.setToolTipText(_("tuttihelp.selectCruise.action.validateCatches.tip"));
        validateCatchesButton.putClientProperty("help", "tuttihelp.selectCruise.action.validateCatches.help");
        validateCatchesButton.putClientProperty("tuttiAction", ValidateCatchesAction.class);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SelectCruiseUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSelectCruiseTopPanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programCombobox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cruiseLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cruiseCombobox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(protocolLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(protocolCombobox), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(editProgramButton);
        $JPanel0.add(newProgramButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(editCruiseButton);
        $JPanel1.add(newCruiseButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(editProtocolComboBox);
        $JPanel2.add(newProtocolComboBox);
        // inline complete setup of $JPanel3
        $JPanel3.add(editCatchesButton);
        $JPanel3.add(validateCatchesButton);
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 32 property setters
        programCombobox.setBeanType(Program.class);
        cruiseCombobox.setBeanType(Cruise.class);
        protocolCombobox.setBeanType(TuttiProtocol.class);
        newProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        importProtocolButton.setIcon(SwingUtil.createActionIcon("import"));
        editProtocolButton.setIcon(SwingUtil.createActionIcon("edit"));
        cloneProtocolButton.setIcon(SwingUtil.createActionIcon("copy"));
        exportProtocolButton.setIcon(SwingUtil.createActionIcon("export"));
        deleteProtocolButton.setIcon(SwingUtil.createActionIcon("delete"));
        programLabel.setIcon(SwingUtil.createActionIcon("program"));
        programCombobox.setBean(model);
        editProgramButton.setIcon(SwingUtil.createActionIcon("edit"));
        newProgramButton.setIcon(SwingUtil.createActionIcon("add"));
        cruiseLabel.setLabelFor(cruiseCombobox);
        cruiseLabel.setIcon(SwingUtil.createActionIcon("cruise"));
        cruiseCombobox.setBean(model);
        editCruiseButton.setIcon(SwingUtil.createActionIcon("edit"));
        newCruiseButton.setIcon(SwingUtil.createActionIcon("add"));
        protocolLabel.setLabelFor(protocolCombobox);
        protocolLabel.setIcon(SwingUtil.createActionIcon("protocol"));
        protocolCombobox.setBean(model);
        editProtocolComboBox.setModel(handler.newComboModel(editProtocolButton, cloneProtocolButton, exportProtocolButton, deleteProtocolButton));
        editProtocolComboBox.setRenderer(new ActionListCellRenderer());
        newProtocolComboBox.setModel(handler.newComboModel(newProtocolButton, importProtocolButton));
        newProtocolComboBox.setRenderer(new ActionListCellRenderer());
        editCatchesButton.setIcon(SwingUtil.createActionIcon("edit"));
        validateCatchesButton.setIcon(SwingUtil.createActionIcon("validate"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, selectCruiseTopPanel, "tuttihelp.selectCruise.help");
        registerHelpId(_broker, newProtocolButton, "tuttihelp.selectCruise.action.newProtocol.help");
        registerHelpId(_broker, importProtocolButton, "tuttihelp.selectCruise.action.importProtocol.help");
        registerHelpId(_broker, editProtocolButton, "tuttihelp.selectCruise.action.editProtocol.help");
        registerHelpId(_broker, cloneProtocolButton, "tuttihelp.selectCruise.action.cloneProtocol.help");
        registerHelpId(_broker, exportProtocolButton, "tuttihelp.selectCruise.action.exportProtocol.help");
        registerHelpId(_broker, deleteProtocolButton, "tuttihelp.selectCruise.action.deleteProtocol.help");
        registerHelpId(_broker, programLabel, "tuttihelp.selectCruise.field.program.help");
        registerHelpId(_broker, editProgramButton, "tuttihelp.selectCruise.action.editProgram.help");
        registerHelpId(_broker, newProgramButton, "tuttihelp.selectCruise.action.newProgram.help");
        registerHelpId(_broker, cruiseLabel, "tuttihelp.selectCruise.field.cruise.help");
        registerHelpId(_broker, editCruiseButton, "tuttihelp.selectCruise.action.editCruise.help");
        registerHelpId(_broker, newCruiseButton, "tuttihelp.selectCruise.action.newCruise.help");
        registerHelpId(_broker, protocolLabel, "tuttihelp.selectCruise.field.protocol.help");
        registerHelpId(_broker, editCatchesButton, "tuttihelp.selectCruise.action.editCatches.help");
        registerHelpId(_broker, validateCatchesButton, "tuttihelp.selectCruise.action.validateCatches.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("selectCruiseTopPanel", selectCruiseTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createNewProtocolButton();
        createImportProtocolButton();
        createEditProtocolButton();
        createCloneProtocolButton();
        createExportProtocolButton();
        createDeleteProtocolButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createProgramLabel();
        createProgramCombobox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createEditProgramButton();
        createNewProgramButton();
        createCruiseLabel();
        createCruiseCombobox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createEditCruiseButton();
        createNewCruiseButton();
        createProtocolLabel();
        createProtocolCombobox();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createEditProtocolComboBox();
        createNewProtocolComboBox();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createEditCatchesButton();
        createValidateCatchesButton();
        // inline creation of selectCruiseTopPanel
        setName("selectCruiseTopPanel");
        setLayout(new BorderLayout());
        selectCruiseTopPanel.putClientProperty("help", "tuttihelp.selectCruise.help");
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (programCombobox != null) {
                    programCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (programCombobox != null) {
                    programCombobox.setEnabled(!programCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (programCombobox != null) {
                    programCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programCombobox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROGRAM_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProgramButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.setEnabled(!cruiseCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cruise", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cruiseCombobox.setSelectedItem(model.getCruise());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cruise", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CRUISE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCruiseButton.setEnabled(model.isProgramFound() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_CRUISE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    newCruiseButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.setEnabled(!protocolCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocol", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    protocolCombobox.setSelectedItem(model.getProtocol());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocol", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocolFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProtocolComboBox.setEnabled(model.isProtocolFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocolFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                addPropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && uiContext != null) {
                    editCatchesButton.setEnabled(model.isValid() && uiContext.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                removePropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                addPropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && uiContext != null) {
                    validateCatchesButton.setEnabled(model.isValid() && uiContext.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                removePropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
    }

}