
package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: SaveProtocolAction.java 349 2013-02-06 10:54:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/SaveProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * Saves a protocol
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class SaveProtocolAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(SaveProtocolAction.class);

    private static final long serialVersionUID = 1L;

    public SaveProtocolAction(EditProtocolUIHandler handler) {
        super(handler,
              "saveProtocol",
              "save",
              _("tutti.action.saveProtocol"),
              _("tutti.action.saveProtocol.tip"),
              true
        );
    }

    /**
     * If the event source is a TuttiScreen, then the screen changes to the source.
     * Otherwise, the screen changes to the home.
     *
     * @param event
     */
    @Override
    protected void doAction(ActionEvent event) {
        EditProtocolUIModel model = getModel();
        TuttiUIContext context = getContext();
        EditProtocolUIHandler handler = getHandler();
        PersistenceService persistenceService =
                context.getService(PersistenceService.class);

        TuttiProtocol bean = model.toBean();

        // get the species protocols from the table
        List<SpeciesProtocol> protocols = Lists.newArrayList();

        for (EditProtocolSpeciesRowModel row : handler.getTableModel().getRows()) {
            if (row.isValid()) {
                SpeciesProtocol protocol = row.toBean();
                protocols.add(protocol);
            }
        }
        bean.setSpecies(protocols);

        if (log.isDebugEnabled()) {
            log.debug("protocol id to save: " + bean.getId());
        }

        TuttiProtocol saved;

        if (TuttiEntities.isNew(bean)) {

            saved = persistenceService.createProtocol(bean);
        } else {
            saved = persistenceService.saveProtocol(bean);
        }

        context.setProtocolId(saved.getId());

        TuttiScreen nextScreen;
        if (event.getSource().getClass().isAssignableFrom(TuttiScreen.class)) {
            nextScreen = (TuttiScreen) event.getSource();
        } else {
            nextScreen = TuttiScreen.SELECT_CRUISE;
        }
        context.setScreen(nextScreen);
    }


}
