package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: RemoveSpeciesProtocolAction.java 455 2013-02-22 17:47:32Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/RemoveSpeciesProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jaxx.runtime.swing.editor.bean.BeanComboBox;

import static org.nuiton.i18n.I18n._;

/**
 * To add a new species protocol.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class RemoveSpeciesProtocolAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    private static final long serialVersionUID = 1L;

    public RemoveSpeciesProtocolAction(EditProtocolUIHandler handler) {
        super(handler,
              "removeSpeciesProtocol",
              "batch-delete",
              _("tutti.action.removeSpeciesProtocol"),
              _("tutti.action.removeSpeciesProtocol.tip"),
              false
        );
    }

    @Override
    protected void doAction(ActionEvent event) {

        EditProtocolUIHandler handler = getHandler();
        int rowIndex = handler.getTable().getSelectedRow();

        Preconditions.checkState(rowIndex != -1,
                                 "Cant remove species if no species selected");

        EditProtocolSpeciesTableModel tableModel = handler.getTableModel();

        EditProtocolSpeciesRowModel selectedRow = tableModel.getEntry(rowIndex);

        // re-add all synonym of this taxon to the species comobox
        Species species = selectedRow.getSpecies();
        BeanComboBox<Species> combo = getUI().getSpeciesComboBox();
        combo.getData().add(species);
        combo.getHandler().sortData();
        
        EditProtocolUIModel model = getModel();
        Integer taxonId = species.getReferenceTaxonId();
        List<Species> allSynonyms = Lists.newArrayList(
                model.getAllSynonyms(String.valueOf(taxonId)));
        allSynonyms.remove(species);
        model.getAllSynonyms().addAll(allSynonyms);
        // reorder the list by name, otherwise, 
        // all the species without a reftax code will be at the end
        Collections.sort(model.getAllSynonyms(), new Comparator<Species>() {

            public int compare(Species o1, Species o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
            
        });

        // remove the row from the model(do it after treating the comboBox which can be long)
        tableModel.removeRow(rowIndex);

        String speciesStr = getDecorator(Species.class, DecoratorService.SPECIES_BY_CRUISE_CODE).toString(selectedRow.getSpecies());
        sendMessage(_("tutti.flash.information.species.remove.from.protocol",
                      speciesStr));
    }

}