/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import java.util.List;

public class CreateSpeciesBatchUIModel
extends AbstractTuttiBeanUIModel<CreateSpeciesBatchUIModel, CreateSpeciesBatchUIModel> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_AVAILABLE_SPECIES = "availableSpecies";
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SORTED_UNSORTED_CATEGORY = "sortedUnsortedCategory";
    public static final String PROPERTY_BATCH_WEIGHT = "batchWeight";
    protected List<Species> availableSpecies;
    protected Species species;
    protected CaracteristicQualitativeValue sortedUnsortedCategory;
    protected Float batchWeight;
    protected final Multimap<CaracteristicQualitativeValue, Species> speciesUsed = ArrayListMultimap.create();

    public CreateSpeciesBatchUIModel() {
        super(CreateSpeciesBatchUIModel.class, null, null);
    }

    public List<Species> getAvailableSpecies() {
        return this.availableSpecies;
    }

    public void setAvailableSpecies(List<Species> availableSpecies) {
        List<Species> oldValue = this.getAvailableSpecies();
        this.availableSpecies = availableSpecies;
        this.firePropertyChange(PROPERTY_AVAILABLE_SPECIES, oldValue, availableSpecies);
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        Species oldSpecies = this.getSpecies();
        this.species = species;
        this.firePropertyChange(PROPERTY_SPECIES, oldSpecies, this.getSpecies());
    }

    public CaracteristicQualitativeValue getSortedUnsortedCategory() {
        return this.sortedUnsortedCategory;
    }

    public void setSortedUnsortedCategory(CaracteristicQualitativeValue sortedUnsortedCategory) {
        CaracteristicQualitativeValue oldSpecies = this.getSortedUnsortedCategory();
        this.sortedUnsortedCategory = sortedUnsortedCategory;
        this.firePropertyChange(PROPERTY_SORTED_UNSORTED_CATEGORY, oldSpecies, sortedUnsortedCategory);
    }

    public Float getBatchWeight() {
        return this.batchWeight;
    }

    public void setBatchWeight(Float batchWeight) {
        Float oldValue = this.getBatchWeight();
        this.batchWeight = batchWeight;
        this.firePropertyChange(PROPERTY_BATCH_WEIGHT, oldValue, batchWeight);
    }

    public Multimap<CaracteristicQualitativeValue, Species> getSpeciesUsed() {
        return this.speciesUsed;
    }

    public boolean isSpeciesAndCategoryAvailable() {
        boolean result = this.species != null && this.sortedUnsortedCategory != null && this.isSpeciesAndCategoryAvailable(this.species, this.sortedUnsortedCategory);
        return result;
    }

    public boolean isSpeciesAndCategoryAvailable(Species species, CaracteristicQualitativeValue sortedUnsortedCategory) {
        boolean result = !this.speciesUsed.containsEntry((Object)sortedUnsortedCategory, (Object)species);
        return result;
    }
}

