/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class FrequencyCellComponent
extends JButton {
    private static final long serialVersionUID = 1L;
    public static final String ROW_INDEX = "rowIndex";
    private static final Log log = LogFactory.getLog(FrequencyCellComponent.class);

    public FrequencyCellComponent() {
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        this.setIcon(SwingUtil.createActionIcon((String)"show-frequency"));
    }

    public static TableCellRenderer newRender() {
        return new FrequencyCellRenderer();
    }

    public static TableCellEditor newEditor(SpeciesBatchUI ui) {
        return new FrequencyCellEditor(ui);
    }

    public static class FrequencyCellRenderer
    implements TableCellRenderer {
        protected final FrequencyCellComponent component = new FrequencyCellComponent();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text = value == null ? " - " : String.valueOf(value);
            boolean editable = table.isCellEditable(row, column);
            this.component.setEnabled(editable);
            this.component.setText(text);
            return this.component;
        }
    }

    public static class FrequencyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        protected final FrequencyCellComponent component;
        protected final SpeciesBatchUI ui;
        protected JTable table;
        protected SpeciesBatchTableModel tableModel;
        protected ColumnIdentifier<SpeciesBatchRowModel> columnIdentifier;
        protected SpeciesBatchRowModel editRow;
        protected Integer rowIndex;
        protected Integer columnIndex;

        public FrequencyCellEditor(SpeciesBatchUI ui) {
            this.ui = ui;
            this.component = new FrequencyCellComponent();
            this.component.setBorder(new LineBorder(Color.BLACK));
            this.component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        e.consume();
                        FrequencyCellEditor.this.startEdit();
                    }
                }
            });
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                    FrequencyCellEditor.this.startEdit();
                }
            });
        }

        protected void startEdit() {
            Preconditions.checkNotNull((Object)this.tableModel, (Object)"No table model assigned.");
            Preconditions.checkNotNull((Object)((Object)this.editRow), (Object)"No editRow found.");
            if (log.isInfoEnabled()) {
                log.info((Object)("Will edit frequencies for row: " + this.rowIndex));
            }
            SpeciesBatchUIHandler handler = this.ui.getHandler();
            SpeciesFrequencyUI frequencyEditor = handler.getSpeciesFrequencyEditor();
            frequencyEditor.editBatch(this.editRow);
            handler.openDialog(this.ui, frequencyEditor, I18n._((String)"tutti.title.frequency", (Object[])new Object[0]), this.ui.getPreferredSize());
            SpeciesFrequencyUIModel frequencyModel = frequencyEditor.getModel();
            if (frequencyModel.isValid()) {
                ArrayList frequency = Lists.newArrayList();
                for (SpeciesFrequencyRowModel row : frequencyModel.getRows()) {
                    if (!row.isValid()) continue;
                    frequency.add(row);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Push back " + frequency.size() + " frequency to batch " + (Object)((Object)frequencyModel.getBatch())));
                }
                this.editRow.setFrequency(frequency);
                handler.updateTotalFromFrequencies(this.editRow);
            }
            frequencyEditor.editBatch(null);
            int r = this.rowIndex;
            int c = this.columnIndex;
            this.stopCellEditing();
            AbstractSelectTableAction.doSelectCell(this.table, r, c);
            this.table.requestFocus();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.tableModel == null) {
                this.tableModel = (SpeciesBatchTableModel)table.getModel();
                this.table = table;
                this.columnIdentifier = this.tableModel.getPropertyName(column);
            }
            String text = value == null ? " - " : String.valueOf(value);
            this.component.setText(text);
            this.rowIndex = row;
            this.columnIndex = column;
            this.editRow = (SpeciesBatchRowModel)((Object)this.tableModel.getEntry(row));
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            Preconditions.checkNotNull((Object)((Object)this.editRow), (Object)"No editRow found in editor.");
            Float result = this.columnIdentifier == SpeciesBatchTableModel.COMPUTED_NUMBER ? this.editRow.getComputedNumber() : this.editRow.getComputedWeight();
            if (log.isInfoEnabled()) {
                log.info((Object)("editor value (" + this.columnIdentifier + "): " + result));
            }
            return result;
        }

        @Override
        public boolean stopCellEditing() {
            boolean b = super.stopCellEditing();
            if (b) {
                this.rowIndex = null;
                this.editRow = null;
                this.columnIndex = null;
            }
            return b;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.rowIndex = null;
            this.columnIndex = null;
            this.editRow = null;
        }
    }
}

