/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategory;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategoryComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategoryType;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.TableViewMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.FrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentCellComponent;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextCellComponent;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class SpeciesBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<SpeciesBatchRowModel, SpeciesBatchUIModel> {
    private static final Log log = LogFactory.getLog(SpeciesBatchUIHandler.class);
    public static final Set<String> SAMPLING_PROPERTIES = Sets.newHashSet((Object[])new String[]{"sampleCategory", "speciesCategory", "sortedUnsortedCategory", "sizeCategory", "sexCategory", "maturityCategory", "ageCategory", "speciesCategoryWeight", "sortedUnsortedCategoryWeight", "sizeCategoryWeight", "sexCategoryWeight", "maturityCategoryWeight", "ageCategoryWeight"});
    private final SpeciesBatchUI ui;
    private SplitSpeciesBatchUI splitSpeciesBatchEditor;
    private CreateSpeciesBatchUI createSpeciesBatchEditor;
    private SpeciesFrequencyUI speciesFrequencyEditor;
    public static final String SPECIES_FREQUENCY_LENGHTS = "SPECIES_FREQUENCY_LENGHTS";

    public SpeciesBatchUIHandler(TuttiUI<?, ?> parentUi, SpeciesBatchUI ui) {
        super(parentUi, "speciesToConfirm", "speciesCategory", "speciesCategoryWeight", "sortedUnsortedCategory", "sortedUnsortedCategoryWeight", "sizeCategory", "sizeCategoryWeight", "sexCategory", "sexCategoryWeight", "maturityCategory", "maturityCategoryWeight", "ageCategory", "ageCategoryWeight", "weight", "number", "comment", "attachments", "frequency");
        this.ui = ui;
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        SpeciesBatchUIModel model = this.getModel();
        ArrayList availableSpecies = Lists.newArrayList(model.getAllSpecies());
        if (empty) {
            rows = null;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get species batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew((IdAware)bean)) {
                HashSet speciesUsed = Sets.newHashSet();
                List catches = this.persistenceService.getAllRootSpeciesBatch(bean.getId());
                for (SpeciesBatch aBatch : catches) {
                    Preconditions.checkState((aBatch.getSampleCategoryType() == SampleCategoryEnum.species ? 1 : 0) != 0, (Object)("Root species batch must be a species sample category but was:" + aBatch.getSampleCategoryType()));
                    SpeciesBatchRowModel rootRow = this.loadSpeciesBatch(aBatch, null, rows);
                    speciesUsed.add(rootRow.getSpeciesCategoryValue());
                }
                availableSpecies.removeAll(speciesUsed);
            }
        }
        model.setAvailableSpecies(availableSpecies);
        model.setRows(rows);
        this.recomputeBatchActionEnable();
    }

    protected SpeciesBatchTableModel getTableModel() {
        return (SpeciesBatchTableModel)this.getTable().getModel();
    }

    @Override
    protected JXTable getTable() {
        return this.ui.getTable();
    }

    @Override
    protected boolean isRowValid(SpeciesBatchRowModel row) {
        boolean result = !row.getSpeciesCategory().isEmpty() && row.getSpeciesCategory().isValid();
        result &= row.getSortedUnsortedCategory().isEmptyOrValid();
        result &= row.getSizeCategory().isEmptyOrValid();
        result &= row.getSexCategory().isEmptyOrValid();
        result &= row.getMaturityCategory().isEmptyOrValid();
        return result &= row.getAgeCategory().isEmptyOrValid();
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        if (SAMPLING_PROPERTIES.contains(propertyName) || "weight".equals(propertyName)) {
            this.recomputeRowValidState(row);
            this.recomputeTotalUnsortedWeight();
        }
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesBatchRowModel> rowMonitor, SpeciesBatchRowModel row) {
        if (row.isValid()) {
            if (rowMonitor.wasModified()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Row " + (Object)((Object)row) + " was modified, will save it"));
                }
                this.showInformationMessage("[ Captures - Esp\u00e8ces ] Sauvegarde des modifications de " + (Object)((Object)row) + '.');
                this.saveRow(row);
                rowMonitor.clearModified();
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Will not remove not valid speciesBatch: " + row.getId()));
        }
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, SpeciesBatchRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, SpeciesBatchRowModel oldRow, int newRowIndex, SpeciesBatchRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected SpeciesBatchUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("beforeInit: " + this.ui));
        }
        EditCatchesUIModel catchesUIModel = this.ui.getContextValue(EditCatchesUIModel.class);
        SpeciesBatchUIModel model = new SpeciesBatchUIModel(catchesUIModel);
        model.setTableViewMode(TableViewMode.ALL);
        this.ui.setContextValue(model);
        PersistenceService service = this.context.getService(PersistenceService.class);
        List lengthCaracterics = service.getAllSpeciesLengthStepCaracteristic();
        this.ui.setContextValue(lengthCaracterics, SPECIES_FREQUENCY_LENGHTS);
    }

    @Override
    public void afterInitUI() {
        ArrayList allSpecies;
        ArrayList samplingOrder;
        if (log.isInfoEnabled()) {
            log.info((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        TuttiProtocol protocol = this.ui.getContextValue(TuttiProtocol.class);
        HashMultimap speciesSampleCategories = HashMultimap.create();
        if (protocol != null) {
            List sampleCategoryOrder = protocol.getSampleCategoryOrder();
            samplingOrder = Lists.newArrayList();
            for (SampleCategoryEnum sampleCategoryEnum : sampleCategoryOrder) {
                SampleCategoryType sampleCategoryType = SampleCategoryType.valueOf(sampleCategoryEnum);
                samplingOrder.add(sampleCategoryType);
            }
            allSpecies = Lists.newArrayList();
            List protocolSpecies = protocol.getSpecies();
            for (SpeciesProtocol protocolSpecy : protocolSpecies) {
                Species species = this.persistenceService.getSpecies(protocolSpecy.getSpeciesId());
                allSpecies.add(species);
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.species);
                if (protocolSpecy.isSortedUnsortedEnabled()) {
                    speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.sortedUnsorted);
                }
                if (protocolSpecy.isSizeEnabled()) {
                    speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.size);
                }
                if (protocolSpecy.isSexEnabled()) {
                    speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.sex);
                }
                if (protocolSpecy.isMaturityEnabled()) {
                    speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.maturity);
                }
                if (!protocolSpecy.isAgeEnabled()) continue;
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.age);
            }
        } else {
            samplingOrder = Lists.newArrayList((Object[])new SampleCategoryType[]{SampleCategoryType.sortedUnsorted, SampleCategoryType.size, SampleCategoryType.sex, SampleCategoryType.maturity, SampleCategoryType.age});
            allSpecies = Lists.newArrayList((Iterable)this.persistenceService.getAllSpecies());
            for (Species species : allSpecies) {
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.species);
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.sortedUnsorted);
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.size);
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.sex);
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.maturity);
                speciesSampleCategories.put((Object)species, (Object)SampleCategoryType.age);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use sampling order: " + samplingOrder));
            log.info((Object)("Will use " + allSpecies.size() + " species."));
        }
        this.getModel().setSamplingOrder(samplingOrder);
        this.getModel().setAllSpecies(allSpecies);
        JXTable table = this.getTable();
        TableCellRenderer defaultRenderer = table.getDefaultRenderer(Object.class);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<CaracteristicQualitativeValue> caracteristicDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SPECIES_CATEGORY, this.getDecorator(Species.class, null), defaultRenderer);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SORTED_UNSORTED_CATEGORY, caracteristicDecorator, defaultRenderer);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SIZE_CATEGORY, caracteristicDecorator, defaultRenderer);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SEX_CATEGORY, caracteristicDecorator, defaultRenderer);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.MATURITY_CATEGORY, caracteristicDecorator, defaultRenderer);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.AGE_CATEGORY, this.getDecorator(Float.class, null), defaultRenderer);
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}.\\d{0,3}");
        this.addColumnToModel((TableColumnModel)columnModel, FrequencyCellComponent.newEditor(this.ui), FrequencyCellComponent.newRender(), SpeciesBatchTableModel.COMPUTED_WEIGHT);
        this.addColumnToModel((TableColumnModel)columnModel, FrequencyCellComponent.newEditor(this.ui), FrequencyCellComponent.newRender(), SpeciesBatchTableModel.COMPUTED_NUMBER);
        this.addColumnToModel((TableColumnModel)columnModel, LongTextCellComponent.newEditor(this.ui.getLongTextEditor()), LongTextCellComponent.newRender(I18n.n_((String)"tutti.tooltip.comment.none", (Object[])new Object[0])), SpeciesBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellComponent.newEditor(this.ui.getAttachmentEditor()), AttachmentCellComponent.newRender(this.getDecorator(Attachment.class, null), I18n.n_((String)"tutti.tooltip.attachment.none", (Object[])new Object[0])), SpeciesBatchTableModel.ATTACHMENTS);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        SpeciesBatchTableModel tableModel = new SpeciesBatchTableModel((TableColumnModel)columnModel, (Multimap<Species, SampleCategoryType>)speciesSampleCategories);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModel)columnModel, tableModel);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Closing: " + this.ui));
        }
        if (this.splitSpeciesBatchEditor != null) {
            this.getContext().getSwingSession().add((Component)this.splitSpeciesBatchEditor);
            this.closeUI(this.splitSpeciesBatchEditor);
        }
        if (this.createSpeciesBatchEditor != null) {
            this.getContext().getSwingSession().add((Component)this.createSpeciesBatchEditor);
            this.closeUI(this.createSpeciesBatchEditor);
        }
        if (this.speciesFrequencyEditor != null) {
            this.getContext().getSwingSession().add((Component)this.speciesFrequencyEditor);
            this.closeUI(this.speciesFrequencyEditor);
        }
    }

    public void createSpeciesBatch() {
        CreateSpeciesBatchUI createBatchEditor = this.getCreateSpeciesBatchEditor();
        createBatchEditor.getHandler().openUI(this.getModel());
        this.openDialog(this.ui, createBatchEditor, I18n._((String)"tutti.title.createBatch", (Object[])new Object[0]), this.ui.getPreferredSize());
        CreateSpeciesBatchUIModel createModel = createBatchEditor.getModel();
        if (createModel.isValid()) {
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel newRow = tableModel.createNewRow();
            SampleCategory<Species> speciesCategory = newRow.getSpeciesCategory();
            Species species = createModel.getSpecies();
            speciesCategory.setCategoryValue(species);
            speciesCategory.setCategoryWeight(createModel.getBatchWeight());
            newRow.setSampleCategory(speciesCategory);
            this.recomputeRowValidState(newRow);
            tableModel.addNewRow(newRow);
            this.saveRow(newRow);
            this.getModel().getAvailableSpecies().remove(species);
        }
        createBatchEditor.getHandler().openUI(null);
        this.recomputeBatchActionEnable();
    }

    public void splitSpeciesBatch() {
        JXTable table = this.getTable();
        int rowIndex = table.getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant split batch if no batch selected");
        SpeciesBatchTableModel tableModel = this.getTableModel();
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)((Object)tableModel.getEntry(rowIndex));
        if (log.isInfoEnabled()) {
            log.info((Object)("Open split batch ui for row [" + rowIndex + ']'));
        }
        SplitSpeciesBatchUI splitBatchEditor = this.getSplitSpeciesBatchEditor();
        splitBatchEditor.getHandler().editBatch(parentBatch);
        this.openDialog(this.ui, splitBatchEditor, I18n._((String)"tutti.title.splitBatch", (Object[])new Object[0]), this.ui.getPreferredSize());
        SplitSpeciesBatchUIModel splitModel = splitBatchEditor.getModel();
        if (splitModel.isValid()) {
            int insertRow = rowIndex;
            SampleCategoryType selectedCategory = splitModel.getSelectedCategory();
            SampleCategoryEnum sampleCategoryEnum = selectedCategory.getType();
            ArrayList newBatches = Lists.newArrayList();
            for (SplitSpeciesBatchRowModel row : splitModel.getRows()) {
                if (!row.isValid()) continue;
                SpeciesBatchRowModel newBatch = tableModel.createNewRow();
                this.loadBatchRow(parentBatch, newBatch, sampleCategoryEnum, row.getCategoryValue(), row.getWeight());
                this.recomputeRowValidState(newBatch);
                newBatches.add(newBatch);
                tableModel.addNewRow(++insertRow, newBatch);
            }
            parentBatch.setBatchChilds(newBatches);
            this.saveRows(newBatches);
        }
        splitBatchEditor.getHandler().editBatch(null);
        this.recomputeBatchActionEnable();
    }

    public void removeSpeciesSubBatch() {
        JXTable table = this.getTable();
        int rowIndex = table.getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove sub batch if no batch selected");
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)((Object)this.getTableModel().getEntry(rowIndex));
        Preconditions.checkState((!TuttiEntities.isNew((IdAware)parentBatch) ? 1 : 0) != 0, (Object)"Can't remove sub batch if batch is not persisted");
        HashSet rowToRemove = Sets.newHashSet();
        this.collectChilds(parentBatch, rowToRemove);
        this.getModel().getRows().removeAll(rowToRemove);
        parentBatch.setBatchChilds(null);
        this.persistenceService.deleteSpeciesSubBatch(parentBatch.getId());
        this.getTableModel().fireTableDataChanged();
        AbstractSelectTableAction.doSelectCell((JTable)table, rowIndex, 0);
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }

    public SplitSpeciesBatchUI getSplitSpeciesBatchEditor() {
        if (this.splitSpeciesBatchEditor == null) {
            this.splitSpeciesBatchEditor = new SplitSpeciesBatchUI(this.ui);
        }
        return this.splitSpeciesBatchEditor;
    }

    public CreateSpeciesBatchUI getCreateSpeciesBatchEditor() {
        if (this.createSpeciesBatchEditor == null) {
            this.createSpeciesBatchEditor = new CreateSpeciesBatchUI(this.ui);
        }
        return this.createSpeciesBatchEditor;
    }

    public SpeciesFrequencyUI getSpeciesFrequencyEditor() {
        if (this.speciesFrequencyEditor == null) {
            this.speciesFrequencyEditor = new SpeciesFrequencyUI(this.ui);
        }
        return this.speciesFrequencyEditor;
    }

    public void updateTotalFromFrequencies(SpeciesBatchRowModel row) {
        Float totalNumber = null;
        Float totalWeight = null;
        List<SpeciesFrequencyRowModel> frequency = row.getFrequency();
        if (CollectionUtils.isNotEmpty(frequency)) {
            totalNumber = Float.valueOf(0.0f);
            totalWeight = Float.valueOf(0.0f);
            for (SpeciesFrequencyRowModel frequencyModel : frequency) {
                totalNumber = Float.valueOf(totalNumber.floatValue() + (float)frequencyModel.getNumber().intValue());
                Float w = frequencyModel.getWeight();
                if (w == null) {
                    totalWeight = null;
                    continue;
                }
                if (totalWeight == null) continue;
                totalWeight = Float.valueOf(totalWeight.floatValue() + w.floatValue());
            }
        }
        row.setComputedNumber(totalNumber);
        row.setComputedWeight(totalWeight);
    }

    protected void saveRows(Iterable<SpeciesBatchRowModel> rows) {
        for (SpeciesBatchRowModel row : rows) {
            this.saveRow(row);
        }
    }

    protected void saveRow(SpeciesBatchRowModel row) {
        FishingOperation fishingOperation = this.getModel().getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        SampleCategory<?> sampleCategory = row.getSampleCategory();
        Preconditions.checkNotNull(sampleCategory);
        Preconditions.checkNotNull((Object)((Object)sampleCategory.getCategoryType()));
        Preconditions.checkNotNull(sampleCategory.getCategoryValue());
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryWeight());
        SpeciesBatch catchBean = (SpeciesBatch)row.toBean();
        catchBean.setFishingOperation(fishingOperation);
        catchBean.setSampleCategoryType(sampleCategory.getCategoryType().getType());
        catchBean.setSampleCategoryValue(sampleCategory.getCategoryValue());
        catchBean.setSampleCategoryWeight(sampleCategory.getCategoryWeight());
        if (TuttiEntities.isNew((IdAware)catchBean)) {
            SpeciesBatchRowModel batchParent = row.getBatchParent();
            String parentBatchId = null;
            if (batchParent != null) {
                parentBatchId = batchParent.getId();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Persist new species batch with parentId: " + parentBatchId));
            }
            catchBean = this.persistenceService.createSpeciesBatch(catchBean, parentBatchId);
            row.setId(catchBean.getId());
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Persist existing species batch: " + catchBean.getId()));
            }
            this.persistenceService.saveSpeciesBatch(catchBean);
        }
        List<SpeciesFrequencyRowModel> frequencyRows = row.getFrequency();
        List frequency = SpeciesFrequencyRowModel.toBeans(frequencyRows, catchBean);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save " + frequency.size() + " frequencies."));
        }
        frequency = this.persistenceService.saveSpeciesBatchFrequency(catchBean.getId(), frequency);
        frequencyRows = SpeciesFrequencyRowModel.fromBeans(frequency);
        row.setFrequency(frequencyRows);
    }

    protected void recomputeTotalUnsortedWeight() {
        Float totalHorsVrac = Float.valueOf(0.0f);
        Float totalVrac = Float.valueOf(0.0f);
        for (SpeciesBatchRowModel batch : this.getModel().getRows()) {
            Float weight;
            CaracteristicQualitativeValue vracHorsVrac = batch.getSortedUnsortedCategoryValue();
            if (vracHorsVrac == null) continue;
            boolean unsorted = "unsorted".equals(vracHorsVrac.getName());
            if (unsorted) {
                weight = batch.getWeight();
                if (weight == null) continue;
                totalHorsVrac = Float.valueOf(totalHorsVrac.floatValue() + weight.floatValue());
                continue;
            }
            weight = batch.getWeight();
            if (weight == null) continue;
            totalVrac = Float.valueOf(totalVrac.floatValue() + weight.floatValue());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("New total vrac / hors vrac: " + totalVrac + " / " + totalHorsVrac));
        }
        this.getModel().setSpeciesTotalUnsortedWeight(totalHorsVrac);
    }

    protected void recomputeBatchActionEnable() {
        int rowIndex = this.getTable().getSelectedRow();
        boolean enableAdd = CollectionUtils.isNotEmpty(this.getModel().getAvailableSpecies());
        boolean enableSplit = false;
        boolean enableRemove = false;
        if (rowIndex != -1) {
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)((Object)this.getTableModel().getEntry(rowIndex));
            if (row.isValid()) {
                enableSplit = true;
                enableRemove = true;
            }
            if (enableSplit) {
                enableSplit = row.isBatchLeaf();
            }
            if (enableRemove) {
                enableRemove = !row.isBatchLeaf();
            }
        }
        this.getModel().setCreateSpeciesBatchEnabled(enableAdd);
        this.getModel().setSplitSpeciesBatchEnabled(enableSplit);
        this.getModel().setRemoveSpeciesSubBatchEnabled(enableRemove);
    }

    protected void collectChilds(SpeciesBatchRowModel row, Set<SpeciesBatchRowModel> collectedRows) {
        if (!row.isBatchLeaf()) {
            for (SpeciesBatchRowModel batchChild : row.getBatchChild()) {
                collectedRows.add(batchChild);
                this.collectChilds(batchChild, collectedRows);
            }
        }
    }

    protected SpeciesBatchRowModel loadSpeciesBatch(SpeciesBatch aBatch, SpeciesBatchRowModel parentRow, List<SpeciesBatchRowModel> rows) {
        List frequencies = this.persistenceService.getAllSpeciesBatchFrequency(aBatch.getId());
        SpeciesBatchRowModel newRow = new SpeciesBatchRowModel(aBatch, frequencies);
        SampleCategoryEnum sampleCategoryEnum = aBatch.getSampleCategoryType();
        Preconditions.checkNotNull((Object)sampleCategoryEnum, (Object)("Can't have a batch with no sample category, but was: " + aBatch));
        this.loadBatchRow(parentRow, newRow, sampleCategoryEnum, aBatch.getSampleCategoryValue(), aBatch.getSampleCategoryWeight());
        rows.add(newRow);
        if (!aBatch.isChildBatchsEmpty()) {
            ArrayList batchChilds = Lists.newArrayListWithCapacity((int)aBatch.sizeChildBatchs());
            for (SpeciesBatch childBatch : aBatch.getChildBatchs()) {
                SpeciesBatchRowModel childRow = this.loadSpeciesBatch(childBatch, newRow, rows);
                batchChilds.add(childRow);
            }
            newRow.setBatchChilds(batchChilds);
        }
        return newRow;
    }

    protected void loadBatchRow(SpeciesBatchRowModel parentRow, SpeciesBatchRowModel newRow, SampleCategoryEnum sampleCategoryEnum, Serializable categoryValue, Float categoryWeight) {
        SampleCategory<?> sampleCategory = newRow.getSampleCategory(sampleCategoryEnum);
        sampleCategory.setCategoryValue(categoryValue);
        sampleCategory.setCategoryWeight(categoryWeight);
        newRow.setSampleCategory(sampleCategory);
        if (parentRow != null) {
            newRow.setSpeciesToConfirm(parentRow.getSpeciesToConfirm());
            newRow.setBatchParent(parentRow);
            if (sampleCategoryEnum != SampleCategoryEnum.species) {
                newRow.setSpeciesCategory(parentRow.getSpeciesCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.sortedUnsorted) {
                newRow.setSortedUnsortedCategory(parentRow.getSortedUnsortedCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.size) {
                newRow.setSizeCategory(parentRow.getSizeCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.sex) {
                newRow.setSexCategory(parentRow.getSexCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.maturity) {
                newRow.setMaturityCategory(parentRow.getMaturityCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.age) {
                newRow.setAgeCategory(parentRow.getAgeCategory());
            }
        }
    }

    protected <C extends Serializable> void addSampleCategoryColumnToModel(TableColumnModel columnModel, ColumnIdentifier<SpeciesBatchRowModel> columnIdentifier, Decorator<C> decorator, TableCellRenderer defaultRenderer) {
        this.addColumnToModel(columnModel, SampleCategoryComponent.newEditor(decorator), SampleCategoryComponent.newRender(defaultRenderer, decorator), columnIdentifier);
    }
}

