/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.config.TuttiConfig;
import fr.ifremer.tutti.ui.swing.util.UIMessageNotifier;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.widget.SwingSession;

public class TuttiUIContext
extends AbstractBean
implements Closeable,
UIMessageNotifier {
    private static final Log log = LogFactory.getLog(TuttiUIContext.class);
    public static final String PROPERTY_PROGRAM_ID = "programId";
    public static final String PROPERTY_CRUISE_ID = "cruiseId";
    public static final String PROPERTY_PROTOCOL_ID = "protocolId";
    public static final Set<String> ID_TO_SAVE_PROPERTIES = Sets.newHashSet((Object[])new String[]{"programId", "cruiseId", "protocolId"});
    public static final String PROPERTY_SCREEN = "screen";
    public static final String PROPERTY_CRUISE_CONTEXT_FILLED = "cruiseContextFilled";
    public static final String PROPERTY_PROTOCOL_FILLED = "protocolFilled";
    private static TuttiUIContext applicationContext;
    protected final TuttiConfig config;
    protected final TuttiServiceContext serviceContext;
    protected final SwingSession swingSession;
    protected String programId;
    protected String cruiseId;
    protected String protocolId;
    protected TuttiScreen screen;
    protected final Set<UIMessageNotifier> messageNotifiers;

    public static TuttiUIContext newContext(TuttiConfig config) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkState((applicationContext == null ? 1 : 0) != 0, (Object)"Application context was already opened!");
        applicationContext = new TuttiUIContext(config);
        return applicationContext;
    }

    protected TuttiUIContext(TuttiConfig config) {
        this.config = config;
        this.serviceContext = new TuttiServiceContext(config.getServiceConfig());
        this.swingSession = new SwingSession(this.getConfig().getUIConfigFile(), false);
        UIMessageNotifier logMessageNotifier = new UIMessageNotifier(){

            @Override
            public void showInformationMessage(String message) {
                if (log.isInfoEnabled()) {
                    log.info((Object)message);
                }
            }
        };
        this.messageNotifiers = Sets.newHashSet();
        this.addMessageNotifier(logMessageNotifier);
    }

    public <S extends TuttiService> S getService(Class<S> serviceType) {
        return (S)this.serviceContext.getService(serviceType);
    }

    public TuttiConfig getConfig() {
        return this.config;
    }

    public SwingSession getSwingSession() {
        return this.swingSession;
    }

    public String getProgramId() {
        return this.programId;
    }

    public String getCruiseId() {
        return this.cruiseId;
    }

    public String getProtocolId() {
        return this.protocolId;
    }

    public boolean isCruiseContextFilled() {
        return StringUtils.isNotBlank((CharSequence)this.programId) && StringUtils.isNotBlank((CharSequence)this.cruiseId);
    }

    public boolean isProtocolFilled() {
        return StringUtils.isNotBlank((CharSequence)this.protocolId);
    }

    public TuttiScreen getScreen() {
        return this.screen;
    }

    public void setProgramId(String programId) {
        boolean oldValue = this.isCruiseContextFilled();
        this.programId = programId;
        this.firePropertyChange(PROPERTY_PROGRAM_ID, -1, programId);
        this.firePropertyChange(PROPERTY_CRUISE_CONTEXT_FILLED, oldValue, this.isCruiseContextFilled());
    }

    public void setCruiseId(String cruiseId) {
        boolean oldValue = this.isCruiseContextFilled();
        this.cruiseId = cruiseId;
        this.firePropertyChange(PROPERTY_CRUISE_ID, -1, cruiseId);
        this.firePropertyChange(PROPERTY_CRUISE_CONTEXT_FILLED, oldValue, this.isCruiseContextFilled());
    }

    public void setProtocolId(String protocolId) {
        boolean oldValue = this.isProtocolFilled();
        this.protocolId = protocolId;
        this.firePropertyChange(PROPERTY_PROTOCOL_ID, -1, protocolId);
        this.firePropertyChange(PROPERTY_PROTOCOL_FILLED, oldValue, this.isProtocolFilled());
    }

    public void setScreen(TuttiScreen screen) {
        TuttiScreen oldValue = this.getScreen();
        this.screen = screen;
        this.firePropertyChange(PROPERTY_SCREEN, (Object)oldValue, (Object)screen);
    }

    public void open() {
        TuttiProtocol protocol;
        if (this.programId == null) {
            this.setProgramId(this.getConfig().getProgramId());
        }
        if (this.cruiseId == null) {
            this.setCruiseId(this.getConfig().getCruiseId());
        }
        if (this.protocolId == null) {
            this.setProtocolId(this.getConfig().getProtocolId());
        }
        PersistenceService persistenceService = this.getService(PersistenceService.class);
        if (this.protocolId != null && (protocol = persistenceService.getProtocol(this.protocolId)) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Remove invalid protocolId: " + this.protocolId));
            }
            this.setProtocolId(null);
        }
        if (this.programId != null) {
            Program program = persistenceService.getProgram(this.programId);
            if (program == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Remove invalid programId: " + this.programId));
                }
                this.setProgramId(null);
                this.setCruiseId(null);
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("ProgramId valid: " + this.programId));
                }
                this.setProgramId(this.programId);
                if (this.cruiseId != null) {
                    Cruise cruise = persistenceService.getCruise(this.cruiseId);
                    if (cruise != null && !cruise.getProgram().getId().equals(this.programId)) {
                        cruise = null;
                    }
                    if (cruise == null) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Remove invalid cruiseId: " + this.cruiseId));
                        }
                        this.setCruiseId(null);
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)("CruiseId valid: " + this.cruiseId));
                    }
                }
            }
        }
        this.saveContextToConfig();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ID_TO_SAVE_PROPERTIES.contains(evt.getPropertyName())) {
                    TuttiUIContext.this.saveContextToConfig();
                }
            }
        });
    }

    @Override
    public void close() {
        PropertyChangeListener[] listeners;
        this.messageNotifiers.clear();
        this.programId = null;
        this.cruiseId = null;
        this.protocolId = null;
        this.setScreen(null);
        IOUtils.closeQuietly((Closeable)this.serviceContext);
        for (PropertyChangeListener listener : listeners = this.getPropertyChangeListeners()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            this.removePropertyChangeListener(listener);
        }
    }

    protected void saveContextToConfig() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save config (programId: " + this.programId + ", cruiseId: " + this.cruiseId + ", protocolId: " + this.protocolId + ')'));
        }
        this.config.setProgramId(this.programId);
        this.config.setCruiseId(this.cruiseId);
        this.config.setProtocolId(this.protocolId);
        this.config.save();
    }

    public void addMessageNotifier(UIMessageNotifier messageNotifier) {
        this.messageNotifiers.add(messageNotifier);
    }

    @Override
    public void showInformationMessage(String message) {
        for (UIMessageNotifier messageNotifier : this.messageNotifiers) {
            messageNotifier.showInformationMessage(message);
        }
    }
}

