/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.catches;

import fr.ifremer.tutti.persistence.entities.SpeciesBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.content.catches.BenthosTabUI;
import fr.ifremer.tutti.ui.swing.content.catches.BenthosTabUIModel;
import fr.ifremer.tutti.ui.swing.content.catches.BenthosTableModel;
import fr.ifremer.tutti.ui.swing.content.catches.CatchesUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class BenthosTabUIHandler
extends AbstractTuttiUIHandler<BenthosTabUIModel> {
    private static final Log log = LogFactory.getLog(BenthosTabUIHandler.class);
    private final BenthosTabUI ui;
    private final CatchesUI parentUi;
    private final PersistenceService persistenceService;

    public BenthosTabUIHandler(CatchesUI parentUi, BenthosTabUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.parentUi = parentUi;
        this.persistenceService = this.context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        BenthosTabUIModel model = new BenthosTabUIModel();
        this.ui.setContextValue(model);
        JTable tb = new JTable();
        TableCellEditor defaultEditor = tb.getDefaultEditor(String.class);
        TableCellRenderer defaultRenderer = tb.getDefaultRenderer(Object.class);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn col = new TableColumn(0);
        JComboBox speciesEditor = new JComboBox();
        List allSpecies = this.persistenceService.getAllSpecies();
        SwingUtil.fillComboBox(speciesEditor, (Collection)allSpecies, null);
        col.setCellRenderer(this.newTableCellRender(SpeciesBean.class));
        col.setHeaderValue(I18n._((String)"tutti.table.benthos.header.speciesByCode", (Object[])new Object[0]));
        col.setIdentifier("speciesByCode");
        columnModel.addColumn(col);
        col = new TableColumn(1);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.benthos.header.weight", (Object[])new Object[0]));
        col.setIdentifier("weight");
        columnModel.addColumn(col);
        col = new TableColumn(2);
        col.setCellEditor(defaultEditor);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(I18n._((String)"tutti.table.benthos.header.number", (Object[])new Object[0]));
        col.setIdentifier("computedNumber");
        columnModel.addColumn(col);
        this.ui.setContextValue(columnModel);
        final BenthosTableModel tableModel = new BenthosTableModel(columnModel);
        this.ui.setContextValue(tableModel);
        model.addPropertyChangeListener("catches", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                tableModel.setData((List)evt.getNewValue());
            }
        });
    }

    @Override
    public void afterInitUI() {
        BenthosTabUIModel model = this.ui.getModel();
        this.initUI(this.ui);
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    protected BenthosTabUIModel getModel() {
        return this.ui.getModel();
    }

    public void selectTrait(TraitBean bean) {
        List catches;
        boolean empty = bean == null;
        BenthosTabUIModel model = this.ui.getModel();
        if (empty) {
            catches = null;
            bean = new TraitBean();
        } else {
            catches = this.persistenceService.getAllCatches(bean.getId());
        }
        model.fromBean(bean);
        model.setCatches(catches);
    }

    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Cancel edition");
        }
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Will save");
        }
    }
}

