/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.CampaignBean;
import fr.ifremer.tutti.persistence.entities.SurveyBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.config.TuttiConfig;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.widget.SwingSession;

public class TuttiUIContext
extends AbstractBean
implements Closeable {
    private static final Log log = LogFactory.getLog(TuttiUIContext.class);
    public static final String PROPERTY_SURVEY_ID = "surveyId";
    public static final String PROPERTY_CAMPAIGN_ID = "campaignId";
    public static final String PROPERTY_SCREEN = "screen";
    public static final String PROPERTY_CAMPAIGN_CONTEXT_FILLED = "campaignContextFilled";
    private static TuttiUIContext applicationContext;
    protected final TuttiConfig config;
    protected final TuttiServiceContext serviceContext;
    protected final SwingSession swingSession;
    protected String surveyId;
    protected String campaignId;
    protected TuttiScreen screen;

    public static TuttiUIContext newContext(TuttiConfig config) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkState((applicationContext == null ? 1 : 0) != 0, (Object)"Application context was already opened!");
        applicationContext = new TuttiUIContext(config);
        return applicationContext;
    }

    protected TuttiUIContext(TuttiConfig config) {
        this.config = config;
        this.serviceContext = new TuttiServiceContext(config.getServiceConfig());
        this.swingSession = new SwingSession(this.getConfig().getUIConfigFile(), false);
    }

    public <S extends TuttiService> S getService(Class<S> serviceType) {
        return (S)this.serviceContext.getService(serviceType);
    }

    public TuttiConfig getConfig() {
        return this.config;
    }

    public SwingSession getSwingSession() {
        return this.swingSession;
    }

    public String getSurveyId() {
        return this.surveyId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public boolean isCampaignContextFilled() {
        return StringUtils.isNotBlank((CharSequence)this.surveyId) && StringUtils.isNotBlank((CharSequence)this.campaignId);
    }

    public TuttiScreen getScreen() {
        return this.screen;
    }

    public void setSurveyId(String surveyId) {
        boolean oldValue = this.isCampaignContextFilled();
        this.surveyId = surveyId;
        this.firePropertyChange(PROPERTY_SURVEY_ID, null, surveyId);
        this.firePropertyChange(PROPERTY_CAMPAIGN_CONTEXT_FILLED, oldValue, this.isCampaignContextFilled());
    }

    public void setCampaignId(String campaignId) {
        boolean oldValue = this.isCampaignContextFilled();
        this.campaignId = campaignId;
        this.firePropertyChange(PROPERTY_CAMPAIGN_ID, null, campaignId);
        this.firePropertyChange(PROPERTY_CAMPAIGN_CONTEXT_FILLED, oldValue, this.isCampaignContextFilled());
    }

    public void setScreen(TuttiScreen screen) {
        TuttiScreen oldValue = this.getScreen();
        this.screen = screen;
        this.firePropertyChange(PROPERTY_SCREEN, (Object)oldValue, (Object)screen);
    }

    public void open() {
        this.serviceContext.open();
        if (this.surveyId == null) {
            this.setSurveyId(this.getConfig().getSurveyId());
        }
        if (this.campaignId == null) {
            this.setCampaignId(this.getConfig().getCampaignId());
        }
        PersistenceService persistenceService = this.getService(PersistenceService.class);
        if (this.surveyId != null) {
            SurveyBean survey = persistenceService.getSurvey(this.surveyId);
            if (survey == null) {
                this.setSurveyId(null);
                this.setCampaignId(null);
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Remove invalid surveyId: " + this.surveyId));
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("SurveyId valid: " + this.surveyId));
                }
                this.setSurveyId(this.surveyId);
                if (this.campaignId != null) {
                    CampaignBean campaign = persistenceService.getCampaign(this.campaignId);
                    if (campaign != null && !campaign.getSurvey().getId().equals(this.surveyId)) {
                        campaign = null;
                    }
                    if (campaign == null) {
                        this.setCampaignId(null);
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Remove invalid campaignId: " + this.campaignId));
                        }
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)("CampaignId valid: " + this.campaignId));
                    }
                }
            }
        }
        this.saveContextToConfig();
        this.addPropertyChangeListener(new PropertyChangeListener(){
            Set<String> acceptedProperties = Sets.newHashSet((Object[])new String[]{"surveyId", "campaignId"});

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.acceptedProperties.contains(evt.getPropertyName())) {
                    TuttiUIContext.this.saveContextToConfig();
                }
            }
        });
    }

    @Override
    public void close() {
        PropertyChangeListener[] listeners;
        this.surveyId = null;
        this.campaignId = null;
        IOUtils.closeQuietly((Closeable)this.serviceContext);
        for (PropertyChangeListener listener : listeners = this.getPropertyChangeListeners()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            this.removePropertyChangeListener(listener);
        }
    }

    protected void saveContextToConfig() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save config (surveyId: " + this.surveyId + ", campaignId: " + this.campaignId + ")"));
        }
        this.config.setSurveyId(this.surveyId);
        this.config.setCampaignId(this.campaignId);
        this.config.save();
    }
}

