/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity.model;

import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class FactorCardinalityTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7739699364084480516L;
    private static Log log = LogFactory.getLog(FactorCardinalityTableModel.class);
    public static final String[] COLUMN_NAMES = new String[]{I18n.t((String)"isisfish.sensitivity.factor", (Object[])new Object[0]), I18n.t((String)"isisfish.sensitivity.increment", (Object[])new Object[0])};
    protected List<Factor> factors;

    public FactorCardinalityTableModel() {
        this(null);
    }

    public FactorCardinalityTableModel(List<Factor> factors) {
        this.factors = factors;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        int count = 0;
        if (this.factors != null) {
            count = this.factors.size();
        }
        return count;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        Factor factor = this.factors.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = factor.getName();
                break;
            }
            case 1: {
                result = factor.getCardinality();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No such column " + columnIndex);
            }
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class result;
        switch (columnIndex) {
            case 0: {
                result = String.class;
                break;
            }
            case 1: {
                result = Integer.class;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("No such column " + columnIndex);
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cell edition (column " + columnIndex + ") = " + value));
        }
        Factor factor = this.factors.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                Integer iValue = (Integer)value;
                factor.setCardinality(iValue);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Can't edit column " + columnIndex);
            }
        }
    }
}

