/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.result;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import fr.ifremer.isisfish.util.Doc;
import java.awt.Component;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.nuiton.i18n.I18n;

public class ResultListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, String> docForValue = new HashMap<String, String>();

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String resultName = (String)value;
        c.setText(resultName);
        String tooltip = this.docForValue.get(resultName);
        if (tooltip == null) {
            try {
                Field[] fields;
                ScriptStorage storage = ScriptStorage.getScript("ResultName.java", new CodeSourceStorage.Location[0]);
                Class resultNameClass = storage.getCodeClass();
                for (Field f : fields = resultNameClass.getFields()) {
                    String fieldValue = (String)f.get(null);
                    if (fieldValue == null || !fieldValue.equals(resultName)) continue;
                    Doc doc = f.getAnnotation(Doc.class);
                    tooltip = TooltipHelper.docToString(doc, new String[0]);
                }
            }
            catch (Exception e) {
                String errorTooltip = TooltipHelper.getErrorTooltip(I18n.t((String)"isisfish.error.compile.fileerror", (Object[])new Object[]{"ResultName.java"}));
                c.setToolTipText(errorTooltip);
            }
        }
        this.setToolTipText(tooltip);
        return c;
    }
}

