/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity;

import fr.ifremer.isisfish.simulator.sensitivity.Distribution;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorGroupVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FactorGroup
extends Factor {
    private static final long serialVersionUID = 1893573810633639712L;
    protected List<Factor> factors = new ArrayList<Factor>();
    protected boolean continuous;

    public FactorGroup(String name) {
        super(name);
    }

    public FactorGroup(String name, boolean continuous) {
        this(name);
        this.continuous = continuous;
    }

    public void addAllFactors(List<Factor> allFactors) {
        for (Factor factor : allFactors) {
            this.checkFactor(factor);
            this.factors.add(factor);
        }
        Collections.sort(this.factors, new FactorComparator());
    }

    public void addFactor(Factor factor) {
        this.checkFactor(factor);
        this.factors.add(factor);
        Collections.sort(this.factors, new FactorComparator());
    }

    protected void checkFactor(Factor factor) {
        if (factor.getDomain() == null) {
            throw new IllegalArgumentException("Factor domain is null");
        }
        if (this.isContinuous() && !(factor.getDomain() instanceof ContinuousDomain)) {
            throw new IllegalArgumentException("Factor type is not in same type as other factor in group");
        }
    }

    public void remove(Factor factor) {
        this.factors.remove(factor);
    }

    public void removeAll(Collection<Factor> allFactors) {
        this.factors.removeAll(allFactors);
    }

    public List<Factor> getFactors() {
        return Collections.unmodifiableList(this.factors);
    }

    public void clearFactors() {
        this.factors.clear();
    }

    public Factor get(int index) {
        return this.factors.get(index);
    }

    public int size() {
        return this.factors.size();
    }

    public int indexOf(Object o) {
        return this.factors.indexOf(o);
    }

    public boolean isDiscrete() {
        return !this.continuous;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    @Override
    public Domain getDomain() {
        Domain domain = null;
        if (this.isContinuous()) {
            domain = new ContinuousDomain(Distribution.QUNIFMM);
            domain.addDistributionParam("min", 0.0);
            domain.addDistributionParam("max", 1.0);
        } else if (this.isDiscrete()) {
            domain = this.factors.size() > 0 ? this.factors.get(0).getDomain() : new DiscreteDomain();
        }
        return domain;
    }

    public void accept(FactorGroupVisitor visitor) {
        visitor.start(this);
        for (Factor factor : this.factors) {
            visitor.visit(this, factor);
        }
        visitor.end(this);
    }

    @Override
    public String toString() {
        return "FactorGroup(" + this.name + ")";
    }

    @Override
    public void setValueForIdentifier(Object valueIdentifier) {
        this.identifier = valueIdentifier;
        for (Factor factor : this.factors) {
            factor.setValueForIdentifier(valueIdentifier);
        }
    }

    @Override
    public Object getDisplayedValue() {
        return this.identifier;
    }

    @Override
    public Object clone() {
        FactorGroup f = (FactorGroup)super.clone();
        f.factors = new ArrayList<Factor>(this.factors.size());
        for (Factor subFactor : this.factors) {
            f.factors.add((Factor)subFactor.clone());
        }
        return f;
    }

    protected static class FactorComparator
    implements Comparator<Factor> {
        protected FactorComparator() {
        }

        @Override
        public int compare(Factor o1, Factor o2) {
            int result = 1;
            if (o1 instanceof FactorGroup) {
                result = o2 instanceof FactorGroup ? o1.getName().compareTo(o2.getName()) : -1;
            } else if (o2 != null) {
                result = o1.getName().compareTo(o2.getName());
            }
            return result;
        }
    }
}

