/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.types.TimeUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class VesselTypeAbstract
extends TopiaEntityAbstract
implements VesselType {
    protected String name;
    protected int length;
    protected double speed;
    protected TimeUnit maxTripDuration;
    protected double activityRange;
    protected int minCrewSize;
    protected double unitFuelCostOfTravel;
    protected String comment;
    protected Collection<TripType> tripType;
    private static final long serialVersionUID = 3762534722424748387L;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(VesselType.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(VesselType.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "length", Integer.TYPE, (Object)this.length);
        visitor.visit((TopiaEntity)this, "speed", Double.TYPE, (Object)this.speed);
        visitor.visit((TopiaEntity)this, "maxTripDuration", TimeUnit.class, (Object)this.maxTripDuration);
        visitor.visit((TopiaEntity)this, "activityRange", Double.TYPE, (Object)this.activityRange);
        visitor.visit((TopiaEntity)this, "minCrewSize", Integer.TYPE, (Object)this.minCrewSize);
        visitor.visit((TopiaEntity)this, "unitFuelCostOfTravel", Double.TYPE, (Object)this.unitFuelCostOfTravel);
        visitor.visit((TopiaEntity)this, "comment", String.class, (Object)this.comment);
        visitor.visit((TopiaEntity)this, "tripType", Collection.class, TripType.class, this.tripType);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.fireOnPreWrite("name", oldValue, name);
        this.name = name;
        this.fireOnPostWrite("name", oldValue, name);
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setLength(int length) {
        int oldValue = this.length;
        this.fireOnPreWrite("length", oldValue, length);
        this.length = length;
        this.fireOnPostWrite("length", oldValue, length);
    }

    @Override
    public int getLength() {
        int result = this.length;
        return result;
    }

    @Override
    public void setSpeed(double speed) {
        double oldValue = this.speed;
        this.fireOnPreWrite("speed", oldValue, speed);
        this.speed = speed;
        this.fireOnPostWrite("speed", oldValue, speed);
    }

    @Override
    public double getSpeed() {
        double result = this.speed;
        return result;
    }

    @Override
    public void setMaxTripDuration(TimeUnit maxTripDuration) {
        TimeUnit oldValue = this.maxTripDuration;
        this.fireOnPreWrite("maxTripDuration", oldValue, maxTripDuration);
        this.maxTripDuration = maxTripDuration;
        this.fireOnPostWrite("maxTripDuration", oldValue, maxTripDuration);
    }

    @Override
    public TimeUnit getMaxTripDuration() {
        TimeUnit result = this.maxTripDuration;
        return result;
    }

    @Override
    public void setActivityRange(double activityRange) {
        double oldValue = this.activityRange;
        this.fireOnPreWrite("activityRange", oldValue, activityRange);
        this.activityRange = activityRange;
        this.fireOnPostWrite("activityRange", oldValue, activityRange);
    }

    @Override
    public double getActivityRange() {
        double result = this.activityRange;
        return result;
    }

    @Override
    public void setMinCrewSize(int minCrewSize) {
        int oldValue = this.minCrewSize;
        this.fireOnPreWrite("minCrewSize", oldValue, minCrewSize);
        this.minCrewSize = minCrewSize;
        this.fireOnPostWrite("minCrewSize", oldValue, minCrewSize);
    }

    @Override
    public int getMinCrewSize() {
        int result = this.minCrewSize;
        return result;
    }

    @Override
    public void setUnitFuelCostOfTravel(double unitFuelCostOfTravel) {
        double oldValue = this.unitFuelCostOfTravel;
        this.fireOnPreWrite("unitFuelCostOfTravel", oldValue, unitFuelCostOfTravel);
        this.unitFuelCostOfTravel = unitFuelCostOfTravel;
        this.fireOnPostWrite("unitFuelCostOfTravel", oldValue, unitFuelCostOfTravel);
    }

    @Override
    public double getUnitFuelCostOfTravel() {
        double result = this.unitFuelCostOfTravel;
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        this.fireOnPreWrite("comment", oldValue, comment);
        this.comment = comment;
        this.fireOnPostWrite("comment", oldValue, comment);
    }

    @Override
    public String getComment() {
        String result = this.comment;
        return result;
    }

    @Override
    public void addTripType(TripType tripType) {
        this.fireOnPreWrite("tripType", null, tripType);
        if (this.tripType == null) {
            this.tripType = new ArrayList<TripType>();
        }
        this.tripType.add(tripType);
        this.fireOnPostWrite("tripType", this.tripType.size(), null, tripType);
    }

    @Override
    public void addAllTripType(Collection<TripType> tripType) {
        if (tripType == null) {
            return;
        }
        for (TripType item : tripType) {
            this.addTripType(item);
        }
    }

    @Override
    public void setTripType(Collection<TripType> tripType) {
        ArrayList<TripType> oldValue = this.tripType != null ? new ArrayList<TripType>(this.tripType) : null;
        this.fireOnPreWrite("tripType", oldValue, tripType);
        this.tripType = tripType;
        this.fireOnPostWrite("tripType", oldValue, tripType);
    }

    @Override
    public void removeTripType(TripType tripType) {
        this.fireOnPreWrite("tripType", tripType, null);
        if (this.tripType == null || !this.tripType.remove(tripType)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("tripType", this.tripType.size() + 1, tripType, null);
    }

    @Override
    public void clearTripType() {
        if (this.tripType == null) {
            return;
        }
        ArrayList<TripType> oldValue = new ArrayList<TripType>(this.tripType);
        this.fireOnPreWrite("tripType", oldValue, this.tripType);
        this.tripType.clear();
        this.fireOnPostWrite("tripType", oldValue, this.tripType);
    }

    @Override
    public Collection<TripType> getTripType() {
        return this.tripType;
    }

    @Override
    public TripType getTripTypeByTopiaId(String topiaId) {
        return (TripType)TopiaEntityHelper.getEntityByTopiaId(this.tripType, (String)topiaId);
    }

    @Override
    public int sizeTripType() {
        if (this.tripType == null) {
            return 0;
        }
        return this.tripType.size();
    }

    @Override
    public boolean isTripTypeEmpty() {
        int size = this.sizeTripType();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("length", this.length).append("speed", this.speed).append("maxTripDuration", (Object)this.maxTripDuration).append("activityRange", this.activityRange).append("minCrewSize", this.minCrewSize).append("unitFuelCostOfTravel", this.unitFuelCostOfTravel).append("comment", (Object)this.comment).append("tripType", this.tripType).toString();
        return result;
    }
}

