/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Trace;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class TraceAspect {
    protected Trace getTrace() {
        SimulationContext context = SimulationContext.get();
        Trace result = context.getTrace();
        return result;
    }

    @Before(value="execution(* scripts..*(..)) || execution(* simulators..*(..)) || execution(* rules..*(..))  || execution(* simulationplans..*(..))  || execution(* formules..*(..))")
    public void traceBeforeExecute(JoinPoint jp) {
        this.getTrace().traceBefore();
    }

    @AfterThrowing(throwing="ex", pointcut="execution(* scripts..*(..)) || execution(* simulators..*(..)) || execution(* rules..*(..))  || execution(* simulationplans..*(..))  || execution(* formules..*(..))")
    public void traceAfterThrowingExecute(JoinPoint jp, Exception ex) {
        this.traceAfterExecute(jp);
    }

    @After(value="execution(* scripts..*(..)) || execution(* simulators..*(..)) || execution(* rules..*(..))  || execution(* simulationplans..*(..))  || execution(* formules..*(..))")
    public void traceAfterExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        this.getTrace().traceAfterCall(method);
    }
}

