/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.util;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import fr.ifremer.isisfish.util.Doc;

/**
 * Tooltip common utils methods.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 12 juin 2009 $
 * By : $Author: chatellier $
 */
public class TooltipHelper {
    
    /**
     * Return HTML formatted tooltip.
     * 
     * Use optional documentation (if any) or use @Doc's class doc.
     * 
     * @param doc the doc to use
     * @param optionalDocumentations optional documentation
     * @return a string nicely print version
     */
    public static String docToString(Doc doc, String... optionalDocumentations) {
        
        String tooltip = null;
        
        if (doc != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (!ArrayUtils.isEmpty(optionalDocumentations)) {
                for (String optionalDocumentation : optionalDocumentations) {
                    sb.append("<p>" + optionalDocumentation + "</p>");
                }
            } else {
                sb.append("<p>" + doc.value() + "</p>");
            }
            if (!StringUtils.isEmpty(doc.author())) {
                sb.append("<p><b>author: </b>" + doc.author() + "</p>");
            }
            if (!StringUtils.isEmpty(doc.date())) {
                sb.append("<p><b>date: </b>" + doc.date() + "</p>");
            }
            if (!StringUtils.isEmpty(doc.version())) {
                sb.append("<p><b>version: </b>" + doc.version() + "</p>");
            }
            sb.append("</html>");
            tooltip = sb.toString();
            
            // replace all \n by <br/>
            tooltip = tooltip.replace("\n", "<br/>");
        }
        return tooltip;
    }
    
    /**
     * Format error as tootip error messsage.
     * 
     * @param errorMessage error message
     * @return html formated string
     */
    public static String getErrorTooltip(String errorMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<font color='red'><b>");
        sb.append(errorMessage);
        sb.append("</b></font>");
        sb.append("</html>");
        return sb.toString();
    }
}
