<%--
  #%L
  EchoBase :: UI
  
  $Id: configureVoyage.jsp 116 2011-11-24 23:06:43Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/webapp/WEB-INF/jsp/import/configureVoyage.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>

<script type="text/javascript">

  jQuery(document).ready(function () {

    var importMode = $('[name="importMode"]');
    importMode.change(function(event) {
      $('[class="importMode"]').hide();
      $('#' + this.value).show();
    });
    var val = $('[name="importMode"][checked="checked"]').val();
    $('[class="importMode"]').hide();
    $("#"+val).show();
  });
</script>
<title><s:text name="echobase.title.import.configuration"/></title>

<s:form id="importForm" namespace="/import" method="POST">

  <fieldset>
    <legend>
      <s:text name="echobase.legend.import.configuration.voyage"/>
    </legend>

    <s:radio key='importMode' list="importModes"
             label='%{getText("echobase.common.importMode")}'
             required="true" />

    <hr/>

    <div id='USE_EXISTING_VOYAGE' class='importMode'>
      <s:select name="voyage.topiaId" value="''"
                label='%{getText("echobase.common.voyage")}'
                list="voyages" headerKey="" headerValue=""/>
    </div>

    <div id='CREATE_NEW_VOYAGE' class='importMode'>

        <%--
         String PROPERTY_VOYAGE_NAME = "voyageName";

      String PROPERTY_VOYAGE_START_DATE = "voyageStartDate";

      String PROPERTY_VOYAGE_END_DATE = "voyageEndDate";

      String PROPERTY_VOYAGE_START_HARBOUR = "voyageStartHarbour";

      String PROPERTY_VOYAGE_END_HARBOUR = "voyageEndHarbour";

      String PROPERTY_VOYAGE_DESCRIPTION = "voyageDescription";

      String PROPERTY_DATUM = "datum";

      String PROPERTY_MISSION = "mission";

      String PROPERTY_AREA_OF_OPERATION = "areaOfOperation";

      String PROPERTY_TRANSIT = "transit";

      String PROPERTY_ECHOTYPE = "echotype";
        --%>

      <s:textfield key="voyage.voyageName"
                   label='%{getText("echobase.common.voyageName")}'/>

      <s:textfield key="voyage.voyageStartHarbour"
                   label='%{getText("echobase.common.voyageStartHarbour")}'/>

      <s:textfield key="voyage.voyageEndHarbour"
                   label='%{getText("echobase.common.voyageEndHarbour")}'/>

      <s:textfield key="voyage.datum"
                   label='%{getText("echobase.common.datum")}'/>

      <s:textarea key="voyage.voyageDescription"
                  label='%{getText("echobase.common.voyageDescription")}'/>

      <s:select name="missionId" value="''"
                label='%{getText("echobase.common.mission")}'
                list="missions" headerKey="" headerValue=""/>

      <s:select name="areaOfOperationId" value="''"
                label='%{getText("echobase.common.areaOfOperation")}'
                list="areaOfOperations" headerKey="" headerValue=""/>

      <sj:datepicker key="voyage.voyageStartDate"
                     label='%{getText("echobase.common.voyageStartDate")}'
                     value="%{new java.util.Date()}"
                     displayFormat="dd/mm/yy"/>
          
      <sj:datepicker key="voyage.voyageEndDate"
                     label='%{getText("echobase.common.voyageEndDate")}'
                     value="%{new java.util.Date()}"
                     displayFormat="dd/mm/yy"/>
    </div>

  </fieldset>
  <br/>
  <s:submit value='%{getText("echobase.action.validateImportVoyage")}'
            action="configureVoyage" />
</s:form>