package fr.ifremer.coser.ui;

/*
 * #%L
 * Coser :: UI
 * %%
 * Copyright (C) 2010 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.ui.freize.Freize;
import fr.ifremer.coser.ui.freize.FreizeModel;
import fr.ifremer.coser.ui.widgets.LookAndFeelViewMenuItem;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class CoserFrame extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PROJECT = "project";
    public static final String PROPERTY_SELECTION = "selection";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MENU_WINDOW_SELECTION_MENU_PROJECT = "menuWindowSelectionMenu.project";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$FREIZE_MODEL0_PROJECT = "$FreizeModel0.project";
    private static final String BINDING_$FREIZE_MODEL0_SELECTION = "$FreizeModel0.selection";
    private static final String BINDING_$JMENU1_ENABLED = "$JMenu1.enabled";
    private static final String BINDING_$JMENU_ITEM2_ENABLED = "$JMenuItem2.enabled";
    private static final String BINDING_$JMENU_ITEM3_ENABLED = "$JMenuItem3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVYz28bRRSemNppkpZCS0ICKU1at2oRWqf5AYWUtCGVSYxDo7g/Inxh7J3GW3Znl9nZeosQ4sQZiX8A7lyQOCBxQj1w5sAFceodIQ5cUd/srnfX8Xi9YnxY2/O975vvvZ2dN/b3f6Giy9DiQ+z7GvMoNyyi1TYPDm63HpI2v0XcNjMcbjMUvsYKqNBEU3o87nJ0oVkX9EpEr2zZlmNTQlPs9TqadPljk7gdQjhHZ/sZbdetNGJ43Xc81lONTclUv/3n78LX+pffFRDyHXB3EVJZGMVKMjlWRwVD5+g0zPQIV0xMD8EGM+gh+D0pxrZM7LofYot8ir5A43VUcjADMY7O50850Aj4vsPR8XKtykBwiaPXHjDNeMCIRZjWtl24egYYhg9BhOMErBJH4x1MdZMwji5mU7bDuBTTYba4j1DxAWaLYKrthXjCmHCJCQOGTTk6J+c0ehEJa7Jc2yXUew8zyOslUTlfc7tQSK03nvIUxkLgiwOBImQ6jpwKI3c4sSB6eiBaACJ0Vsa4KobODoWXs+EVCXyiXGsQWAAY7i74menzEyNDJVclklEtAq+vDE1+LWZekcFvSuCXLQDvG1S3u/HtEvEcXZItoTjGrRsu792JK9LUA7OXRk93F74NXbGUY4MSJmIGZ5Op7ZPRaiJmUC2q8XJ2jd+Ki/jOUeZKNvNazNyQwW9L4HQ5l+Ny9uHxMl6S82P8qgSPjK9KjM+V67b9ySbVq4SY9wzSTT1hK7Lqdg39kHBXG0ITsrWjE69JJk57Th6+21J8ZQS+KsFPWbAGhDOxHII9+nTfA7qHKTFF7ERq19q2LSI4kPy8LPkeLgj3Y14JwozPCEeLMk4IatXgrX/Ck+VwdNfWibk05Fns4weRsHcy9GpfX4OOqSUdM2lpY01UZB4MczTbHGyy+wCF7XX2SHsVggH638yZ33/+88dqr6dehrmnpaGpIwH0Oug0DrQoQ0x9KmyoHjfMyi521pu9thKcF+YlxhoRDOZgvqAxaIKubWO3AxLF8T9+eTLz8W/PoUIVTZo21qtYxO+gCd5hUAXb1H3nxs3A0Ynucbi+ILxBQzPaNt2xMCxi9Px1HXO80IKtBdbEhg91mJfUITbTmvj13zONH272ajEG3uaGhif1KH6ESgY1YU8KThjR4UF6ophyXOLpdnJIkB0bxsT7pBP10E5wNWXJlkz82Pa4wG0/2AdD2+ITy61yjII/eH6uhzksYA6HopbHycb/1yxyg5tB0p8rGOPE5xkacyM1xPBXGQrzygrncuQxTihumUTPuE+LykbyKXyT4eGCsgd1hcvKWbyu7EFd4Q1lBS3PsopO+xnFWFI2MloBfuSw1ElsiJM1ZSfqCteUFdaVFd5VVrihrLCprLCVZ/cWnThjRbyv7CKfwtMMDzvKHtQVPlBW2FVW2FNW2FdWuKOscC+XwqOM9XCQZ9uN/p7JkGnmMvJThgLOYST572aE0DNRSXUg9hMAAA==";
    private static final Log log = LogFactory.getLog(CoserFrame.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Freize freize;
    protected CoserFrameHandler handler;
    protected JPanel mainViewContent;
    protected SelectionsListMenu menuWindowSelectionMenu;
    protected ContainerRedoMenu menuWindowSelectionRedo;
    protected ContainerUndoMenu menuWindowSelectionUndo;
    protected Project project;
    protected Selection selection;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FreizeModel $FreizeModel0;
    private HomeView $HomeView0;
    private CoserFrame $JFrame0 = this;
    private JMenu $JMenu0;
    private JMenu $JMenu1;
    private JMenu $JMenu2;
    private JMenu $JMenu3;
    private JMenu $JMenu4;
    private JMenu $JMenu5;
    private JMenuBar $JMenuBar0;
    private JMenuItem $JMenuItem0;
    private JMenuItem $JMenuItem1;
    private JMenuItem $JMenuItem10;
    private JMenuItem $JMenuItem11;
    private JMenuItem $JMenuItem12;
    private JMenuItem $JMenuItem13;
    private JMenuItem $JMenuItem14;
    private JMenuItem $JMenuItem2;
    private JMenuItem $JMenuItem3;
    private JMenuItem $JMenuItem4;
    private JMenuItem $JMenuItem5;
    private JMenuItem $JMenuItem6;
    private JMenuItem $JMenuItem7;
    private JMenuItem $JMenuItem8;
    private JMenuItem $JMenuItem9;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSeparator $JSeparator2;
    private LookAndFeelViewMenuItem $LookAndFeelViewMenuItem0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoserFrame(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoserFrame(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CoserFrame() {
        $initialize();
    }

    public CoserFrame(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CoserFrame(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public CoserFrame(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CoserFrame(String param0) {
        super(param0);
        $initialize();
    }

    public CoserFrame(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JMenuItem0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showProjectCreationView();
    }

    public void doActionPerformed__on__$JMenuItem1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showProjectOpenView();
    }

    public void doActionPerformed__on__$JMenuItem10(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().switchLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__$JMenuItem11(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().switchLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__$JMenuItem12(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showCoserWebsite();
    }

    public void doActionPerformed__on__$JMenuItem13(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showCoserWebsiteSIH();
    }

    public void doActionPerformed__on__$JMenuItem14(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAboutView();
    }

    public void doActionPerformed__on__$JMenuItem2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showProjectEditView();
    }

    public void doActionPerformed__on__$JMenuItem3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().closeProject();
    }

    public void doActionPerformed__on__$JMenuItem4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().quit();
    }

    public void doActionPerformed__on__$JMenuItem5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showSummaryView();
    }

    public void doActionPerformed__on__$JMenuItem6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showControlView();
    }

    public void doActionPerformed__on__$JMenuItem7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showPublishResultView();
    }

    public void doActionPerformed__on__$JMenuItem8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showCoserConfiguration();
    }

    public void doActionPerformed__on__$JMenuItem9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showValidatorsConfiguration();
    }

    public void doPropertyChange__on__$LookAndFeelViewMenuItem0(PropertyChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().saveLookAndFeelConfiguration(event);
    }

    public void doWindowClosing__on__$JFrame0(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().quit();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Freize getFreize() {
        return freize;
    }

    public CoserFrameHandler getHandler() {
        return handler;
    }

    public JPanel getMainViewContent() {
        return mainViewContent;
    }

    public SelectionsListMenu getMenuWindowSelectionMenu() {
        return menuWindowSelectionMenu;
    }

    public ContainerRedoMenu getMenuWindowSelectionRedo() {
        return menuWindowSelectionRedo;
    }

    public ContainerUndoMenu getMenuWindowSelectionUndo() {
        return menuWindowSelectionUndo;
    }

    public Project getProject() {
        return project;
    }

    public Selection getSelection() {
        return selection;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setProject(Project project) {
        Project oldValue = this.project;
        this.project = project;
        firePropertyChange(PROPERTY_PROJECT, oldValue, project);
    }

    public void setSelection(Selection selection) {
        Selection oldValue = this.selection;
        this.selection = selection;
        firePropertyChange(PROPERTY_SELECTION, oldValue, selection);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected FreizeModel get$FreizeModel0() {
        return $FreizeModel0;
    }

    protected HomeView get$HomeView0() {
        return $HomeView0;
    }

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JMenu get$JMenu1() {
        return $JMenu1;
    }

    protected JMenu get$JMenu2() {
        return $JMenu2;
    }

    protected JMenu get$JMenu3() {
        return $JMenu3;
    }

    protected JMenu get$JMenu4() {
        return $JMenu4;
    }

    protected JMenu get$JMenu5() {
        return $JMenu5;
    }

    protected JMenuBar get$JMenuBar0() {
        return $JMenuBar0;
    }

    protected JMenuItem get$JMenuItem0() {
        return $JMenuItem0;
    }

    protected JMenuItem get$JMenuItem1() {
        return $JMenuItem1;
    }

    protected JMenuItem get$JMenuItem10() {
        return $JMenuItem10;
    }

    protected JMenuItem get$JMenuItem11() {
        return $JMenuItem11;
    }

    protected JMenuItem get$JMenuItem12() {
        return $JMenuItem12;
    }

    protected JMenuItem get$JMenuItem13() {
        return $JMenuItem13;
    }

    protected JMenuItem get$JMenuItem14() {
        return $JMenuItem14;
    }

    protected JMenuItem get$JMenuItem2() {
        return $JMenuItem2;
    }

    protected JMenuItem get$JMenuItem3() {
        return $JMenuItem3;
    }

    protected JMenuItem get$JMenuItem4() {
        return $JMenuItem4;
    }

    protected JMenuItem get$JMenuItem5() {
        return $JMenuItem5;
    }

    protected JMenuItem get$JMenuItem6() {
        return $JMenuItem6;
    }

    protected JMenuItem get$JMenuItem7() {
        return $JMenuItem7;
    }

    protected JMenuItem get$JMenuItem8() {
        return $JMenuItem8;
    }

    protected JMenuItem get$JMenuItem9() {
        return $JMenuItem9;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    protected LookAndFeelViewMenuItem get$LookAndFeelViewMenuItem0() {
        return $LookAndFeelViewMenuItem0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainViewContent() {
        if (!allComponentsCreated) {
            return;
        }
        mainViewContent.add($HomeView0);
    }

    protected void create$LookAndFeelViewMenuItem0() {
        $objectMap.put("$LookAndFeelViewMenuItem0", $LookAndFeelViewMenuItem0 = new LookAndFeelViewMenuItem());
        
        $LookAndFeelViewMenuItem0.setName("$LookAndFeelViewMenuItem0");
        $LookAndFeelViewMenuItem0.setText(t("coser.ui.mainframe.menu.view.lookandfeel"));
        $LookAndFeelViewMenuItem0.addPropertyChangeListener(JAXXUtil.getEventListener(PropertyChangeListener.class, "propertyChange", this, "doPropertyChange__on__$LookAndFeelViewMenuItem0"));
    }

    protected void createFreize() {
        $objectMap.put("freize", freize = new Freize());
        
        freize.setName("freize");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new CoserFrameHandler(this));
    }

    protected void createMainViewContent() {
        $objectMap.put("mainViewContent", mainViewContent = new JPanel());
        
        mainViewContent.setName("mainViewContent");
        mainViewContent.setLayout(new BorderLayout());
    }

    protected void createMenuWindowSelectionMenu() {
        $objectMap.put("menuWindowSelectionMenu", menuWindowSelectionMenu = new SelectionsListMenu(this));
        
        menuWindowSelectionMenu.setName("menuWindowSelectionMenu");
        menuWindowSelectionMenu.setText(t("coser.ui.mainframe.menu.data.selections"));
    }

    protected void createMenuWindowSelectionRedo() {
        $objectMap.put("menuWindowSelectionRedo", menuWindowSelectionRedo = new ContainerRedoMenu());
        
        menuWindowSelectionRedo.setName("menuWindowSelectionRedo");
        menuWindowSelectionRedo.setText(t("coser.ui.mainframe.menu.data.redo"));
    }

    protected void createMenuWindowSelectionUndo() {
        $objectMap.put("menuWindowSelectionUndo", menuWindowSelectionUndo = new ContainerUndoMenu());
        
        menuWindowSelectionUndo.setName("menuWindowSelectionUndo");
        menuWindowSelectionUndo.setText(t("coser.ui.mainframe.menu.data.undo"));
    }

    protected void createProject() {
        $objectMap.put("project", project = null);
    }

    protected void createSelection() {
        $objectMap.put("selection", selection = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JFrame0
        add(mainViewContent, BorderLayout.CENTER);
        add(freize, BorderLayout.SOUTH);
        $JFrame0.setJMenuBar($JMenuBar0);
        // inline complete setup of $JMenuBar0
        $JMenuBar0.add($JMenu0);
        $JMenuBar0.add($JMenu1);
        $JMenuBar0.add($JMenu2);
        $JMenuBar0.add($JMenu3);
        $JMenuBar0.add($JMenu4);
        $JMenuBar0.add($JMenu5);
        // inline complete setup of $JMenu0
        $JMenu0.add($JMenuItem0);
        $JMenu0.add($JMenuItem1);
        $JMenu0.add($JMenuItem2);
        $JMenu0.add($JMenuItem3);
        $JMenu0.add($JSeparator0);
        $JMenu0.add($JMenuItem4);
        // inline complete setup of $JMenu1
        $JMenu1.add($JMenuItem5);
        $JMenu1.add($JMenuItem6);
        $JMenu1.add(menuWindowSelectionMenu);
        $JMenu1.add($JSeparator1);
        $JMenu1.add(menuWindowSelectionUndo);
        $JMenu1.add(menuWindowSelectionRedo);
        // inline complete setup of $JMenu2
        $JMenu2.add($JMenuItem7);
        // inline complete setup of $JMenu3
        $JMenu3.add($JMenuItem8);
        $JMenu3.add($JMenuItem9);
        $JMenu3.add($JSeparator2);
        $JMenu3.add($JMenuItem10);
        $JMenu3.add($JMenuItem11);
        // inline complete setup of $JMenu4
        $JMenu4.add($LookAndFeelViewMenuItem0);
        // inline complete setup of $JMenu5
        $JMenu5.add($JMenuItem12);
        $JMenu5.add($JMenuItem13);
        $JMenu5.add($JMenuItem14);
        addChildrenToMainViewContent();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        setIconImage(SwingUtil.createImageIcon("logo.png").getImage());
        menuWindowSelectionUndo.setRedoMenu(menuWindowSelectionRedo);
        $JMenuItem10.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        $JMenuItem11.setIcon(SwingUtil.createActionIcon("i18n-gb"));
        $HomeView0.setHandler(getHandler());
        // late initializer
        $JFrame0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JFrame0", $JFrame0);
        createHandler();
        createProject();
        createSelection();
        // inline creation of $JMenuBar0
        $objectMap.put("$JMenuBar0", $JMenuBar0 = new JMenuBar());
        
        $JMenuBar0.setName("$JMenuBar0");
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(t("coser.ui.mainframe.menu.file"));
        // inline creation of $JMenuItem0
        $objectMap.put("$JMenuItem0", $JMenuItem0 = new JMenuItem());
        
        $JMenuItem0.setName("$JMenuItem0");
        $JMenuItem0.setText(t("coser.ui.mainframe.menu.newProject"));
        $JMenuItem0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem0"));
        // inline creation of $JMenuItem1
        $objectMap.put("$JMenuItem1", $JMenuItem1 = new JMenuItem());
        
        $JMenuItem1.setName("$JMenuItem1");
        $JMenuItem1.setText(t("coser.ui.mainframe.menu.openProject"));
        $JMenuItem1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem1"));
        // inline creation of $JMenuItem2
        $objectMap.put("$JMenuItem2", $JMenuItem2 = new JMenuItem());
        
        $JMenuItem2.setName("$JMenuItem2");
        $JMenuItem2.setText(t("coser.ui.mainframe.menu.editProject"));
        $JMenuItem2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem2"));
        // inline creation of $JMenuItem3
        $objectMap.put("$JMenuItem3", $JMenuItem3 = new JMenuItem());
        
        $JMenuItem3.setName("$JMenuItem3");
        $JMenuItem3.setText(t("coser.ui.mainframe.menu.closeProject"));
        $JMenuItem3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem3"));
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JMenuItem4
        $objectMap.put("$JMenuItem4", $JMenuItem4 = new JMenuItem());
        
        $JMenuItem4.setName("$JMenuItem4");
        $JMenuItem4.setText(t("coser.ui.mainframe.menu.quit"));
        $JMenuItem4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem4"));
        // inline creation of $JMenu1
        $objectMap.put("$JMenu1", $JMenu1 = new JMenu());
        
        $JMenu1.setName("$JMenu1");
        $JMenu1.setText(t("coser.ui.mainframe.menu.data"));
        // inline creation of $JMenuItem5
        $objectMap.put("$JMenuItem5", $JMenuItem5 = new JMenuItem());
        
        $JMenuItem5.setName("$JMenuItem5");
        $JMenuItem5.setText(t("coser.ui.mainframe.menu.data.summary"));
        $JMenuItem5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem5"));
        // inline creation of $JMenuItem6
        $objectMap.put("$JMenuItem6", $JMenuItem6 = new JMenuItem());
        
        $JMenuItem6.setName("$JMenuItem6");
        $JMenuItem6.setText(t("coser.ui.mainframe.menu.data.control"));
        $JMenuItem6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem6"));
        createMenuWindowSelectionMenu();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuWindowSelectionUndo();
        createMenuWindowSelectionRedo();
        // inline creation of $JMenu2
        $objectMap.put("$JMenu2", $JMenu2 = new JMenu());
        
        $JMenu2.setName("$JMenu2");
        $JMenu2.setText(t("coser.ui.mainframe.menu.admin"));
        // inline creation of $JMenuItem7
        $objectMap.put("$JMenuItem7", $JMenuItem7 = new JMenuItem());
        
        $JMenuItem7.setName("$JMenuItem7");
        $JMenuItem7.setText(t("coser.ui.mainframe.menu.admin.publishResult"));
        $JMenuItem7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem7"));
        // inline creation of $JMenu3
        $objectMap.put("$JMenu3", $JMenu3 = new JMenu());
        
        $JMenu3.setName("$JMenu3");
        $JMenu3.setText(t("coser.ui.mainframe.menu.options"));
        // inline creation of $JMenuItem8
        $objectMap.put("$JMenuItem8", $JMenuItem8 = new JMenuItem());
        
        $JMenuItem8.setName("$JMenuItem8");
        $JMenuItem8.setText(t("coser.ui.mainframe.menu.configuration"));
        $JMenuItem8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem8"));
        // inline creation of $JMenuItem9
        $objectMap.put("$JMenuItem9", $JMenuItem9 = new JMenuItem());
        
        $JMenuItem9.setName("$JMenuItem9");
        $JMenuItem9.setText(t("coser.ui.mainframe.menu.validators"));
        $JMenuItem9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem9"));
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        // inline creation of $JMenuItem10
        $objectMap.put("$JMenuItem10", $JMenuItem10 = new JMenuItem());
        
        $JMenuItem10.setName("$JMenuItem10");
        $JMenuItem10.setText(t("coser.ui.mainframe.menu.locale.fr"));
        $JMenuItem10.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem10"));
        // inline creation of $JMenuItem11
        $objectMap.put("$JMenuItem11", $JMenuItem11 = new JMenuItem());
        
        $JMenuItem11.setName("$JMenuItem11");
        $JMenuItem11.setText(t("coser.ui.mainframe.menu.locale.uk"));
        $JMenuItem11.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem11"));
        // inline creation of $JMenu4
        $objectMap.put("$JMenu4", $JMenu4 = new JMenu());
        
        $JMenu4.setName("$JMenu4");
        $JMenu4.setText(t("coser.ui.mainframe.menu.view"));
        create$LookAndFeelViewMenuItem0();
        // inline creation of $JMenu5
        $objectMap.put("$JMenu5", $JMenu5 = new JMenu());
        
        $JMenu5.setName("$JMenu5");
        $JMenu5.setText(t("coser.ui.mainframe.menu.help"));
        // inline creation of $JMenuItem12
        $objectMap.put("$JMenuItem12", $JMenuItem12 = new JMenuItem());
        
        $JMenuItem12.setName("$JMenuItem12");
        $JMenuItem12.setText(t("coser.ui.mainframe.menu.website"));
        $JMenuItem12.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem12"));
        // inline creation of $JMenuItem13
        $objectMap.put("$JMenuItem13", $JMenuItem13 = new JMenuItem());
        
        $JMenuItem13.setName("$JMenuItem13");
        $JMenuItem13.setText(t("coser.ui.mainframe.menu.websitesih"));
        $JMenuItem13.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem13"));
        // inline creation of $JMenuItem14
        $objectMap.put("$JMenuItem14", $JMenuItem14 = new JMenuItem());
        
        $JMenuItem14.setName("$JMenuItem14");
        $JMenuItem14.setText(t("coser.ui.mainframe.menu.about"));
        $JMenuItem14.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem14"));
        createMainViewContent();
        // inline creation of $HomeView0
        $objectMap.put("$HomeView0", $HomeView0 = new HomeView());
        
        $HomeView0.setName("$HomeView0");
        createFreize();
        // inline creation of $FreizeModel0
        $objectMap.put("$FreizeModel0", $FreizeModel0 = freize.getModel());
        // inline creation of $JFrame0
        setName("$JFrame0");
        $JFrame0.getContentPane().setLayout(new BorderLayout());
        setName("mainFrame");
        setTitle(t("coser.ui.mainview.titleempty"));
        $JFrame0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__$JFrame0"));
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM2_ENABLED, true ,"project") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem2.setEnabled(getProject() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM3_ENABLED, true ,"project") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem3.setEnabled(getProject() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU1_ENABLED, true ,"project") {
        
            @Override
            public void processDataBinding() {
                $JMenu1.setEnabled(getProject() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_WINDOW_SELECTION_MENU_PROJECT, true ,"project") {
        
            @Override
            public void processDataBinding() {
                menuWindowSelectionMenu.setProject(getProject());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$FREIZE_MODEL0_PROJECT, true ,"project") {
        
            @Override
            public void processDataBinding() {
                $FreizeModel0.setProject(getProject());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$FREIZE_MODEL0_SELECTION, true ,"selection") {
        
            @Override
            public void processDataBinding() {
                $FreizeModel0.setSelection(getSelection());
            }
        });
    }

}