/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui.project;

import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.ui.util.CoserProgressBar;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ProjectCreationView extends Table implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CUSTOM_REFERENCE_SPECIES_FILE_LABEL_ENABLED = "customReferenceSpeciesFileLabel.enabled";
    public static final String BINDING_CUSTOM_REFERENCE_SPECIES_FILE_TEXT_FIELD_ENABLED = "customReferenceSpeciesFileTextField.enabled";
    public static final String BINDING_PROJECT_AUTHOR_TEXT = "projectAuthor.text";
    public static final String BINDING_PROJECT_CATCH_FILE_TEXT = "projectCatchFile.text";
    public static final String BINDING_PROJECT_HAUL_FILE_TEXT = "projectHaulFile.text";
    public static final String BINDING_PROJECT_LENGTH_FILE_TEXT = "projectLengthFile.text";
    public static final String BINDING_PROJECT_PROJECT_NAME_TEXT = "projectProjectName.text";
    public static final String BINDING_PROJECT_STRATA_FILE_TEXT = "projectStrataFile.text";
    public static final String BINDING_REFERENCE_SPECIES_DESCRIPTION_LABEL_ENABLED = "referenceSpeciesDescriptionLabel.enabled";
    public static final String BINDING_REFERENCE_SPECIES_FILE_LABEL_ENABLED = "referenceSpeciesFileLabel.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVYz28bRRSemCZpEtKERA2NktDQuggKWidpm4IS0aauTBMcGuKoKgShjncn8UTr3WVmtjYcKoQE4gASfwLcuSBx44R64MyBC0LiL0CIA1fEm/1lrz22N5oc1vHM+7753jdvZ17y/V9omDP04gluNg3mO4LWibGz9fDh/eoJMcVdwk1GPeEyFP4M5VDuEE1YyTgX6PJhWcILEbxQdOue6xCnDb1RRuNcfGwTXiNECLSURpicFyrJ9EbT81nMmohSsX77z9+5b6xPv8sh1PRA3QqksjwI1crkTBnlqCXQDKz0GBds7ByDDEadY9A7KceKNub8HVwnH6EnaLSMRjzMgEygS9lTDjgCfNMTaDR/gKs2WRGocMQMesRInTDDdDk8fWp4zJW+G3vhZ5ERLKjrPKCk4XkBywhw1LBj2YQJdDUDx70wuA0eBcA2dMGrBDsxsIWYJozBVgfKd12L2AJtpmx+jG1qYcja4A2wz6jI54N4cJdwjo9JC97GnCD3YlGvnoK5RTSbrwTGbztUUJj+hDDw+KWAy4TdoWCBEe6N0RXZ5k24PasCXUjJCBcP5mTkWAI4m98p4yqxYbEZWTHNKDQclUELXbGr8vtyem4m2pTIBllzAs2lGA9IU5Qosa00cjx/1zX9OhQfaJhvRwgAGPGk1yVjTSFjMpKx5Yuay+TglV6rBVm83E17TUE7HdEWsTBrJRqa2JN5rYN5IUF7wmeEV4gN3+74QrgO7HzKpHBU7ft1hbLnIm5477HAA6Vd65D2QjuccIlvVyejbqrF3OgjpkycYzHYp+s9fKpATZ9CybpCyZQXHx6+PVDHjQ4dSxH4gGEqTuPJTVVF5nfgfXVtew878th8PrXdrSl1we1ij0cn1kqGs1KGlykXHafURBsb7FL6PYdwGbafRI/loypcUaSaTK4qJpcZOSJwwZik4hGTEh5fJ3AFJOdJhz/znRjpd6/gBZ+Tos+FW9+PUTJc+heEL6XDL5rp2J4rmAnkcm9I6vy6koYltqwltphd5fH6oPIIPD1IB5yLDw+3Xg+u7vNdh+oW3LIyuq6o7fWO2p415ZVMonrpWdFTtostCDqG44rfwXBVv6IqP19QG3oU+NYWGzExtJC6gqBJMlpNUquLGTpEw8yHYbizDrv7qn2YCjuqCx0dlSQMZv+bm/3tpz9+LMVtVB7WPq8MbesCob0BZz3oQqhceirsoWRCBXhNNg7RGA9e+qBFXFQIq0TTIA7WC16q0I97mNeAYnj095+fzj369RmUK6Fx6WcJy/htNCZqYFXNta2md+t2oOjZxll4TkttAo1UXWbJ9ujcJnQJeLlKHQs2+80mmLCoMCFRUh375d/Zyg+3YyOGQNh8z/CWGcPvoxHq2NQhQUcZNYvKDnLC48S33FZTqGoTh+TnohdV3ZPg+Zkq0zPyiofmYTNcfRkLaF+rviCQqwR9ESQhf/sy4Lw4kFMOfyUfn6sZLmkz5LMzfK1muKqt4TVtDSvaGta0NaxrM7yhncWGtoZb2gxb2lkUtTW8pc2wrZ3F29oa7mszvJvh1Bquy/aqTyLvacv4IIOMUeLIv+esPkI+1BaSjeHPPhoeaWvIxtBPQ1W7NrMx9NNwpO1DNoZ+GmraDCfaWegz2Fk6C+Y2eB8OT1uFn0HFJA/+HbeHqSPCF7UHWQPI/gcmQ0GOzBQAAA==";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    public static final String PROPERTY$DOCUMENT3 = "$Document3";
    public static final String PROPERTY$DOCUMENT4 = "$Document4";
    public static final String PROPERTY$DOCUMENT5 = "$Document5";
    public static final String PROPERTY$DOCUMENT6 = "$Document6";
    private static final Log log = LogFactory.getLog(ProjectCreationView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton createProjectButton;
    protected JLabel customReferenceSpeciesFileLabel;
    protected JTextField customReferenceSpeciesFileTextField;
    protected SwingValidatorMessageTableModel errorsTableModel;
    protected ProjectHandler handler;
    protected CoserProgressBar loadProgressBar;
    protected Project project;
    @ValidatorField( validatorId = "validatorProject",  propertyName = "author",  editorName = "projectAuthor")
    protected JTextField projectAuthor;
    protected JButton projectCapturesSelectButton;
    @ValidatorField( validatorId = "validatorProject",  propertyName = "catchFile",  editorName = "projectCatchFile")
    protected JTextField projectCatchFile;
    protected JTextArea projectComment;
    @ValidatorField( validatorId = "validatorProject",  propertyName = "haulFile",  editorName = "projectHaulFile")
    protected JTextField projectHaulFile;
    @ValidatorField( validatorId = "validatorProject",  propertyName = "lengthFile",  editorName = "projectLengthFile")
    protected JTextField projectLengthFile;
    protected JList projectMaps;
    protected ProjectMapsListModel projectMapsModel;
    @ValidatorField( validatorId = "validatorProject",  propertyName = "name",  editorName = "projectProjectName")
    protected JTextField projectProjectName;
    protected JButton projectSizeFileSelectButton;
    @ValidatorField( validatorId = "validatorProject",  propertyName = "strataFile",  editorName = "projectStrataFile")
    protected JTextField projectStrataFile;
    protected JButton projectStratesFileSelectButton;
    protected JButton projectTraitsFileSelectButton;
    protected JLabel referenceSpeciesDescriptionLabel;
    protected JLabel referenceSpeciesFileLabel;
    protected Table useCustomReferenceFilePanel;
    protected List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorProject")
    protected SwingValidator<Project> validatorProject;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ProjectCreationView $Table0 = this;
    private Table $Table1;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private Document $Document0;
    private JLabel $JLabel2;
    private Document $Document1;
    private JLabel $JLabel3;
    private Document $Document2;
    private JLabel $JLabel4;
    private Document $Document3;
    private JLabel $JLabel5;
    private Document $Document4;
    private JLabel $JLabel6;
    private Document $Document5;
    private JLabel $JLabel7;
    private JScrollPane $JScrollPane0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JLabel $JLabel8;
    private JScrollPane $JScrollPane1;
    private Document $Document6;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    JCheckBox customReferenceCheckBox;
    
            void $afterCompleteSetup() {
                fr.ifremer.coser.ui.widgets.ComponentTitledBorder componentBorder = 
                    new fr.ifremer.coser.ui.widgets.ComponentTitledBorder(customReferenceCheckBox, useCustomReferenceFilePanel, BorderFactory.createEtchedBorder());
                useCustomReferenceFilePanel.setBorder(componentBorder);
            }
            public JCheckBox getCustomReferenceCheckBox() {
                return customReferenceCheckBox;
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ProjectCreationView() {
        $initialize();
    }

    public ProjectCreationView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectInputFile(this, customReferenceSpeciesFileTextField);
    }

    public void doActionPerformed__on__projectCapturesSelectButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectInputFile(this, projectCatchFile);
    }

    public void doActionPerformed__on__projectTraitsFileSelectButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectInputFile(this, projectHaulFile);
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setName(projectProjectName.getText());
    }

    public void doInsertUpdate__on__$Document6(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setComment(projectComment.getText());
    }

    public void doRemoveUpdate__on__$Document6(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setComment(projectComment.getText());
    }

    public void doInsertUpdate__on__$Document5(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setHaulFile(projectHaulFile.getText());
    }

    public void doRemoveUpdate__on__$Document5(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setHaulFile(projectHaulFile.getText());
    }

    public void doInsertUpdate__on__$Document4(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setLengthFile(projectLengthFile.getText());
    }

    public void doRemoveUpdate__on__$Document4(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setLengthFile(projectLengthFile.getText());
    }

    public void doInsertUpdate__on__$Document3(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setStrataFile(projectStrataFile.getText());
    }

    public void doRemoveUpdate__on__$Document3(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setStrataFile(projectStrataFile.getText());
    }

    public void doInsertUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setCatchFile(projectCatchFile.getText());
    }

    public void doRemoveUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setCatchFile(projectCatchFile.getText());
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setAuthor(projectAuthor.getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setAuthor(projectAuthor.getText());
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getProject().setName(projectProjectName.getText());
    }

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectMapFiles(this);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().removeSelectedMapFiles(this);
    }

    public void doActionPerformed__on__createProjectButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createProject(this);
    }

    public void doActionPerformed__on__projectSizeFileSelectButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectInputFile(this, projectLengthFile);
    }

    public void doActionPerformed__on__projectStratesFileSelectButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectInputFile(this, projectStrataFile);
    }

    public void doTableChanged__on__errorsTableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        createProjectButton.setEnabled(errorsTableModel.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCreateProjectButton() {
        return createProjectButton;
    }

    public JLabel getCustomReferenceSpeciesFileLabel() {
        return customReferenceSpeciesFileLabel;
    }

    public JTextField getCustomReferenceSpeciesFileTextField() {
        return customReferenceSpeciesFileTextField;
    }

    public SwingValidatorMessageTableModel getErrorsTableModel() {
        return errorsTableModel;
    }

    public ProjectHandler getHandler() {
        return handler;
    }

    public CoserProgressBar getLoadProgressBar() {
        return loadProgressBar;
    }

    public Project getProject() {
        return project;
    }

    public JTextField getProjectAuthor() {
        return projectAuthor;
    }

    public JButton getProjectCapturesSelectButton() {
        return projectCapturesSelectButton;
    }

    public JTextField getProjectCatchFile() {
        return projectCatchFile;
    }

    public JTextArea getProjectComment() {
        return projectComment;
    }

    public JTextField getProjectHaulFile() {
        return projectHaulFile;
    }

    public JTextField getProjectLengthFile() {
        return projectLengthFile;
    }

    public JList getProjectMaps() {
        return projectMaps;
    }

    public ProjectMapsListModel getProjectMapsModel() {
        return projectMapsModel;
    }

    public JTextField getProjectProjectName() {
        return projectProjectName;
    }

    public JButton getProjectSizeFileSelectButton() {
        return projectSizeFileSelectButton;
    }

    public JTextField getProjectStrataFile() {
        return projectStrataFile;
    }

    public JButton getProjectStratesFileSelectButton() {
        return projectStratesFileSelectButton;
    }

    public JButton getProjectTraitsFileSelectButton() {
        return projectTraitsFileSelectButton;
    }

    public JLabel getReferenceSpeciesDescriptionLabel() {
        return referenceSpeciesDescriptionLabel;
    }

    public JLabel getReferenceSpeciesFileLabel() {
        return referenceSpeciesFileLabel;
    }

    public Table getUseCustomReferenceFilePanel() {
        return useCustomReferenceFilePanel;
    }

    public SwingValidator<Project> getValidatorProject() {
        return validatorProject;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void set$Document2(Document $Document2) {
        Document oldValue = this.$Document2;
        this.$Document2 = $Document2;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, $Document2);
    }

    public void set$Document3(Document $Document3) {
        Document oldValue = this.$Document3;
        this.$Document3 = $Document3;
        firePropertyChange(PROPERTY$DOCUMENT3, oldValue, $Document3);
    }

    public void set$Document4(Document $Document4) {
        Document oldValue = this.$Document4;
        this.$Document4 = $Document4;
        firePropertyChange(PROPERTY$DOCUMENT4, oldValue, $Document4);
    }

    public void set$Document5(Document $Document5) {
        Document oldValue = this.$Document5;
        this.$Document5 = $Document5;
        firePropertyChange(PROPERTY$DOCUMENT5, oldValue, $Document5);
    }

    public void set$Document6(Document $Document6) {
        Document oldValue = this.$Document6;
        this.$Document6 = $Document6;
        firePropertyChange(PROPERTY$DOCUMENT6, oldValue, $Document6);
    }

    public void setHandler(ProjectHandler handler) {
        ProjectHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Document get$Document0() {
        return $Document0;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected Document get$Document2() {
        return $Document2;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected Document get$Document3() {
        return $Document3;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected Document get$Document4() {
        return $Document4;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected Document get$Document5() {
        return $Document5;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Document get$Document6() {
        return $Document6;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToUseCustomReferenceFilePanel() {
        if (!allComponentsCreated) {
            return;
        }
        useCustomReferenceFilePanel.add(customReferenceSpeciesFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        useCustomReferenceFilePanel.add(customReferenceSpeciesFileTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        useCustomReferenceFilePanel.add($JButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidatorProject() {
        if (!allComponentsCreated) {
            return;
        }
        validatorProject.setErrorTableModel(errorsTableModel);
        validatorProject.setUiClass(ImageValidationUI.class);
        validatorProject.setBean(project);
    }

    protected void createCreateProjectButton() {
        $objectMap.put("createProjectButton", createProjectButton = new JButton());
        
        createProjectButton.setName("createProjectButton");
        createProjectButton.setText(_("coser.ui.project.createProject"));
        createProjectButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createProjectButton"));
    }

    protected void createCustomReferenceSpeciesFileLabel() {
        $objectMap.put("customReferenceSpeciesFileLabel", customReferenceSpeciesFileLabel = new JLabel());
        
        customReferenceSpeciesFileLabel.setName("customReferenceSpeciesFileLabel");
        customReferenceSpeciesFileLabel.setText(_("coser.ui.project.customReferenceSpeciesFile"));
    }

    protected void createCustomReferenceSpeciesFileTextField() {
        $objectMap.put("customReferenceSpeciesFileTextField", customReferenceSpeciesFileTextField = new JTextField());
        
        customReferenceSpeciesFileTextField.setName("customReferenceSpeciesFileTextField");
        customReferenceSpeciesFileTextField.setColumns(15);
    }

    protected void createErrorsTableModel() {
        $objectMap.put("errorsTableModel", errorsTableModel = new SwingValidatorMessageTableModel());
        
        errorsTableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorsTableModel"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createLoadProgressBar() {
        $objectMap.put("loadProgressBar", loadProgressBar = new CoserProgressBar());
        
        loadProgressBar.setName("loadProgressBar");
        loadProgressBar.setStringPainted(true);
    }

    protected void createProject() {
        $objectMap.put("project", project = new Project());
    }

    protected void createProjectAuthor() {
        $objectMap.put("projectAuthor", projectAuthor = new JTextField());
        
        projectAuthor.setName("projectAuthor");
        projectAuthor.setColumns(15);
    }

    protected void createProjectCapturesSelectButton() {
        $objectMap.put("projectCapturesSelectButton", projectCapturesSelectButton = new JButton());
        
        projectCapturesSelectButton.setName("projectCapturesSelectButton");
        projectCapturesSelectButton.setText(_("coser.ui.common.selectFile"));
        projectCapturesSelectButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__projectCapturesSelectButton"));
    }

    protected void createProjectCatchFile() {
        $objectMap.put("projectCatchFile", projectCatchFile = new JTextField());
        
        projectCatchFile.setName("projectCatchFile");
        projectCatchFile.setColumns(15);
    }

    protected void createProjectComment() {
        $objectMap.put("projectComment", projectComment = new JTextArea());
        
        projectComment.setName("projectComment");
        projectComment.setColumns(15);
        projectComment.setLineWrap(true);
        projectComment.setWrapStyleWord(true);
        projectComment.setRows(3);
    }

    protected void createProjectHaulFile() {
        $objectMap.put("projectHaulFile", projectHaulFile = new JTextField());
        
        projectHaulFile.setName("projectHaulFile");
        projectHaulFile.setColumns(15);
    }

    protected void createProjectLengthFile() {
        $objectMap.put("projectLengthFile", projectLengthFile = new JTextField());
        
        projectLengthFile.setName("projectLengthFile");
        projectLengthFile.setColumns(15);
    }

    protected void createProjectMaps() {
        $objectMap.put("projectMaps", projectMaps = new JList());
        
        projectMaps.setName("projectMaps");
    }

    protected void createProjectMapsModel() {
        $objectMap.put("projectMapsModel", projectMapsModel = new ProjectMapsListModel());
    }

    protected void createProjectProjectName() {
        $objectMap.put("projectProjectName", projectProjectName = new JTextField());
        
        projectProjectName.setName("projectProjectName");
        projectProjectName.setColumns(15);
    }

    protected void createProjectSizeFileSelectButton() {
        $objectMap.put("projectSizeFileSelectButton", projectSizeFileSelectButton = new JButton());
        
        projectSizeFileSelectButton.setName("projectSizeFileSelectButton");
        projectSizeFileSelectButton.setText(_("coser.ui.common.selectFile"));
        projectSizeFileSelectButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__projectSizeFileSelectButton"));
    }

    protected void createProjectStrataFile() {
        $objectMap.put("projectStrataFile", projectStrataFile = new JTextField());
        
        projectStrataFile.setName("projectStrataFile");
        projectStrataFile.setColumns(15);
    }

    protected void createProjectStratesFileSelectButton() {
        $objectMap.put("projectStratesFileSelectButton", projectStratesFileSelectButton = new JButton());
        
        projectStratesFileSelectButton.setName("projectStratesFileSelectButton");
        projectStratesFileSelectButton.setText(_("coser.ui.common.selectFile"));
        projectStratesFileSelectButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__projectStratesFileSelectButton"));
    }

    protected void createProjectTraitsFileSelectButton() {
        $objectMap.put("projectTraitsFileSelectButton", projectTraitsFileSelectButton = new JButton());
        
        projectTraitsFileSelectButton.setName("projectTraitsFileSelectButton");
        projectTraitsFileSelectButton.setText(_("coser.ui.common.selectFile"));
        projectTraitsFileSelectButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__projectTraitsFileSelectButton"));
    }

    protected void createReferenceSpeciesDescriptionLabel() {
        $objectMap.put("referenceSpeciesDescriptionLabel", referenceSpeciesDescriptionLabel = new JLabel());
        
        referenceSpeciesDescriptionLabel.setName("referenceSpeciesDescriptionLabel");
        referenceSpeciesDescriptionLabel.setText(_("coser.ui.project.usedReferenceSpeciesFile"));
    }

    protected void createReferenceSpeciesFileLabel() {
        $objectMap.put("referenceSpeciesFileLabel", referenceSpeciesFileLabel = new JLabel());
        
        referenceSpeciesFileLabel.setName("referenceSpeciesFileLabel");
    }

    protected void createUseCustomReferenceFilePanel() {
        $objectMap.put("useCustomReferenceFilePanel", useCustomReferenceFilePanel = new Table());
        
        useCustomReferenceFilePanel.setName("useCustomReferenceFilePanel");
    }

    protected void createValidatorProject() {
        $objectMap.put("validatorProject", validatorProject = SwingValidatorUtil.newValidator(Project.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToValidatorProject();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(projectProjectName), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(projectAuthor), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(projectCatchFile), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(projectCapturesSelectButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(projectStrataFile), new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(projectStratesFileSelectButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(projectLengthFile), new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(projectSizeFileSelectButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel6, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(projectHaulFile), new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(projectTraitsFileSelectButton, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel7, new GridBagConstraints(0, 6, 1, 2, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 6, 2, 2, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton0, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton1, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(referenceSpeciesDescriptionLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(referenceSpeciesFileLabel, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(useCustomReferenceFilePanel, new GridBagConstraints(0, 9, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel8, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane1, new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(createProjectButton, new GridBagConstraints(0, 11, 4, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(loadProgressBar, new GridBagConstraints(0, 12, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(projectMaps);
        addChildrenToUseCustomReferenceFilePanel();
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(projectComment);
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        $Table1.setBorder(BorderFactory.createTitledBorder(_("coser.ui.project.newProject")));
        $JLabel1.setText(_(getContextValue(fr.ifremer.coser.CoserConfig.class).getProjectsDirectory().getAbsolutePath() + java.io.File.separator));
        projectMaps.setModel(projectMapsModel);
        referenceSpeciesFileLabel.setText(_(getContextValue(fr.ifremer.coser.CoserConfig.class).getReferenceSpeciesPath()));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createProject();
        createErrorsTableModel();
        createValidatorProject();
        customReferenceCheckBox = new JCheckBox(_("coser.ui.project.useCustomReferenceSpeciesFile"));
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.project.projectname"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        createProjectProjectName();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = projectProjectName.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.project.projectauthor"));
        createProjectAuthor();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = projectAuthor.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("coser.ui.project.catchFile"));
        createProjectCatchFile();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = projectCatchFile.getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        createProjectCapturesSelectButton();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("coser.ui.project.strataFile"));
        createProjectStrataFile();
        // inline creation of $Document3
        $objectMap.put("$Document3", $Document3 = projectStrataFile.getDocument());
        
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document3"));
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document3"));
        createProjectStratesFileSelectButton();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("coser.ui.project.lengthFile"));
        createProjectLengthFile();
        // inline creation of $Document4
        $objectMap.put("$Document4", $Document4 = projectLengthFile.getDocument());
        
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document4"));
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document4"));
        createProjectSizeFileSelectButton();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("coser.ui.project.haulFile"));
        createProjectHaulFile();
        // inline creation of $Document5
        $objectMap.put("$Document5", $Document5 = projectHaulFile.getDocument());
        
        $Document5.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document5"));
        $Document5.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document5"));
        createProjectTraitsFileSelectButton();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("coser.ui.project.maps"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createProjectMapsModel();
        createProjectMaps();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.project.addMaps"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("coser.ui.project.removeMaps"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createReferenceSpeciesDescriptionLabel();
        createReferenceSpeciesFileLabel();
        createUseCustomReferenceFilePanel();
        createCustomReferenceSpeciesFileLabel();
        createCustomReferenceSpeciesFileTextField();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("coser.ui.common.selectFile"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("coser.ui.project.projectcomment"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createProjectComment();
        // inline creation of $Document6
        $objectMap.put("$Document6", $Document6 = projectComment.getDocument());
        
        $Document6.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document6"));
        $Document6.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document6"));
        createCreateProjectButton();
        createLoadProgressBar();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_PROJECT_NAME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    SwingUtil.setText(projectProjectName, getProject().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_AUTHOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("author", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    SwingUtil.setText(projectAuthor, getProject().getAuthor());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("author", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_CATCH_FILE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("catchFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    SwingUtil.setText(projectCatchFile, getProject().getCatchFile());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("catchFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_STRATA_FILE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("strataFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    SwingUtil.setText(projectStrataFile, getProject().getStrataFile());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("strataFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_LENGTH_FILE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("lengthFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    SwingUtil.setText(projectLengthFile, getProject().getLengthFile());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("lengthFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_HAUL_FILE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getProject() != null) {
                    getProject().addPropertyChangeListener("haulFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProject() != null) {
                    SwingUtil.setText(projectHaulFile, getProject().getHaulFile());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getProject() != null) {
                    getProject().removePropertyChangeListener("haulFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON1_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getProjectMaps() != null) {
                    $bindingSources.put("getProjectMaps().getSelectionModel()", getProjectMaps().getSelectionModel());
                    getProjectMaps().getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    getProjectMaps().addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_$JBUTTON1_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getProjectMaps() != null && getProjectMaps().getSelectedIndices() != null) {
                    $JButton1.setEnabled(getProjectMaps().getSelectedIndices().length != 0);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getProjectMaps() != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("getProjectMaps().getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    getProjectMaps().removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_$JBUTTON1_ENABLED));
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REFERENCE_SPECIES_DESCRIPTION_LABEL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("customReferenceCheckBox", this);
                if (customReferenceCheckBox != null) {
                    $bindingSources.put("customReferenceCheckBox.getModel()", customReferenceCheckBox.getModel());
                    customReferenceCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    customReferenceCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_REFERENCE_SPECIES_DESCRIPTION_LABEL_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (customReferenceCheckBox != null) {
                    referenceSpeciesDescriptionLabel.setEnabled(!customReferenceCheckBox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("customReferenceCheckBox", this);
                if (customReferenceCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("customReferenceCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    customReferenceCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_REFERENCE_SPECIES_DESCRIPTION_LABEL_ENABLED));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REFERENCE_SPECIES_FILE_LABEL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("customReferenceCheckBox", this);
                if (customReferenceCheckBox != null) {
                    $bindingSources.put("customReferenceCheckBox.getModel()", customReferenceCheckBox.getModel());
                    customReferenceCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    customReferenceCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_REFERENCE_SPECIES_FILE_LABEL_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (customReferenceCheckBox != null) {
                    referenceSpeciesFileLabel.setEnabled(!customReferenceCheckBox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("customReferenceCheckBox", this);
                if (customReferenceCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("customReferenceCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    customReferenceCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_REFERENCE_SPECIES_FILE_LABEL_ENABLED));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CUSTOM_REFERENCE_SPECIES_FILE_LABEL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("customReferenceCheckBox", this);
                if (customReferenceCheckBox != null) {
                    $bindingSources.put("customReferenceCheckBox.getModel()", customReferenceCheckBox.getModel());
                    customReferenceCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    customReferenceCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_CUSTOM_REFERENCE_SPECIES_FILE_LABEL_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (customReferenceCheckBox != null) {
                    customReferenceSpeciesFileLabel.setEnabled(customReferenceCheckBox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("customReferenceCheckBox", this);
                if (customReferenceCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("customReferenceCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    customReferenceCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_CUSTOM_REFERENCE_SPECIES_FILE_LABEL_ENABLED));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CUSTOM_REFERENCE_SPECIES_FILE_TEXT_FIELD_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("customReferenceCheckBox", this);
                if (customReferenceCheckBox != null) {
                    $bindingSources.put("customReferenceCheckBox.getModel()", customReferenceCheckBox.getModel());
                    customReferenceCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    customReferenceCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_CUSTOM_REFERENCE_SPECIES_FILE_TEXT_FIELD_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (customReferenceCheckBox != null) {
                    customReferenceSpeciesFileTextField.setEnabled(customReferenceCheckBox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("customReferenceCheckBox", this);
                if (customReferenceCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("customReferenceCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    customReferenceCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_CUSTOM_REFERENCE_SPECIES_FILE_TEXT_FIELD_ENABLED));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON2_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("customReferenceCheckBox", this);
                if (customReferenceCheckBox != null) {
                    $bindingSources.put("customReferenceCheckBox.getModel()", customReferenceCheckBox.getModel());
                    customReferenceCheckBox.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    customReferenceCheckBox.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (customReferenceCheckBox != null) {
                    $JButton2.setEnabled(customReferenceCheckBox.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("customReferenceCheckBox", this);
                if (customReferenceCheckBox != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("customReferenceCheckBox.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    customReferenceCheckBox.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.coser.ui.project.ProjectCreationView.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}