/*
 * #%L
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.control;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

import fr.ifremer.coser.CoserConstants.Category;
import fr.ifremer.coser.CoserConstants.ValidationLevel;
import fr.ifremer.coser.control.ControlErrorGroup;
import fr.ifremer.coser.control.ControlError;

/**
 * Global validation table model.
 * 
 * @author chatellier
 * @version $Revision$
 * 
 * Last update : $Date$
 * By : $Author$
 */
public class GlobalControlErrorModel extends AbstractTreeTableModel {

    protected List<ControlError> controlErrors;
    protected List<Object> controlErrorCategory;
    protected Map<Object, List<ControlErrorGroup>> controlCategoryChild;
    protected Map<ControlErrorGroup, List<ControlError>> controlErrorsChilds;
    protected Set<Object> checkedControlErrors;

    public GlobalControlErrorModel() {
        super(1);
    }

    public void setControlErrors(List<ControlError> controlErrors) {
        this.controlErrors = controlErrors;
        getValidationErrorAsMaps(controlErrors);
        modelSupport.fireNewRoot();
        
    }

    public List<ControlError> getControlErrors() {
        return controlErrors;
    }

    /**
     * Convert error list to tree structure.
     * 
     * @param validationErrors list to convert
     */
    protected void getValidationErrorAsMaps(List<ControlError> validationErrors) {

        controlCategoryChild = new HashMap<Object, List<ControlErrorGroup>>();
        controlErrorsChilds = new HashMap<ControlErrorGroup, List<ControlError>>();

        for (ControlError validationError : validationErrors) {
            
            Object category = validationError.getCategory() == null ?
                    n_("coser.ui.control.error.allCategories") : validationError.getCategory();
            List<ControlErrorGroup> errorGroup = controlCategoryChild.get(category);
            if (errorGroup == null) {
                errorGroup = new ArrayList<ControlErrorGroup>();
                controlCategoryChild.put(category, errorGroup);
            }

            ControlErrorGroup group = new ControlErrorGroup(validationError.getCategory(), validationError.getLevel(), validationError.getMessage());

            List<ControlError> childErrors = controlErrorsChilds.get(group);
            if (childErrors == null) {
                childErrors = new ArrayList<ControlError>();
                controlErrorsChilds.put(group, childErrors);
                errorGroup.add(group);
            }
            
            childErrors.add(validationError);
        }
        
        controlErrorCategory = new ArrayList<Object>(controlCategoryChild.keySet());
        Collections.sort(controlErrorCategory, new Comparator<Object>() {
            @Override
            public int compare(Object o1, Object o2) {
                int result = -1;
                if (o1 instanceof String) {
                    if (o2 instanceof String) {
                        result = ((String)o1).compareTo((String)o2);
                    }
                }
                else if (o1 instanceof Category) {
                    if (o2 instanceof Category) {
                        result = ((Category)o1).compareTo((Category)o2);
                    }
                }
                return result;
            }
        
        });
        for (List<ControlErrorGroup> groups : controlCategoryChild.values()) {
            Collections.sort(groups);
        }
        checkedControlErrors = new HashSet<Object>();
    }

    /*
     * @see javax.swing.table.TableModel#getColumnCount()
     */
    @Override
    public int getColumnCount() {
        return 2;
    }

    
    @Override
    public String getColumnName(int columnIndex) {

        String result = null;

        switch (columnIndex) {
        case 0:
            result = _("coser.ui.control.global.message");
            break;
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<?> result = null;

        switch (columnIndex) {
        case 0:
            result = ValidationLevel.class;
            break;
        case 1:
            result = Boolean.class;
            break;
        }
        return result;
    }

    /*
     * @see org.jdesktop.swingx.treetable.TreeTableModel#getValueAt(java.lang.Object, int)
     */
    @Override
    public Object getValueAt(Object node, int column) {

        Object result = null;

        switch (column) {
        case 0:
            result = node;
            break;
        default:
            result = checkedControlErrors.contains(node);
            break;
        }

        return result;
    }

    /*
     * @see javax.swing.tree.TreeModel#getChild(java.lang.Object, int)
     */
    @Override
    public Object getChild(Object parent, int index) {

        Object result = null;

        if (parent == getRoot()) {
            result = controlErrorCategory.get(index);
        }
        else if (parent instanceof String || parent instanceof Category) {
            result = controlCategoryChild.get(parent).get(index);
        }
        else if (parent instanceof ControlErrorGroup) {
            List<ControlError> childError = controlErrorsChilds.get(parent);
            result = childError.get(index);
        }

        return result;
    }

    /*
     * @see javax.swing.tree.TreeModel#getChildCount(java.lang.Object)
     */
    @Override
    public int getChildCount(Object parent) {
        int result = 0;

        if (parent == getRoot()) {
            if (controlErrorCategory != null) {
                result = controlErrorCategory.size();
            }
        }
        else if (parent instanceof String || parent instanceof Category) {
            result = controlCategoryChild.get(parent).size();
        }
        else if (parent instanceof ControlErrorGroup) {
            List<ControlError> childError = controlErrorsChilds.get(parent);
            result = childError.size();
        }

        return result;
    }

    /*
     * @see javax.swing.tree.TreeModel#getIndexOfChild(java.lang.Object, java.lang.Object)
     */
    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int result = -1;

        if (parent == getRoot()) {
            result = controlErrorCategory.indexOf(child);
        }
        else if (parent instanceof String || parent instanceof Category) {
            result = controlCategoryChild.get(parent).indexOf(child);
        }
        else if (parent instanceof ControlErrorGroup) {
            List<ControlError> childError = controlErrorsChilds.get(parent);
            result = childError.indexOf(child);
        }

        return result;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        boolean result = false;
        if (column == 1) {
            result = true;
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, Object node, int column) {
        
        Boolean booleanValue = (Boolean)value;
        if (booleanValue.booleanValue()) {
            checkedControlErrors.add(node);
        }
        else {
            checkedControlErrors.remove(node);
        }

        // recursive check of sub errors
        if (node instanceof String || node instanceof Category || node instanceof ControlErrorGroup) {
            int childCount = getChildCount(node);
            for (int i = 0 ; i < childCount; ++i) {
                Object child = getChild(node, i);
                setValueAt(value, child, column);
            }
        }
    }
}
