/*
 * #%L
 * $Id: DataHandler.java 885 2011-10-27 15:15:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.2.3/coser-ui/src/main/java/fr/ifremer/coser/ui/common/DataHandler.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.common;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import jaxx.runtime.JAXXContext;

import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixViewerPanel;
import org.nuiton.math.matrix.viewer.renderer.MatrixChartRenderer;
import org.nuiton.math.matrix.viewer.renderer.MatrixPanelRenderer;
import org.nuiton.widget.SwingSession;

import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.services.ProjectService;

/**
 * Data application handler.
 * 
 * @author chatellier
 * @version $Revision: 885 $
 * 
 * Last update : $Date: 2011-10-27 17:15:16 +0200 (Thu, 27 Oct 2011) $
 * By : $Author: echatellier $
 */
public class DataHandler extends CommonHandler {

    /**
     * Display lengthStructure matrix in matrixviewerpanel.
     * 
     * @param parent parent component
     * @param session session to restore frame state
     * @param projectService projectService
     * @param project project
     * @param container data container
     */
    public void displayLengthStructureGraph(final Component parent, final SwingSession session,
            final ProjectService projectService, final Project project, final AbstractDataContainer container) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                try {
                    setWaitCursor(parent);

                    // get matrix
                    MatrixND matrix = projectService.getLengthStructure(project, container);

                    // close previous opened
                    JFrame previousFrame = (JFrame)((JAXXContext)parent).getContextValue(JFrame.class, "lengthstructureframe");
                    if (previousFrame != null) {
                        previousFrame.dispose();
                    }

                    // display matrix viewer component
                    JFrame matrixViewerFrame = new JFrame(_("coser.ui.graph.lengthStructure"));
                    matrixViewerFrame.setName("lengthstructureframe");
                    MatrixViewerPanel panel = new MatrixViewerPanel();
                    panel.addMatrixRenderer(new MatrixChartRenderer());
                    panel.addMatrixRenderer(new MatrixPanelRenderer());
                    panel.addMatrixFilter(new LengthStructureMatrixFilter(project, container));
                    panel.setMatrix(matrix);
                    matrixViewerFrame.add(panel);
                    matrixViewerFrame.pack();
                    matrixViewerFrame.setLocationRelativeTo(parent);
                    session.add(matrixViewerFrame); // session restore
                    matrixViewerFrame.toFront();
                    matrixViewerFrame.setVisible(true);

                    // register current frame
                    ((JAXXContext)parent).setContextValue(matrixViewerFrame, "lengthstructureframe");
                }
                finally {
                    setDefaultCursor(parent);
                }
            }
        });
    }
}
